/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.services.editpart;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.editpart.IEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractEditPartProvider
extends AbstractProvider
implements IEditPartProvider,
Properties {
    public IGraphicalEditPart createGraphicEditPart(View view) {
        Class editpartClass = this.getEditPartClass(view);
        IGraphicalEditPart graphicEditPart = this.createNewGraphicEditPart(editpartClass, new Object[]{view});
        Assert.isNotNull((Object)graphicEditPart);
        return graphicEditPart;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof CreateGraphicEditPartOperation) {
            View view = ((IEditPartOperation)operation).getView();
            return this.getEditPartClass(view) != null;
        }
        return false;
    }

    private Class getEditPartClass(View view) {
        if (view instanceof Diagram) {
            return this.getDiagramEditPartClass(view);
        }
        if (view instanceof Edge) {
            return this.getEdgeEditPartClass(view);
        }
        if (view instanceof Node) {
            return this.getNodeEditPartClass(view);
        }
        return null;
    }

    protected Class getEdgeEditPartClass(View view) {
        return null;
    }

    protected Class getDiagramEditPartClass(View view) {
        return null;
    }

    protected Class getNodeEditPartClass(View view) {
        return null;
    }

    private IGraphicalEditPart createNewGraphicEditPart(Class editpartClass, Object[] constructorParams) {
        try {
            Constructor constructor = this.getCreationConstructor(editpartClass);
            Assert.isNotNull((Object)constructor);
            return constructor == null ? null : (IGraphicalEditPart)constructor.newInstance(constructorParams);
        }
        catch (Throwable e) {
            String eMsg = NLS.bind((String)DiagramUIMessages.AbstractEditPartProvider_new_graphicaleditpart_failed_ERROR_, (Object)editpartClass);
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)2, (String)eMsg, (Throwable)e);
            return null;
        }
    }

    private Constructor getCreationConstructor(Class editpartClass) {
        Constructor<?>[] consts;
        Assert.isNotNull((Object)editpartClass);
        if (editpartClass != null && (consts = editpartClass.getConstructors()).length != 0) {
            return consts[0];
        }
        return null;
    }

    protected static EClass getReferencedElementEClass(View view) {
        return EMFCoreUtil.getProxyClass((EObject)view.getElement());
    }

    public RootEditPart createRootEditPart(Diagram diagram) {
        return null;
    }
}

