/******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/
package org.eclipse.gmf.runtime.draw2d.ui.internal.graph;

import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.graph.Subgraph;

/**
 * @author mmostafa
 * Advanced node introduce the AutoSize feature to the Draw2d SubGraph 
 *
 */
public class AdvancedSubGraph
    extends Subgraph {
    
    private boolean autoSize = false;
    private boolean hadBufferZone = false;
    private int direction = PositionConstants.SOUTH;
    
    public AdvancedSubGraph(Object data) {
        super(data, null);
    }

    public AdvancedSubGraph(Object data, Subgraph parent) {
        super(data, parent);
    }
    
    /**
     * set the auto size field
     * @param newValue
     */
    public void setAutoSize(boolean newValue){
        autoSize = newValue;
    }
    
    /**
     * access the auto size field
     * @return true is auto size is ON other wise false
     */
    public boolean isAutoSize(){
        return autoSize;
    }
    
    /**
     * set the AHs Buffered Zone field
     * @param newValue
     */
    public void setHasBufferedZone(boolean newValue){
        hadBufferZone = newValue;
    }
    
    /**
     * access the had buffered zone field
     * @return true is auto size is ON other wise false
     */
    public boolean isHasBufferedZone(){
        return hadBufferZone;
    }

	/**
	 * Gets the subgraph layout direction
	 * 
	 * @return layout direction
	 */
	public int getDirection() {
		return direction;
	}

	/**
	 * Sets the direction for the subgraph's layout
	 * 
	 * @param direction
	 */
	public void setDirection(int direction) {
		this.direction = direction;
	}

}
