/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action.actions.global;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalUndoRedoLock;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalAction;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.operations.RedoActionHandler;

public final class GlobalRedoAction
extends GlobalAction {
    private RedoActionHandler delegate;
    private IUndoContext undoContext;
    private IPropertyChangeListener listener;

    public GlobalRedoAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public GlobalRedoAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    @Override
    public String getActionId() {
        return GlobalActionId.REDO;
    }

    protected void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        super.setWorkbenchPart(workbenchPart);
        this.initializeWithContext(this.getUndoContext());
    }

    protected void initializeWithContext(IUndoContext context) {
        boolean enabled;
        IWorkbenchPart part;
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(this.getDelegateListener());
            this.delegate.dispose();
            this.delegate = null;
        }
        if (context != null && (part = this.getWorkbenchPart()) != null) {
            this.delegate = new RedoActionHandler(part.getSite(), context);
            this.delegate.setPruneHistory(true);
            this.delegate.addPropertyChangeListener(this.getDelegateListener());
        }
        this.firePropertyChange("enabled", !(enabled = this.isEnabled()), enabled);
    }

    private IPropertyChangeListener getDelegateListener() {
        if (this.listener == null) {
            this.listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    GlobalRedoAction.this.firePropertyChange(event.getProperty(), event.getOldValue(), event.getNewValue());
                }
            };
        }
        return this.listener;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.delegate != null) {
            return this.delegate.getImageDescriptor();
        }
        return null;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        if (this.delegate != null) {
            return this.delegate.getDisabledImageDescriptor();
        }
        return null;
    }

    public ImageDescriptor getHoverImageDescriptor() {
        if (this.delegate != null) {
            return this.delegate.getHoverImageDescriptor();
        }
        return null;
    }

    public String getText() {
        if (this.delegate != null) {
            return this.delegate.getText();
        }
        return null;
    }

    public String getToolTipText() {
        if (this.delegate != null) {
            return this.delegate.getToolTipText();
        }
        return null;
    }

    public String getDescription() {
        if (this.delegate != null) {
            return this.delegate.getDescription();
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.delegate != null) {
            return this.delegate.isEnabled();
        }
        return false;
    }

    public boolean isHandled() {
        if (this.delegate != null) {
            return this.delegate.isHandled();
        }
        return false;
    }

    public void setChecked(boolean checked) {
        if (this.delegate != null) {
            this.delegate.setChecked(checked);
        }
    }

    @Override
    protected void doRun(IProgressMonitor progressMonitor) {
        Object key;
        if (this.delegate != null && GlobalUndoRedoLock.INSTANCE.acquire(key = new Object())) {
            try {
                this.delegate.run();
            }
            finally {
                GlobalUndoRedoLock.INSTANCE.release(key);
            }
        }
    }

    @Override
    public void refresh() {
        if (this.delegate != null) {
            this.delegate.update();
        }
        this.setText(this.getText());
    }

    public final void setUndoContext(IUndoContext context) {
        this.undoContext = context;
        this.initializeWithContext(context);
    }

    @Override
    public final IUndoContext getUndoContext() {
        IWorkbenchPart part;
        if (this.undoContext == null && (part = this.getWorkbenchPart()) != null) {
            return (IUndoContext)part.getAdapter(IUndoContext.class);
        }
        return this.undoContext;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(this.getDelegateListener());
            this.delegate = null;
        }
        super.dispose();
    }

    public IActionWithProgress.WorkIndicatorType getWorkIndicatorType() {
        return IActionWithProgress.WorkIndicatorType.NONE;
    }
}

