/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCoreDebugOptions;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCorePlugin;
import org.eclipse.gmf.runtime.emf.core.resources.IExtendedResourceFactory;
import org.eclipse.gmf.runtime.emf.core.resources.IResourceHelper;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.core.util.Util;

public class EMFCoreUtil {
    public static EObject create(EObject container, EReference reference, EClass eClass) {
        EObject result = null;
        IResourceHelper helper = Util.getHelper(container.eResource());
        result = helper != null ? helper.create(eClass) : eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)reference)) {
            ((Collection)container.eGet((EStructuralFeature)reference)).add(result);
        } else {
            container.eSet((EStructuralFeature)reference, (Object)result);
        }
        return result;
    }

    public static EObject getContainer(EObject eObject, EClass eClass) {
        EObject parent = eObject;
        while (parent != null) {
            if (eClass.isInstance((Object)parent)) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public static EObject getLeastCommonContainer(Collection objects, EClass desiredContainerType) {
        EObject commonContainer = null;
        ArrayList prevContainers = new ArrayList();
        for (EObject element : objects) {
            ArrayList<EObject> containers = new ArrayList<EObject>();
            boolean found = false;
            EObject container = element;
            while (container != null) {
                EClass containerClass = container.eClass();
                if (desiredContainerType == containerClass || desiredContainerType.isSuperTypeOf(containerClass)) {
                    containers.add(container);
                    if (!found) {
                        if (prevContainers.isEmpty() || commonContainer == null) {
                            commonContainer = container;
                            found = true;
                        } else if (prevContainers.contains(container) && EcoreUtil.isAncestor((EObject)container, (EObject)commonContainer)) {
                            commonContainer = container;
                            found = true;
                        }
                    }
                }
                container = container.eContainer();
            }
            if (!found) {
                return null;
            }
            prevContainers = containers;
        }
        return commonContainer;
    }

    public static Collection getReferencers(EObject eObject, EReference[] features) {
        Collection settings;
        CrossReferenceAdapter crossReferenceAdapter = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)eObject);
        if (crossReferenceAdapter == null) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eObject);
            if (domain != null) {
                crossReferenceAdapter = CrossReferenceAdapter.getCrossReferenceAdapter(domain.getResourceSet());
            }
            if (crossReferenceAdapter == null) {
                return Collections.EMPTY_LIST;
            }
        }
        if (!(settings = crossReferenceAdapter.getInverseReferences(eObject)).isEmpty()) {
            int count;
            ArrayList<EObject> referencers = new ArrayList<EObject>();
            if (features != null && (count = features.length) != 0) {
                block0: for (EStructuralFeature.Setting setting : settings) {
                    EStructuralFeature feature = setting.getEStructuralFeature();
                    int i = 0;
                    while (i < count) {
                        if (feature == features[i]) {
                            referencers.add(setting.getEObject());
                            continue block0;
                        }
                        ++i;
                    }
                }
            } else {
                Iterator it = settings.iterator();
                while (it.hasNext()) {
                    referencers.add(((EStructuralFeature.Setting)it.next()).getEObject());
                }
            }
            return referencers;
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection getImports(Resource resource) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)resource);
        if (domain != null) {
            return CrossReferenceAdapter.getCrossReferenceAdapter(domain.getResourceSet()).getImports(resource);
        }
        return Collections.EMPTY_SET;
    }

    public static Collection getExports(Resource resource) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)resource);
        if (domain != null) {
            return CrossReferenceAdapter.getCrossReferenceAdapter(domain.getResourceSet()).getExports(resource);
        }
        return Collections.EMPTY_SET;
    }

    public static Collection getTransitiveImports(Resource resource) {
        HashSet result = new HashSet();
        HashSet unload = new HashSet();
        EMFCoreUtil.getTransitiveImports(resource, result, unload);
        Iterator i = unload.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).unload();
        }
        return result;
    }

    private static void getTransitiveImports(Resource resource, Collection imports, Collection unload) {
        if (!resource.isLoaded()) {
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (Exception exception) {
                // empty catch block
            }
            unload.add(resource);
        }
        Collection directImports = EMFCoreUtil.getImports(resource);
        for (Resource directImport : directImports) {
            if (imports.contains(directImport)) continue;
            imports.add(directImport);
            EMFCoreUtil.getTransitiveImports(directImport, imports, unload);
        }
    }

    public static Collection getTransitiveExports(Resource resource) {
        HashSet result = new HashSet();
        HashSet unload = new HashSet();
        EMFCoreUtil.getTransitiveExports(resource, result, unload);
        Iterator i = unload.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).unload();
        }
        return result;
    }

    private static void getTransitiveExports(Resource resource, Collection exports, Collection unload) {
        if (!resource.isLoaded()) {
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (Exception exception) {
                // empty catch block
            }
            unload.add(resource);
        }
        Collection directExports = EMFCoreUtil.getExports(resource);
        for (Resource directExport : directExports) {
            if (exports.contains(directExport)) continue;
            exports.add(directExport);
            EMFCoreUtil.getTransitiveExports(directExport, exports, unload);
        }
    }

    public static String getName(EObject eObject) {
        String name;
        if (eObject == null) {
            return "";
        }
        if (eObject.eIsProxy()) {
            return EMFCoreUtil.getProxyName(eObject);
        }
        EAttribute nameAttribute = PackageUtil.getNameAttribute(eObject.eClass());
        if (nameAttribute != null && (name = (String)eObject.eGet((EStructuralFeature)nameAttribute)) != null) {
            return name;
        }
        return "";
    }

    private static String getProxyName(EObject proxy) {
        URI uri = EcoreUtil.getURI((EObject)proxy);
        Resource.Factory factory = null;
        ResourceSet rs = null;
        Resource r = proxy.eResource();
        if (r != null) {
            rs = r.getResourceSet();
        }
        if (rs != null) {
            factory = rs.getResourceFactoryRegistry().getFactory(uri);
        }
        if (factory == null) {
            factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
        }
        String result = null;
        if (factory instanceof IExtendedResourceFactory) {
            result = ((IExtendedResourceFactory)factory).getProxyName(proxy);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static void setName(EObject eObject, String name) {
        EAttribute nameAttribute = PackageUtil.getNameAttribute(eObject.eClass());
        if (nameAttribute == null) {
            IllegalArgumentException e = new IllegalArgumentException("object has no name attribute");
            Trace.throwing((Plugin)EMFCorePlugin.getDefault(), (String)EMFCoreDebugOptions.EXCEPTIONS_THROWING, EMFCoreUtil.class, (String)"setName", (Throwable)e);
            throw e;
        }
        eObject.eSet((EStructuralFeature)nameAttribute, (Object)name);
    }

    public static String getQualifiedName(EObject eObject, boolean formatted) {
        EAttribute qNameAttribute;
        if (eObject.eIsProxy()) {
            return EMFCoreUtil.getProxyQualifiedName(eObject);
        }
        if (!formatted && (qNameAttribute = PackageUtil.getQualifiedNameAttribute(eObject.eClass())) != null) {
            String qualifiedName = (String)eObject.eGet((EStructuralFeature)qNameAttribute);
            if (qualifiedName != null) {
                return qualifiedName;
            }
            return "";
        }
        String prefix = "";
        EObject eContainer = eObject.eContainer();
        while (eContainer != null && eContainer instanceof EAnnotation) {
            eContainer = eContainer.eContainer();
        }
        if (eContainer != null) {
            prefix = EMFCoreUtil.getQualifiedName(eContainer, formatted);
        }
        Object name = EMFCoreUtil.getName(eObject);
        if (formatted && ((String)name).equals("")) {
            name = "<" + PackageUtil.getLocalizedName((ENamedElement)eObject.eClass()) + ">";
        }
        return prefix.length() == 0 ? name : prefix + (String)(((String)name).equals("") ? "" : "::" + (String)name);
    }

    private static String getProxyQualifiedName(EObject proxy) {
        URI uri = EcoreUtil.getURI((EObject)proxy);
        Resource.Factory factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
        String result = null;
        if (factory instanceof IExtendedResourceFactory) {
            result = ((IExtendedResourceFactory)factory).getProxyQualifiedName(proxy);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String getProxyID(EObject proxy) {
        if (proxy == null) {
            return "";
        }
        if (!proxy.eIsProxy() && proxy.eResource() instanceof XMLResource) {
            XMLResource res = (XMLResource)proxy.eResource();
            if (res == null) {
                return "";
            }
            String id = res.getID(proxy);
            if (id == null || id.length() == 0) {
                return res.getURIFragment(proxy);
            }
        }
        Resource.Factory factory = null;
        URI uri = EcoreUtil.getURI((EObject)proxy);
        if (uri != null) {
            Resource.Factory.Registry registry;
            ResourceSet resourceSet;
            Resource resource = proxy.eResource();
            if (resource != null && (resourceSet = resource.getResourceSet()) != null && (registry = resourceSet.getResourceFactoryRegistry()) != null) {
                factory = registry.getFactory(uri);
            }
            if (factory == null) {
                factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
            }
        }
        String result = null;
        if (factory instanceof IExtendedResourceFactory) {
            result = ((IExtendedResourceFactory)factory).getProxyID(proxy);
        }
        if (result == null) {
            result = Util.getProxyID(proxy);
        }
        return result;
    }

    public static EClass getProxyClass(EObject proxy) {
        ENamedElement element;
        if (proxy == null) {
            return null;
        }
        if (!proxy.eIsProxy()) {
            return proxy.eClass();
        }
        URI uri = EcoreUtil.getURI((EObject)proxy);
        Resource.Factory factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
        String id = null;
        if (factory instanceof IExtendedResourceFactory) {
            id = ((IExtendedResourceFactory)factory).getProxyClassID(proxy);
        }
        if (id == null) {
            id = PackageUtil.getID((ENamedElement)proxy.eClass());
        }
        if (id != null && (element = PackageUtil.getElement(id)) != null && element instanceof EClass) {
            return (EClass)element;
        }
        return null;
    }

    public static EObject createProxy(EClass eClass, URI uri) {
        InternalEObject proxy = (InternalEObject)eClass.getEPackage().getEFactoryInstance().create(eClass);
        proxy.eSetProxyURI(uri);
        return proxy;
    }

    public static EObject resolve(TransactionalEditingDomain domain, EObject proxy) {
        if (proxy == null) {
            return null;
        }
        if (!proxy.eIsProxy()) {
            return proxy;
        }
        URI uri = EcoreUtil.getURI((EObject)proxy);
        Resource.Factory factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
        if (factory instanceof IExtendedResourceFactory) {
            return ((IExtendedResourceFactory)factory).resolve(domain, proxy);
        }
        return Util.resolve(domain, proxy);
    }
}

