/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages.simple;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.internal.bridge.resolver.NodePattern;
import org.eclipse.gmf.internal.bridge.resolver.TypeLinkPattern;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.ResolvedItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiagramElementSelector {
    private ResolvedItem domainModel;
    Combo control;
    private Button excludeContainedNodesChoice;
    private Button excludeLinksChoice;

    DiagramElementSelector() {
    }

    public void createControl(Composite plate) {
        Label diagramElementLabel = new Label(plate, 0);
        diagramElementLabel.setText(Messages.DiagramElementSelectorElement);
        diagramElementLabel.setLayoutData((Object)new GridData());
        this.control = new Combo(plate, 4);
        this.control.setLayoutData((Object)this.createFillHorzGridData());
        this.excludeContainedNodesChoice = this.createChoice(plate, Messages.DiagramElementSelectorExContainedNodes);
        this.excludeLinksChoice = this.createChoice(plate, Messages.DiagramElementSelectorExLinks);
    }

    private Button createChoice(Composite plate, String text) {
        Label dummy = new Label(plate, 0);
        dummy.setLayoutData((Object)new GridData());
        Button choice = new Button(plate, 32);
        choice.setText(text);
        choice.setLayoutData((Object)this.createFillHorzGridData());
        choice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagramElementSelector.this.updateDiagramElements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return choice;
    }

    protected GridData createFillHorzGridData() {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    public ResolvedItem getDiagramElement() {
        return this.domainModel == null ? null : this.findResolvedItemByTypeName(this.domainModel, this.control.getText());
    }

    public void setDomainModel(ResolvedItem domainModel) {
        this.domainModel = domainModel;
        this.updateDiagramElements();
    }

    private void updateDiagramElements() {
        TreeSet<ResolvedItem> types = new TreeSet<ResolvedItem>(new Comparator<ResolvedItem>(){

            @Override
            public int compare(ResolvedItem arg0, ResolvedItem arg1) {
                EClass type0 = (EClass)arg0.getDomainRef();
                EClass type1 = (EClass)arg1.getDomainRef();
                return type0.getName().compareToIgnoreCase(type1.getName());
            }
        });
        if (this.domainModel != null) {
            this.collectResolvedDomainTypes(types, this.domainModel);
        }
        String contents = this.control.getText();
        this.control.removeAll();
        Iterator it = types.iterator();
        while (it.hasNext()) {
            EClass type = (EClass)((ResolvedItem)it.next()).getDomainRef();
            this.control.add(type.getName());
            if (!contents.equals(type.getName())) continue;
            this.control.setText(contents);
        }
    }

    private void collectResolvedDomainTypes(Collection<ResolvedItem> types, ResolvedItem item) {
        if (item.getDomainRef() instanceof EClass) {
            boolean ignore = false;
            if (this.excludeContainedNodesChoice.getSelection()) {
                ignore |= item.getPattern() instanceof NodePattern;
            }
            if (this.excludeLinksChoice.getSelection()) {
                ignore |= item.getPattern() instanceof TypeLinkPattern;
            }
            if (!ignore) {
                types.add(item);
            }
        }
        Iterator<ResolvedItem> it = item.getChildren().iterator();
        while (it.hasNext()) {
            this.collectResolvedDomainTypes(types, it.next());
        }
    }

    private ResolvedItem findResolvedItemByTypeName(ResolvedItem item, String typeName) {
        if (item.getDomainRef() instanceof EClass && ((EClass)item.getDomainRef()).getName().equals(typeName)) {
            return item;
        }
        Iterator<ResolvedItem> it = item.getChildren().iterator();
        while (it.hasNext()) {
            ResolvedItem result = this.findResolvedItemByTypeName(it.next(), typeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

