/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.importer.ui.EMFModelWizard;
import org.eclipse.emf.importer.ui.GenModelReloadActionDelegate;
import org.eclipse.gmf.internal.bridge.transform.GenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.ModelConfigurationPage;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

class GenModelConfigurationPage
extends ModelConfigurationPage {
    private static final String FILE_EXT_ECORE = "ecore";
    private static final String FILE_EXT_GENMODEL = "genmodel";
    private Button createWizardBtn;
    private Button createDefaultBtn;
    private Button refreshStaleBtn;

    GenModelConfigurationPage(String pageId, ResourceLocationProvider rlp, ResourceSet resourceSet) {
        super(pageId, rlp, resourceSet);
        this.setTitle(Messages.TransformToGenModelWizard_title_genmodel);
        this.setDescription(Messages.TransformToGenModelWizard_descr_genmodel);
    }

    protected String getModelFileExtension() {
        return FILE_EXT_GENMODEL;
    }

    protected void createAdditionalControls(Composite parent) {
        Composite createComposite = new Composite(parent, 0);
        createComposite.setLayout((Layout)new GridLayout(2, true));
        createComposite.setLayoutData((Object)this.createGridData());
        this.createWizardBtn = new Button(createComposite, 8);
        this.createWizardBtn.setText(Messages.GenModelConfigurationPage_btn_new_wizard);
        this.setButtonLayoutData(this.createWizardBtn);
        this.createDefaultBtn = new Button(createComposite, 8);
        this.createDefaultBtn.setText(Messages.GenModelConfigurationPage_btn_create_default);
        this.setButtonLayoutData(this.createDefaultBtn);
        this.refreshStaleBtn = new Button(createComposite, 8);
        this.refreshStaleBtn.setText(Messages.GenModelConfigurationPage_btn_refresh_stale);
        this.setButtonLayoutData(this.refreshStaleBtn);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenModelConfigurationPage.this.handleSelection(e.widget);
            }
        };
        this.createWizardBtn.addSelectionListener((SelectionListener)selectionAdapter);
        this.createDefaultBtn.addSelectionListener((SelectionListener)selectionAdapter);
        this.refreshStaleBtn.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private GridData createGridData() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    void handleSelection(Widget w) {
        if (this.createDefaultBtn.equals(w)) {
            this.createDefault();
        } else if (this.createWizardBtn.equals(w)) {
            this.launchWizard();
        } else if (this.refreshStaleBtn.equals(w)) {
            this.refreshGenmodel();
        }
    }

    protected void initControls() {
        super.initControls();
        if (this.getURI() == null) {
            this.findGenmodel();
        } else {
            this.updateControls();
        }
    }

    void findGenmodel() {
        try {
            GenModel genModel = this.getOperation().findGenmodel(this.getResourceSet());
            if (genModel != null) {
                Resource r = genModel.eResource();
                URI genURI = r.getURI();
                this.setURI(genURI);
                this.updateURI();
            } else {
                this.setPageComplete(true);
                this.updateControls();
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            this.updateControls();
        }
    }

    protected void resourceChanged() {
        super.resourceChanged();
        this.updateControls();
        this.setPageComplete(this.getResource() != null);
    }

    private void updateControls() {
        IStatus stale;
        GenModelDetector gmd = this.getOperation().getGenModelDetector();
        if (gmd != null) {
            this.createDefaultBtn.setEnabled(gmd.canCreateDefault());
        }
        if ((stale = this.getOperation().getStaleGenmodelStatus()) != null && !stale.isOK()) {
            this.setStatusMessage(stale);
            this.refreshStaleBtn.setEnabled(this.getURI() != null);
        } else {
            this.refreshStaleBtn.setEnabled(false);
        }
    }

    protected Resource doLoadResource(IProgressMonitor monitor) throws CoreException {
        GenModel genModel = this.getOperation().loadGenModel(this.getResourceSet(), this.getURI(), monitor);
        if (genModel == null) {
            return null;
        }
        return genModel.eResource();
    }

    private void createDefault() {
        try {
            TransformToGenModelOperation to = this.getOperation();
            GenModelDetector gmd = to.getGenModelDetector();
            TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
            IFile mapFile = wizard.getMapFile();
            String pluginID = mapFile.getProject().getName();
            URI genURI = gmd.createDefault(pluginID, mapFile);
            this.setURI(genURI);
            this.updateURI();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    private void launchWizard() {
        TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
        IFile mapFile = wizard.getMapFile();
        IFile genmodel = GenModelConfigurationPage.createWithWizard(this.getShell(), mapFile);
        if (genmodel != null) {
            this.setURI(URI.createPlatformResourceURI((String)genmodel.getFullPath().toString(), (boolean)true));
            this.updateURI();
        }
    }

    private static IFile createWithWizard(Shell shell, IFile patternResource) {
        final IFile[] result = new IFile[1];
        EMFModelWizard wizard = new EMFModelWizard(){

            public boolean performFinish() {
                result[0] = ResourcesPlugin.getWorkspace().getRoot().getFile(this.genModelContainerPath.append(this.genModelFileName));
                return super.performFinish();
            }
        };
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)GenModelConfigurationPage.createSelectionForEMFWizard(patternResource));
        if (new WizardDialog(shell, (IWizard)wizard).open() == 0) {
            assert (result[0] != null);
            return result[0];
        }
        return null;
    }

    private static StructuredSelection createSelectionForEMFWizard(IFile patternResource) {
        IContainer parent = patternResource.getParent();
        IFile neighbour = parent.getFile(new Path(patternResource.getName()).removeFileExtension().addFileExtension(FILE_EXT_ECORE));
        if (neighbour.exists()) {
            return new StructuredSelection((Object)neighbour);
        }
        return new StructuredSelection((Object)patternResource);
    }

    private void refreshGenmodel() {
        IPath p = new Path(this.getURI().path()).removeFirstSegments(1);
        IFile genModelFile = ResourcesPlugin.getWorkspace().getRoot().getFile(p);
        GenModelReloadActionDelegate action = new GenModelReloadActionDelegate();
        Action uiAction = new Action(){};
        action.selectionChanged((IAction)uiAction, (ISelection)new StructuredSelection((Object)genModelFile));
        action.run((IAction)uiAction);
        this.updateURI();
    }

    private TransformToGenModelOperation getOperation() {
        TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
        return wizard.getTransformOperation();
    }
}

