/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.gmf.internal.common.ToolingResourceFactory;
import org.eclipse.gmf.internal.common.migrate.FeatureKey;
import org.eclipse.gmf.internal.common.migrate.Messages;
import org.eclipse.gmf.internal.common.migrate.MigrationConfig;
import org.eclipse.gmf.internal.common.migrate.MigrationUtil;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationResource
extends ToolingResourceFactory.ToolResource {
    protected boolean oldVersionDetected;
    protected boolean migrationApplied;
    private Map<EObject, Map<String, String>> ignoredAttributes;
    private MigrationConfig config;

    MigrationResource(URI uri) {
        super(uri);
    }

    protected XMLLoad createXMLLoad() {
        return new XMILoadImpl(this.createXMLHelper()){

            protected DefaultHandler makeDefaultHandler() {
                return new MigrationHandler(MigrationResource.this, this.helper, this.options);
            }
        };
    }

    protected final void doUnload() {
        try {
            super.doUnload();
        }
        finally {
            this.oldVersionDetected = false;
            this.migrationApplied = false;
        }
    }

    public final void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            try {
                this.ignoredAttributes = new HashMap<EObject, Map<String, String>>();
                super.doLoad(inputStream, options);
                this.handlePostLoad(null);
            }
            catch (IOException e) {
                this.handlePostLoad(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.handlePostLoad(e);
                throw e;
            }
        }
        finally {
            this.ignoredAttributes = null;
            this.config = null;
        }
    }

    protected void handleOldVersionDetected() {
        this.oldVersionDetected = true;
    }

    protected void handleMigrationPatchApplied() {
        this.migrationApplied = true;
    }

    protected void handlePostLoad(Exception exception) {
        if (exception == null && this.config != null) {
            this.config.handleResourceLoaded((Resource)this, this.ignoredAttributes);
        }
    }

    static Resource createCheckedResource(URI uri) {
        return new MigrationResource(uri){

            protected XMLLoad createXMLLoad() {
                final 2 res = this;
                return new XMILoadImpl(this.createXMLHelper()){

                    protected DefaultHandler makeDefaultHandler() {
                        return new BCKWDCompatibleHandler(res, this.helper, this.options);
                    }
                };
            }

            protected void handlePostLoad(Exception exception) {
                super.handlePostLoad(exception);
                if (this.oldVersionDetected && exception != null || !this.getErrors().isEmpty() || !this.getWarnings().isEmpty()) {
                    MigrationUtil.MigrationDiagnostic diagnostic = MigrationUtil.createMessageDiagnostic((Resource)this, Messages.oldModelVersionLoadErrorMigrationMayBeRequired);
                    this.getErrors().add(0, (Object)diagnostic);
                }
            }
        };
    }

    static Resource createCheckAndMigrateOnLoadResource(URI uri) {
        return new MigrationResource(uri){

            protected void handlePostLoad(Exception exception) {
                super.handlePostLoad(exception);
                if (this.oldVersionDetected && this.migrationApplied) {
                    MigrationUtil.MigrationDiagnostic diagnostic = MigrationUtil.createMessageDiagnostic((Resource)this, Messages.oldModelVersionLoadedMigrationRequired);
                    this.getWarnings().add(0, (Object)diagnostic);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BCKWDCompatibleHandler
    extends SAXXMIHandler {
        MigrationConfig config;
        protected boolean fixmePotentiallyCompatibilityIssues;

        BCKWDCompatibleHandler(MigrationResource xmiResource, XMLHelper helper, Map<?, ?> options) {
            super((XMLResource)xmiResource, helper, options);
        }

        protected EPackage getPackageForURI(String uriString) {
            if (this.config == null) {
                EPackage.Registry.INSTANCE.getEPackage(uriString);
                String ext = this.xmlResource.getURI().fileExtension();
                this.config = ext != null ? MigrationConfig.Registry.INSTANCE.getConfig(ext) : null;
                this.resource().config = this.config;
            }
            if (this.config != null) {
                if (!this.config.getMetamodelNsURI().equals(uriString) && this.config.backwardSupportedNsURIs().contains(uriString)) {
                    this.resource().handleOldVersionDetected();
                    return super.getPackageForURI(this.config.getMetamodelNsURI());
                }
                if (this.config.getMetamodelNsURI().equals(uriString)) {
                    this.fixmePotentiallyCompatibilityIssues = true;
                }
            }
            return super.getPackageForURI(uriString);
        }

        protected void handleUnknownFeature(String prefix, String name, boolean isElement, EObject peekObject, String value) {
            if (this.fixmePotentiallyCompatibilityIssues && this.config.shouldIgnoreAttribute(peekObject, name)) {
                this.resource().handleOldVersionDetected();
            }
            super.handleUnknownFeature(prefix, name, isElement, peekObject, value);
        }

        MigrationResource resource() {
            assert (this.xmlResource instanceof MigrationResource);
            return (MigrationResource)this.xmlResource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MigrationHandler
    extends BCKWDCompatibleHandler {
        private FeatureKey processedFeatureKey = new FeatureKey();

        MigrationHandler(MigrationResource resource, XMLHelper helper, Map<?, ?> options) {
            super(resource, helper, options);
        }

        protected void setAttribValue(EObject object, String name, String value) {
            if ((this.isMigrationEnabled() || this.fixmePotentiallyCompatibilityIssues) && this.config.shouldIgnoreAttribute(object, name)) {
                Map ignoredAttributes = this.resource().ignoredAttributes;
                if (ignoredAttributes != null) {
                    HashMap<String, String> attrs = (HashMap<String, String>)ignoredAttributes.get(object);
                    if (attrs == null) {
                        attrs = new HashMap<String, String>();
                        ignoredAttributes.put(object, attrs);
                    }
                    attrs.put(name, value);
                }
                this.notifyMigrationApplied();
                return;
            }
            super.setAttribValue(object, name, value);
        }

        protected void createObject(EObject peekObject, EStructuralFeature feature) {
            if (this.isMigrationEnabled()) {
                if (this.config.handleCreateObject(this, peekObject, feature)) {
                    this.notifyMigrationApplied();
                    return;
                }
                this.processedFeatureKey.setFeature(feature);
                if (this.getXSIType() == null && feature instanceof EReference) {
                    EClass oldDefaultRefType;
                    EClass eClass = oldDefaultRefType = this.config != null ? this.config.getAddedTypeInfo(this.processedFeatureKey) : null;
                    if (oldDefaultRefType != null) {
                        String typeQName = this.helper.getQName(oldDefaultRefType);
                        super.createObjectFromTypeName(peekObject, typeQName, feature);
                        this.notifyMigrationApplied();
                        return;
                    }
                }
            }
            super.createObject(peekObject, feature);
        }

        protected void handleFeature(String prefix, String name) {
            if (this.isMigrationEnabled() && this.config.handleFeature(this, prefix, name)) {
                this.notifyMigrationApplied();
                return;
            }
            super.handleFeature(prefix, name);
        }

        public EObject createObjectFromTypeNameHook(EObject peekObject, String typeQName, EStructuralFeature feature) {
            return super.createObjectFromTypeName(peekObject, typeQName, feature);
        }

        public void handleFeatureHook(String prefix, String name) {
            super.handleFeature(prefix, name);
        }

        public String getXSIType() {
            return super.getXSIType();
        }

        public EObject peekEObject() {
            return this.objects.peekEObject();
        }

        private boolean isMigrationEnabled() {
            return this.config != null && this.resource().oldVersionDetected;
        }

        private void notifyMigrationApplied() {
            this.resource().handleMigrationPatchApplied();
        }
    }
}

