/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.dispatch;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.dispatch.EmitterFactory;
import org.eclipse.gmf.internal.codegen.dispatch.NoSuchTemplateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingEmitterFactory
implements EmitterFactory {
    private final EmitterFactory myDelegate;
    private final Map<Object, JETEmitter> myCache;

    public CachingEmitterFactory(EmitterFactory delegate) {
        assert (delegate != null);
        this.myDelegate = delegate;
        this.myCache = this.createCache();
    }

    protected Map<Object, JETEmitter> createCache() {
        return new HashMap<Object, JETEmitter>();
    }

    @Override
    public JETEmitter acquireEmitter(Object key) throws NoSuchTemplateException, UnexpectedBehaviourException {
        JETEmitter em = this.checkCache(key);
        if (em != null) {
            return em;
        }
        em = this.myDelegate.acquireEmitter(key);
        this.cache(key, em);
        return em;
    }

    @Override
    public boolean checkEmitter(Object key) {
        return this.checkCache(key) != null || this.myDelegate.checkEmitter(key);
    }

    private JETEmitter checkCache(Object key) {
        return this.myCache.get(key);
    }

    private void cache(Object key, JETEmitter emitter) {
        this.myCache.put(key, emitter);
    }
}

