/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.DiagramElementsCopier;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryProcessor;

public class GalleryMirrorProcessor
extends GalleryProcessor {
    private final GenerationInfoImpl myGenerationInfo = new GenerationInfoImpl();
    private String myGeneratedBundle;

    public GalleryMirrorProcessor(FigureGallery[] input) {
        super(input);
    }

    public void go(StandaloneGenerator.ProcessorCallback callback, StandaloneGenerator.Config config) throws InterruptedException {
        super.go(callback, config);
        this.myGeneratedBundle = config.getPluginID();
    }

    public FigureGallery convertFigureGallery() {
        FigureGallery result = GMFGraphFactory.eINSTANCE.createFigureGallery();
        result.setName("GeneratedGallery");
        result.setImplementationBundle(this.myGeneratedBundle);
        Enumeration<Figure> originalFigures = this.myGenerationInfo.getProcessedFigures();
        while (originalFigures.hasMoreElements()) {
            Figure nextOriginal = originalFigures.nextElement();
            String nextConvertedFqn = this.myGenerationInfo.getGeneratedClassFQN(nextOriginal);
            CustomFigure custom = DiagramElementsCopier.createCustomFigure(nextOriginal);
            custom.setName(nextOriginal.getName());
            custom.setBundleName(this.myGeneratedBundle);
            custom.setQualifiedClassName(nextConvertedFqn);
            result.getFigures().add((Object)custom);
        }
        return result;
    }

    public GenerationInfo getGenerationInfo() {
        return this.myGenerationInfo;
    }

    protected void handle(Figure next, String fqn) {
        this.myGenerationInfo.registerFQN(next, fqn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GenerationInfo {
        public Enumeration<Figure> getProcessedFigures();

        public String getGeneratedClassFQN(Figure var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenerationInfoImpl
    implements GenerationInfo {
        private final Map<Figure, String> myFigure2FQN = new IdentityHashMap<Figure, String>();

        public void registerFQN(Figure figure, String fqn) {
            this.myFigure2FQN.put(figure, fqn);
        }

        @Override
        public String getGeneratedClassFQN(Figure figure) {
            return this.myFigure2FQN.get(figure);
        }

        @Override
        public Enumeration<Figure> getProcessedFigures() {
            return Collections.enumeration((Collection)this.myFigure2FQN.keySet());
        }
    }
}

