/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.editparts;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.common.ui.util.FileUtil;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.AbstractImageEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.notation.View;

public abstract class URLImageEditPart
extends AbstractImageEditPart {
    public URLImageEditPart(View view) {
        super(view);
    }

    protected abstract String getImagePath();

    protected abstract String getPathImagePathIsRelativeTo();

    protected URL getURL() {
        String urlExpression = this.getImagePath();
        if (urlExpression == null || urlExpression.length() == 0) {
            return null;
        }
        URL url = null;
        String launchPath = null;
        try {
            url = new URL(urlExpression);
        }
        catch (MalformedURLException malformedURLException) {
            launchPath = this.calculateLaunchPath(urlExpression);
            try {
                url = new URL("file:" + launchPath);
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        return url;
    }

    private String calculateLaunchPath(String urlExp) {
        String launchPath = null;
        String urlExpression = urlExp;
        String pathImageIsRelativeTo = this.getPathImagePathIsRelativeTo();
        Path path = new Path(urlExpression);
        if (path != null) {
            if (path.isAbsolute()) {
                urlExpression = path.toOSString();
            } else if (pathImageIsRelativeTo != null && pathImageIsRelativeTo.length() > 0) {
                urlExpression = FileUtil.getAbsolutePath((String)path.toOSString(), (String)this.getPathImagePathIsRelativeTo());
            }
        }
        String urlPath = urlExpression;
        if (pathImageIsRelativeTo != null && pathImageIsRelativeTo.length() > 0) {
            launchPath = FileUtil.getAbsolutePath((String)urlPath, (String)this.getPathImagePathIsRelativeTo());
        }
        return launchPath;
    }

    protected final RenderedImage regenerateImageFromSource() {
        URL url = this.getURL();
        if (url != null) {
            return RenderedImageFactory.getInstance((URL)url);
        }
        return null;
    }
}

