/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.WorkspaceOperationRunner;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class FileDocumentProvider
extends StorageDocumentProvider {
    private WorkspaceOperationRunner fOperationRunner;
    protected IResourceRuleFactory fResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();

    protected void checkSynchronizationState(long cachedModificationStamp, IResource resource) throws CoreException {
        if (cachedModificationStamp != this.computeModificationStamp(resource)) {
            Status status = new Status(4, "org.eclipse.ui", 274, EditorMessages.FileDocumentProvider_error_out_of_sync, null);
            throw new CoreException((IStatus)status);
        }
    }

    protected long computeModificationStamp(IResource resource) {
        long modificationStamp = resource.getModificationStamp();
        IPath path = resource.getLocation();
        if (path == null) {
            return modificationStamp;
        }
        modificationStamp = path.toFile().lastModified();
        return modificationStamp;
    }

    public long getModificationStamp(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.computeModificationStamp((IResource)input.getFile());
        }
        return super.getModificationStamp(element);
    }

    public long getSynchronizationStamp(Object element) {
        FileInfo info;
        if (element instanceof IFileEditorInput && (info = (FileInfo)this.getElementInfo(element)) != null) {
            return info.fModificationStamp;
        }
        return super.getSynchronizationStamp(element);
    }

    protected void doSynchronize(Object element, IProgressMonitor monitor) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            FileInfo info = (FileInfo)this.getElementInfo(element);
            if (info != null) {
                if (info.fFileSynchronizer != null) {
                    info.fFileSynchronizer.uninstall();
                    this.refreshFile(input.getFile(), monitor);
                    info.fFileSynchronizer.install();
                } else {
                    this.refreshFile(input.getFile(), monitor);
                }
                this.handleElementContentChanged((IFileEditorInput)element);
            }
            return;
        }
        super.doSynchronize(element, monitor);
    }

    public boolean isDeleted(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IPath path = input.getFile().getLocation();
            if (path == null) {
                return true;
            }
            return !path.toFile().exists();
        }
        return super.isDeleted(element);
    }

    protected abstract void saveDocumentToFile(IDocument var1, IFile var2, boolean var3, IProgressMonitor var4) throws CoreException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            FileInfo info = (FileInfo)this.getElementInfo(element);
            IFile file = input.getFile();
            if (file.exists()) {
                if (info != null && !overwrite) {
                    this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                }
                this.fireElementStateChanging(element);
                try {
                    this.saveDocumentToFile(document, file, overwrite, monitor);
                }
                catch (CoreException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                if (info == null) return;
                info.fModificationStamp = this.computeModificationStamp((IResource)file);
                return;
            }
            try {
                monitor.beginTask(EditorMessages.FileDocumentProvider_task_saving, 3000);
                ContainerCreator creator = new ContainerCreator(file.getWorkspace(), file.getParent().getFullPath());
                creator.createContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                file.create((InputStream)new ByteArrayInputStream("".getBytes()), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                this.saveDocumentToFile(document, file, overwrite, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                return;
            }
            finally {
                monitor.done();
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                this.refreshFile(input.getFile());
            }
            catch (CoreException x) {
                this.handleCoreException(x, EditorMessages.FileDocumentProvider_createElementInfo);
            }
            IDocument d = null;
            IStatus s = null;
            try {
                d = this.createDocument(element);
            }
            catch (CoreException x) {
                this.handleCoreException(x, EditorMessages.FileDocumentProvider_createElementInfo);
                s = x.getStatus();
                d = this.createEmptyDocument();
            }
            FileSynchronizer f = new FileSynchronizer(input);
            f.install();
            FileInfo info = this.createFileInfo(d, f, input);
            info.fModificationStamp = this.computeModificationStamp((IResource)input.getFile());
            info.fStatus = s;
            return info;
        }
        return super.createElementInfo(element);
    }

    protected FileInfo createFileInfo(IDocument document, FileSynchronizer synchronizer, IFileEditorInput input) {
        return new FileInfo(document, synchronizer);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)info;
            if (fileInfo.fFileSynchronizer != null) {
                fileInfo.fFileSynchronizer.uninstall();
            }
        }
        super.disposeElementInfo(element, info);
    }

    protected void handleElementContentChanged(IFileEditorInput fileEditorInput) {
        FileInfo info = (FileInfo)this.getElementInfo(fileEditorInput);
        if (info == null) {
            return;
        }
        IDocument document = this.createEmptyDocument();
        IStatus status = null;
        try {
            try {
                this.refreshFile(fileEditorInput.getFile());
            }
            catch (CoreException x) {
                this.handleCoreException(x, EditorMessages.FileDocumentProvider_handleElementContentChanged);
            }
            this.setDocumentContent(document, (IEditorInput)fileEditorInput);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        Object newContent = document.getContent();
        if (!newContent.equals(info.fDocument.getContent())) {
            this.fireElementContentAboutToBeReplaced(fileEditorInput);
            this.removeUnchangedElementListeners(fileEditorInput, info);
            info.fDocument.removeDocumentListener((IDocumentListener)info);
            info.fDocument.setContent(newContent);
            info.fCanBeSaved = false;
            info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
            info.fStatus = status;
            this.addUnchangedElementListeners(fileEditorInput, info);
            this.fireElementContentReplaced(fileEditorInput);
        } else {
            this.handleExistingDocumentSaved(fileEditorInput, info, status);
        }
    }

    void handleExistingDocumentSaved(IFileEditorInput input) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        assert (info instanceof FileInfo);
        this.handleExistingDocumentSaved(input, (FileInfo)info, null);
    }

    private void handleExistingDocumentSaved(IFileEditorInput fileEditorInput, FileInfo info, IStatus status) {
        this.removeUnchangedElementListeners(fileEditorInput, info);
        info.fCanBeSaved = false;
        info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
        info.fStatus = status;
        this.addUnchangedElementListeners(fileEditorInput, info);
        this.fireElementDirtyStateChanged(fileEditorInput, false);
    }

    protected void setDocumentContent(IDocument document, Object content) throws CoreException {
        document.setContent(content);
    }

    protected void handleElementMoved(IFileEditorInput fileEditorInput, IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile newFile = workspace.getRoot().getFile(path);
        this.fireElementMoved(fileEditorInput, newFile == null ? null : new FileEditorInput(newFile));
    }

    protected void handleElementDeleted(IFileEditorInput fileEditorInput) {
        this.fireElementDeleted(fileEditorInput);
    }

    protected AbstractDocumentProvider.ElementInfo getElementInfo(Object element) {
        return super.getElementInfo(element);
    }

    protected void doValidateState(Object element, Object computationContext) throws CoreException {
        IFile file;
        IFileEditorInput input;
        FileInfo info;
        if (element instanceof IFileEditorInput && (info = (FileInfo)this.getElementInfo(input = (IFileEditorInput)element)) != null && (file = input.getFile()).isReadOnly()) {
            IWorkspace workspace = file.getWorkspace();
            workspace.validateEdit(new IFile[]{file}, computationContext);
        }
        super.doValidateState(element, computationContext);
    }

    public boolean isModifiable(Object element) {
        if (!this.isStateValidated(element) && element instanceof IFileEditorInput) {
            return true;
        }
        return super.isModifiable(element);
    }

    protected void doResetDocument(Object element, IProgressMonitor monitor) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                this.refreshFile(input.getFile(), monitor);
            }
            catch (CoreException x) {
                this.handleCoreException(x, EditorMessages.FileDocumentProvider_resetDocument);
            }
        }
        super.doResetDocument(element, monitor);
    }

    protected void refreshFile(IFile file) throws CoreException {
        this.refreshFile(file, this.getProgressMonitor());
    }

    protected void refreshFile(IFile file, IProgressMonitor monitor) throws CoreException {
        try {
            file.refreshLocal(2, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public boolean isSynchronized(Object element) {
        if (element instanceof IFileEditorInput) {
            FileInfo info = null;
            info = (FileInfo)this.getElementInfo(element);
            if (info != null) {
                IFileEditorInput input = (IFileEditorInput)element;
                IFile resource = input.getFile();
                return info.fModificationStamp == this.computeModificationStamp((IResource)resource) && resource.isSynchronized(0);
            }
            return false;
        }
        return super.isSynchronized(element);
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(monitor);
        return this.fOperationRunner;
    }

    protected ISchedulingRule getResetRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.fResourceRuleFactory.modifyRule((IResource)input.getFile());
        }
        return null;
    }

    protected ISchedulingRule getSaveRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.computeSchedulingRule((IResource)input.getFile());
        }
        return null;
    }

    protected ISchedulingRule getSynchronizeRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.fResourceRuleFactory.refreshRule((IResource)input.getFile());
        }
        return null;
    }

    protected ISchedulingRule getValidateStateRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.fResourceRuleFactory.validateEditRule(new IResource[]{input.getFile()});
        }
        return null;
    }

    private ISchedulingRule computeSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists()) {
            return this.fResourceRuleFactory.modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists()) {
        }
        return this.fResourceRuleFactory.createRule(toCreateOrModify);
    }

    protected class SafeChange
    implements Runnable {
        private IFileEditorInput fInput;

        public SafeChange(IFileEditorInput input) {
            this.fInput = input;
        }

        protected void execute(IFileEditorInput input) throws Exception {
        }

        public void run() {
            if (FileDocumentProvider.this.getElementInfo(this.fInput) == null) {
                FileDocumentProvider.this.fireElementStateChangeFailed(this.fInput);
                return;
            }
            try {
                this.execute(this.fInput);
            }
            catch (Exception exception) {
                FileDocumentProvider.this.fireElementStateChangeFailed(this.fInput);
            }
        }
    }

    protected class FileSynchronizer
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected IFileEditorInput fFileEditorInput;
        protected boolean fIsInstalled = false;

        public FileSynchronizer(IFileEditorInput fileEditorInput) {
            this.fFileEditorInput = fileEditorInput;
        }

        protected IFile getFile() {
            return this.fFileEditorInput.getFile();
        }

        public void install() {
            this.getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            this.fIsInstalled = true;
        }

        public void uninstall() {
            this.getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.fIsInstalled = false;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null && this.fIsInstalled) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException x) {
                FileDocumentProvider.this.handleCoreException(x, EditorMessages.FileDocumentProvider_resourceChanged);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null) {
                return false;
            }
            if ((delta = delta.findMember(this.getFile().getFullPath())) == null) {
                return false;
            }
            SafeChange runnable = null;
            switch (delta.getKind()) {
                case 4: {
                    boolean isSynchronized;
                    FileInfo info = (FileInfo)FileDocumentProvider.this.getElementInfo(this.fFileEditorInput);
                    if (info == null || info.fCanBeSaved) break;
                    boolean bl = isSynchronized = FileDocumentProvider.this.computeModificationStamp((IResource)this.getFile()) == info.fModificationStamp;
                    if (((0x100000 & delta.getFlags()) == 0 || !isSynchronized) && ((0x100 & delta.getFlags()) == 0 || isSynchronized)) break;
                    runnable = new SafeChange(FileDocumentProvider.this, this.fFileEditorInput){

                        protected void execute(IFileEditorInput input) throws Exception {
                            FileDocumentProvider.this.handleElementContentChanged(input);
                        }
                    };
                    break;
                }
                case 2: {
                    if ((0x2000 & delta.getFlags()) != 0) {
                        final IPath path = delta.getMovedToPath();
                        runnable = new SafeChange(FileDocumentProvider.this, this.fFileEditorInput){

                            protected void execute(IFileEditorInput input) throws Exception {
                                FileDocumentProvider.this.handleElementMoved(input, path);
                            }
                        };
                        break;
                    }
                    FileInfo info = (FileInfo)FileDocumentProvider.this.getElementInfo(this.fFileEditorInput);
                    if (info == null || info.fCanBeSaved) break;
                    runnable = new SafeChange(FileDocumentProvider.this, this.fFileEditorInput){

                        protected void execute(IFileEditorInput input) throws Exception {
                            FileDocumentProvider.this.handleElementDeleted(input);
                        }
                    };
                }
            }
            if (runnable != null) {
                this.update(runnable);
            }
            return false;
        }

        protected void update(Runnable runnable) {
            IWorkbench workbench;
            IWorkbenchWindow[] windows;
            if (runnable instanceof SafeChange) {
                FileDocumentProvider.this.fireElementStateChanging(this.fFileEditorInput);
            }
            if ((windows = (workbench = PlatformUI.getWorkbench()).getWorkbenchWindows()) != null && windows.length > 0) {
                Display display = windows[0].getShell().getDisplay();
                display.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected class FileInfo
    extends StorageDocumentProvider.StorageInfo {
        public FileSynchronizer fFileSynchronizer;
        public long fModificationStamp;

        public FileInfo(IDocument document, FileSynchronizer fileSynchronizer) {
            super(FileDocumentProvider.this, document);
            this.fModificationStamp = -1L;
            this.fFileSynchronizer = fileSynchronizer;
        }
    }
}

