/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.util;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.EditorIDEDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.EditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;

public class IDEEditorUtil
extends EditorUtil {
    public static final DiagramEditPart openDiagram(IFile file, IWorkbenchWindow dWindow, boolean saveDiagram, IProgressMonitor progressMonitor) {
        IEditorPart editorPart = null;
        try {
            IWorkbenchPage page = dWindow.getActivePage();
            if (page != null) {
                editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                if (saveDiagram) {
                    editorPart.doSave(progressMonitor);
                }
            }
            file.refreshLocal(0, null);
            return ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
        }
        catch (Exception e) {
            Trace.catching((Plugin)EditorPlugin.getInstance(), (String)EditorIDEDebugOptions.EXCEPTIONS_CATCHING, EditorUtil.class, (String)"openDiagram", (Throwable)e);
            return null;
        }
    }

    public static IFile createAndOpenDiagram(DiagramFileCreator diagramFileCreator, IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean openEditor, boolean saveDiagram) {
        IFile newFile = EditorUtil.createNewDiagramFile((DiagramFileCreator)diagramFileCreator, (IPath)containerPath, (String)fileName, (InputStream)initialContents, (String)kind, (Shell)dWindow.getShell(), (IProgressMonitor)progressMonitor, (PreferencesHint)PreferencesHint.USE_DEFAULTS);
        if (newFile != null && openEditor) {
            IDEEditorUtil.openDiagram(newFile, dWindow, saveDiagram, progressMonitor);
        }
        return newFile;
    }
}

