/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.actions;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.GroupRequestViaKeyboard;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPart;

public class PromptingDeleteAction
extends DeleteAction {
    public PromptingDeleteAction(IWorkbenchPart part) {
        super(part);
    }

    public Command createCommand(List objects) {
        if (objects.isEmpty()) {
            return null;
        }
        GroupRequestViaKeyboard deleteReq = new GroupRequestViaKeyboard("delete");
        deleteReq.setShowInformationDialog(DiagramUIPlugin.getInstance().getPreferenceStore().getBoolean("Global.promptOnDelFromDiagram"));
        CompoundCommand deleteCC = new CompoundCommand(DiagramUIMessages.DeleteCommand_Label);
        deleteReq.setShowInformationDialog(false);
        boolean containsSemanticElement = false;
        CompositeTransactionalCommand command = null;
        TransactionalEditingDomain editingDomain = null;
        int i = 0;
        while (i < objects.size()) {
            if (objects.get(i) instanceof EditPart) {
                Command command2;
                EditPart editPart = (EditPart)objects.get(i);
                if (editPart instanceof IGraphicalEditPart) {
                    if (editingDomain == null) {
                        editingDomain = ((IGraphicalEditPart)editPart).getEditingDomain();
                    }
                    if (!containsSemanticElement && ViewUtil.resolveSemanticElement((View)((View)editPart.getModel())) != null) {
                        containsSemanticElement = true;
                        deleteReq.setShowInformationDialog(true);
                    }
                }
                if ((command2 = editPart.getCommand((Request)deleteReq)) != null && editingDomain != null) {
                    if (command == null) {
                        command = new CompositeTransactionalCommand(editingDomain, command2.getLabel());
                    }
                    command.compose((IUndoableOperation)new CommandProxy(command2));
                }
            }
            ++i;
        }
        if (command != null && command.size() > 0) {
            deleteCC.add((Command)new ICommandProxy((ICommand)command));
        }
        return deleteCC;
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        Command command = this.createCommand(this.getSelectedObjects());
        if (command != null) {
            this.execute(command);
        }
    }
}

