/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.internal.resources.PathmapManager;
import org.eclipse.gmf.runtime.emf.core.resources.IResourceHelper;

public class Util {
    private static final String pathDelimiter = String.valueOf('/');
    private static final String colonEscaped = "%3A";

    private Util() {
    }

    public static IResourceHelper getHelper(Resource resource) {
        IResourceHelper result = null;
        if (resource != null) {
            result = (IResourceHelper)EcoreUtil.getExistingAdapter((Notifier)resource, IResourceHelper.class);
        }
        return result;
    }

    public static String encodeQualifiedName(String qName) {
        return Util.appendQualifiedName(new StringBuffer(), qName).toString();
    }

    public static StringBuffer appendQualifiedName(StringBuffer buffer, String qName) {
        String[] segments = qName.split("::");
        int i = 0;
        while (i < segments.length) {
            String encodedSegment = URI.encodeSegment((String)segments[i], (boolean)true);
            int j = 0;
            int length = encodedSegment.length();
            while (j < length) {
                char c = encodedSegment.charAt(j);
                if (':' == c) {
                    buffer.append(colonEscaped);
                } else {
                    buffer.append(c);
                }
                ++j;
            }
            if (i + 1 < segments.length) {
                buffer.append('/');
            }
            ++i;
        }
        return buffer;
    }

    public static String decodeQName(String qName) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(qName, pathDelimiter);
        while (st.hasMoreTokens()) {
            buffer.append(URI.decode((String)st.nextToken()));
            if (!st.hasMoreTokens()) continue;
            buffer.append("::");
        }
        return buffer.toString();
    }

    public static URI denormalizeURI(URI uri, ResourceSet rset) {
        IContainer[] containers;
        URI denormalizedURI = uri;
        if ("file".equals(denormalizedURI.scheme()) && (containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(java.net.URI.create(denormalizedURI.toString()))).length == 1) {
            denormalizedURI = URI.createPlatformResourceURI((String)containers[0].getFullPath().toString(), (boolean)true);
        }
        denormalizedURI = PathmapManager.denormalizeURI(denormalizedURI);
        return denormalizedURI;
    }

    public static String getProxyID(EObject proxy) {
        URI uri = EcoreUtil.getURI((EObject)proxy);
        String uriFragment = uri.fragment();
        int index = uriFragment.indexOf(63);
        return index != -1 ? uriFragment.substring(0, index) : uriFragment;
    }

    public static EObject resolve(TransactionalEditingDomain domain, EObject proxy) {
        EObject resolved = EcoreUtil.resolve((EObject)proxy, (ResourceSet)domain.getResourceSet());
        return resolved.eIsProxy() ? null : resolved;
    }

    public static boolean canContain(EClass class1, EClass class2, Set visited) {
        EClass eType;
        for (EReference reference : class1.getEAllReferences()) {
            if (!reference.isContainment() || !(eType = (EClass)reference.getEType()).equals(class2) && !eType.isSuperTypeOf(class2)) continue;
            return true;
        }
        if (visited != null && !visited.contains(class1)) {
            visited.add(class1);
            for (EReference reference : class1.getEAllReferences()) {
                if (!reference.isContainment() || !Util.canContain(eType = (EClass)reference.getEType(), class2, visited)) continue;
                return true;
            }
        }
        return false;
    }
}

