/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.ExpressionCache;
import org.eclipse.gmf.internal.validate.ExternModelImport;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.LabelProvider;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.internal.validate.expressions.AbstractExpression;
import org.eclipse.gmf.internal.validate.expressions.EnvironmentProvider;
import org.eclipse.gmf.internal.validate.expressions.ExpressionProviderRegistry;
import org.eclipse.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpressionProvider;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;
import org.eclipse.gmf.validate.ValidationOptions;
import org.eclipse.osgi.util.NLS;

public class AbstractValidator
implements EValidator {
    protected static final String DIAGNOSTIC_SOURCE = "org.eclipse.gmf.validation";
    private static final Object ROOT_TARGET_OBJECT_KEY = new Object();

    protected AbstractValidator() {
    }

    protected static ExpressionCache getExpressionCache(String language, Map context) {
        return AbstractValidator.getExpressionCache(context).getCache(language);
    }

    protected static IModelExpression getExpression(String language, String body, EClassifier contextClassifier, Map context) {
        EPackage.Registry reg = ExternModelImport.getPackageRegistry(context);
        IParseEnvironment env = null;
        if (reg != null) {
            env = EnvironmentProvider.createParseEnv();
            env.setImportRegistry(reg);
        }
        return AbstractValidator.getExpression(language, body, contextClassifier, env, context);
    }

    protected static IModelExpression getExpression(String language, String body, EClassifier contextClassifier, IParseEnvironment env, Map context) {
        ExpressionCache cache = AbstractValidator.getExpressionCache(language, context);
        if (cache == null) {
            return new NoProviderExpression(language, body, contextClassifier);
        }
        if ("ocl".equals(language) && body != null && body.indexOf("::") > 0) {
            EObject validationTarget = AbstractValidator.getRootTargetObject(context);
            ExternModelImport importer = ExternModelImport.getImporter(context, validationTarget);
            importer.intializeExternPackages(validationTarget);
        }
        return cache.getExpression(body, contextClassifier, env);
    }

    protected static EValidator.SubstitutionLabelProvider getLabelProvider(Map context) {
        if (context != null && context.containsKey(EValidator.SubstitutionLabelProvider.class)) {
            Object provider = context.get(EValidator.SubstitutionLabelProvider.class);
            assert (provider instanceof EValidator.SubstitutionLabelProvider) : "Invalid label provider";
            return (EValidator.SubstitutionLabelProvider)provider;
        }
        return LabelProvider.INSTANCE;
    }

    protected static EObject getRootTargetObject(Map context) {
        Object rootObj = context.get(ROOT_TARGET_OBJECT_KEY);
        assert (rootObj == null || rootObj instanceof EObject);
        return (EObject)rootObj;
    }

    private static void ensureRootTargetInitialized(EObject target, Map context) {
        if (context != null && !context.containsKey(ROOT_TARGET_OBJECT_KEY)) {
            AbstractValidator.setRootTargetObject(target, context);
        }
    }

    private static void setRootTargetObject(EObject targetObject, Map context) {
        assert (!context.containsKey(ROOT_TARGET_OBJECT_KEY));
        context.put(ROOT_TARGET_OBJECT_KEY, EcoreUtil.getRootContainer((EObject)targetObject, (boolean)true));
    }

    private static MultiProviderCache getExpressionCache(Map context) {
        if (context != null) {
            MultiProviderCache cache = (MultiProviderCache)context.get(MultiProviderCache.class);
            if (cache == null) {
                cache = new MultiProviderCache();
                context.put(MultiProviderCache.class, new MultiProviderCache());
            }
            return cache;
        }
        if (Trace.shouldTrace(DebugOptions.DEBUG)) {
            Trace.trace("Performance warning: Validation should run in a context for caching");
        }
        return new MultiProviderCache();
    }

    static ValidationOptions getOptions(Map context) {
        if (context != null) {
            ValidationOptions options = (ValidationOptions)context.get(ValidationOptions.class);
            return options != null ? options : ValidationOptions.getDefault();
        }
        return ValidationOptions.getDefault();
    }

    static void setOptions(ValidationOptions options, Map context) {
        if (context == null) {
            throw new IllegalArgumentException("Null validation options");
        }
        if (options.isUseGmfLabelSubtitution()) {
            context.put(EValidator.SubstitutionLabelProvider.class, LabelProvider.INSTANCE);
        }
        context.put(ValidationOptions.class, options);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map context) {
        AbstractValidator.ensureRootTargetInitialized(eObject, context);
        return true;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map context) {
        AbstractValidator.ensureRootTargetInitialized(eObject, context);
        return true;
    }

    private static class MultiProviderCache {
        private HashMap<String, ExpressionCache> lang2ProviderMap = new HashMap();

        public ExpressionCache getCache(String language) {
            ExpressionCache cache = this.lang2ProviderMap.get(language);
            if (cache == null) {
                IModelExpressionProvider provider = ExpressionProviderRegistry.getInstance().getProvider(language);
                if (provider == null) {
                    return null;
                }
                cache = new ProviderCache(provider);
                this.lang2ProviderMap.put(language, cache);
            }
            return cache;
        }
    }

    private static class NoProviderExpression
    extends AbstractExpression {
        private String lang;

        public NoProviderExpression(String language, String body, EClassifier context) {
            super(body, context, null);
            this.lang = language;
            String message = NLS.bind((String)Messages.noExpressionProviderAvailable, (Object)language);
            Status status = new Status(4, GMFValidationPlugin.getPluginId(), 310, message, null);
            this.setStatus((IStatus)status);
        }

        public boolean isAssignableToElement(ETypedElement typedElement) {
            return false;
        }

        public boolean isAssignableTo(EClassifier ecoreType) {
            return false;
        }

        public String getLanguage() {
            return this.lang;
        }

        protected Object doEvaluate(Object context) {
            return null;
        }

        protected Object doEvaluate(Object context, IEvaluationEnvironment extEnvironment) {
            return null;
        }
    }

    private static class ProviderCache
    extends ExpressionCache {
        private IModelExpressionProvider expressionProvider;

        public ProviderCache(IModelExpressionProvider expressionProvider) {
            this.expressionProvider = expressionProvider;
        }

        protected IModelExpression createExpressionEntry(String body, EClassifier context, IParseEnvironment extEnv) {
            if (this.expressionProvider != null) {
                return this.expressionProvider.createExpression(body, context, extEnv);
            }
            return new NoProviderExpression("", body, context);
        }
    }
}

