/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDataTypeConversion {
    private static final Class[][] integralsToFloatsArray = new Class[][]{{Byte.class, Float.class}, {Short.class, Float.class}, {Integer.class, Float.class}, {Long.class, Double.class}, {BigInteger.class, BigDecimal.class}};
    private static final List<Class> integrals = new ArrayList<Class>();
    private static final List floats;

    static {
        int i = 0;
        while (i < integralsToFloatsArray.length) {
            integrals.add(integralsToFloatsArray[i][0]);
            ++i;
        }
        floats = Arrays.asList(Float.class, Double.class, BigDecimal.class);
    }

    public static boolean isConvertable(EDataType leftDataType, EDataType rightDataType) {
        if (leftDataType == null || rightDataType == null) {
            throw new IllegalArgumentException("null data type");
        }
        if (leftDataType.getInstanceClass() == null || rightDataType.getInstanceClass() == null) {
            return false;
        }
        Class leftClass = EcoreUtil.wrapperClassFor((Class)leftDataType.getInstanceClass());
        Class rightClass = EcoreUtil.wrapperClassFor((Class)rightDataType.getInstanceClass());
        if (Number.class.isAssignableFrom(leftClass) && Number.class.isAssignableFrom(leftClass)) {
            return EDataTypeConversion.isConvertable(leftClass, rightClass);
        }
        return leftClass.equals(rightClass);
    }

    private static boolean isConvertable(Class<?> left, Class<?> right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("null Class argument");
        }
        int leftPos = integrals.indexOf(left);
        int rightPos = integrals.indexOf(right);
        if (leftPos >= 0) {
            if (rightPos < 0) {
                return false;
            }
        } else {
            leftPos = floats.indexOf(left);
            if (leftPos >= 0) {
                if (rightPos >= 0) {
                    rightPos = floats.indexOf(integralsToFloatsArray[rightPos][1]);
                } else {
                    rightPos = floats.indexOf(right);
                    if (rightPos < 0) {
                        return false;
                    }
                }
                return leftPos >= rightPos;
            }
        }
        return left.isAssignableFrom(right);
    }
}

