/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.parts;

import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.PresentationTestFixture;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class GraphicalNodeEditPolicyTests
extends AbstractTestBase {
    public static Test suite() {
        TestSuite s = new TestSuite(GraphicalNodeEditPolicyTests.class);
        return s;
    }

    public GraphicalNodeEditPolicyTests() {
        super("GraphicalNodeEditPolicy Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new PresentationTestFixture();
    }

    protected PresentationTestFixture getFixture() {
        return (PresentationTestFixture)this.testFixture;
    }

    public void testCustomPrompt() throws Exception {
        NoteEditPart sourceEP = this.getFixture().createNote();
        NoteEditPart targetEP = this.getFixture().createNote();
        sourceEP.installEditPolicy((Object)"GraphicalNodeEditPolicy", (EditPolicy)new NoteGraphicalNodeEditPolicy());
        targetEP.installEditPolicy((Object)"GraphicalNodeEditPolicy", (EditPolicy)new NoteGraphicalNodeEditPolicy());
        ConnectionHandle handle = new ConnectionHandle((IGraphicalEditPart)sourceEP, ConnectionHandle.HandleDirection.OUTGOING, "the tooltip");
        ConnectionHandleTool tool = new ConnectionHandleTool(handle);
        CreateConnectionRequest request = (CreateConnectionRequest)tool.createTargetRequest();
        request.setTargetEditPart((EditPart)sourceEP);
        request.setType((Object)"connection start");
        sourceEP.getCommand((Request)request);
        request.setSourceEditPart((EditPart)sourceEP);
        request.setTargetEditPart((EditPart)targetEP);
        request.setType((Object)"connection end");
        targetEP.getCommand((Request)request).execute();
        GraphicalNodeEditPolicyTests.assertEquals((int)1, (int)this.getDiagramEditPart().getConnections().size());
        NoteAttachmentEditPart noteAttachmentEP = (NoteAttachmentEditPart)this.getDiagramEditPart().getConnections().get(0);
        GraphicalNodeEditPolicyTests.assertEquals((Object)sourceEP, (Object)noteAttachmentEP.getSource());
        GraphicalNodeEditPolicyTests.assertEquals((Object)targetEP, (Object)noteAttachmentEP.getTarget());
        GraphicalNodeEditPolicyTests.assertTrue((boolean)FigureUtilities.integerToColor((Integer)((Integer)ViewUtil.getStructuralFeatureValue((View)noteAttachmentEP.getNotationView(), (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor()))).equals((Object)NoteGraphicalNodeEditPolicy.USER_CHOICE.color));
        noteAttachmentEP.getCommand((Request)new GroupRequest((Object)"delete")).execute();
        GraphicalNodeEditPolicyTests.assertEquals((int)0, (int)this.getDiagramEditPart().getConnections().size());
        handle = new ConnectionHandle((IGraphicalEditPart)targetEP, ConnectionHandle.HandleDirection.INCOMING, "the tooltip");
        tool = new ConnectionHandleTool(handle);
        request = (CreateConnectionRequest)tool.createTargetRequest();
        request.setTargetEditPart((EditPart)targetEP);
        request.setType((Object)"connection start");
        targetEP.getCommand((Request)request);
        request.setSourceEditPart((EditPart)targetEP);
        request.setTargetEditPart((EditPart)sourceEP);
        request.setType((Object)"connection end");
        sourceEP.getCommand((Request)request).execute();
        GraphicalNodeEditPolicyTests.assertEquals((int)1, (int)this.getDiagramEditPart().getConnections().size());
        noteAttachmentEP = (NoteAttachmentEditPart)this.getDiagramEditPart().getConnections().get(0);
        GraphicalNodeEditPolicyTests.assertEquals((Object)sourceEP, (Object)noteAttachmentEP.getSource());
        GraphicalNodeEditPolicyTests.assertEquals((Object)targetEP, (Object)noteAttachmentEP.getTarget());
        GraphicalNodeEditPolicyTests.assertTrue((boolean)FigureUtilities.integerToColor((Integer)((Integer)ViewUtil.getStructuralFeatureValue((View)noteAttachmentEP.getNotationView(), (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor()))).equals((Object)NoteGraphicalNodeEditPolicy.USER_CHOICE.color));
    }

    class ConnectionHandleTool
    extends org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool {
        public ConnectionHandleTool(ConnectionHandle connectorHandle) {
            super(connectorHandle);
        }

        public Request createTargetRequest() {
            return super.createTargetRequest();
        }

        protected PreferencesHint getPreferencesHint() {
            return PreferencesHint.USE_DEFAULTS;
        }
    }

    static class NoteGraphicalNodeEditPolicy
    extends GraphicalNodeEditPolicy {
        static NoteAttachmentDescriptor USER_CHOICE = new NoteAttachmentDescriptor(ColorConstants.red);

        NoteGraphicalNodeEditPolicy() {
        }

        protected List getConnectionMenuContent(CreateConnectionRequest request) {
            List content = super.getConnectionMenuContent(request);
            if (content.contains(DiagramNotationType.NOTE_ATTACHMENT)) {
                content.add(new NoteAttachmentDescriptor(ColorConstants.blue));
                content.add(USER_CHOICE);
                content.add(new NoteAttachmentDescriptor(ColorConstants.yellow));
            }
            return content;
        }

        protected Command getConnectionCompleteCommand(Object connectionType, CreateConnectionRequest request) {
            if (connectionType instanceof NoteAttachmentDescriptor) {
                CompoundCommand cc = new CompoundCommand("Create Note Attachment");
                cc.add(super.getConnectionCompleteCommand((Object)DiagramNotationType.NOTE_ATTACHMENT, request));
                if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                    cc.add((Command)new ICommandProxy((ICommand)new SetPropertyCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), (IAdaptable)((CreateConnectionViewRequest)((CreateUnspecifiedTypeConnectionRequest)request).getRequestForType((IElementType)DiagramNotationType.NOTE_ATTACHMENT)).getConnectionViewDescriptor(), Properties.ID_LINECOLOR, Properties.ID_LINECOLOR, (Object)FigureUtilities.colorToInteger((Color)((NoteAttachmentDescriptor)connectionType).color))));
                }
                return cc.unwrap();
            }
            return super.getConnectionCompleteCommand(connectionType, request);
        }

        protected ICommand getPromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
            class TestablePromptAndCreateConnectionCommand
            extends GraphicalNodeEditPolicy.PromptAndCreateConnectionCommand {
                TestablePromptAndCreateConnectionCommand(List theContent, CreateConnectionRequest theRequest) {
                    super((GraphicalNodeEditPolicy)NoteGraphicalNodeEditPolicy.this, theContent, theRequest);
                    this.setPopupMenu(new 1TestablePromptAndCreateConnectionCommand.TestablePopupMenu(theContent, this.getLabelProvider()));
                }

                protected ILabelProvider getLabelProvider() {
                    return new CreateOrSelectElementCommand.LabelProvider(){

                        public String getText(Object object) {
                            if (object instanceof NoteAttachmentDescriptor) {
                                return "Create a note attachment colored " + ((NoteAttachmentDescriptor)object).color;
                            }
                            return super.getText(object);
                        }
                    };
                }

                class 1TestablePromptAndCreateConnectionCommand.TestablePopupMenu
                extends PopupMenu {
                    1TestablePromptAndCreateConnectionCommand.TestablePopupMenu(List theContent, ILabelProvider theLabelProvider) {
                        super(theContent, theLabelProvider);
                    }

                    public boolean show(Control parent) {
                        GraphicalNodeEditPolicyTests.assertTrue((boolean)this.getContent().contains(USER_CHOICE));
                        this.setResult(Collections.singletonList(USER_CHOICE));
                        return true;
                    }
                }
            }
            return new TestablePromptAndCreateConnectionCommand(content, request);
        }

        static class NoteAttachmentDescriptor {
            Color color;

            NoteAttachmentDescriptor(Color color) {
                this.color = color;
            }
        }
    }
}

