/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FilteringStyle;
import org.eclipse.gmf.runtime.notation.Guide;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.SortingStyle;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;

public class ViewRefactorHelper {
    private PreferencesHint preferencesHint;

    public ViewRefactorHelper() {
        this(PreferencesHint.USE_DEFAULTS);
    }

    public ViewRefactorHelper(PreferencesHint preferencesHint) {
        this.preferencesHint = preferencesHint;
    }

    public PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    public void refactor(EObject oldElement, EObject newElement) {
        Collection views = this.getReferencingViews(oldElement);
        for (View oldView : views) {
            if (oldView instanceof Node) {
                this.refactorNode((Node)oldView, newElement);
            } else if (oldView instanceof Edge) {
                this.refactorEdge((Edge)oldView, newElement);
            } else if (oldView instanceof Diagram) {
                this.refactorDiagram((Diagram)oldView, newElement);
            }
            DestroyElementCommand.destroy((EObject)oldView);
        }
        Collection filterStyles = EMFCoreUtil.getReferencers((EObject)oldElement, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getFilteringStyle_FilteredObjects()});
        Iterator i = filterStyles.iterator();
        while (i.hasNext()) {
            EList filteredObjects = ((FilteringStyle)i.next()).getFilteredObjects();
            if (!filteredObjects.contains(oldElement)) {
                filteredObjects.add(filteredObjects.indexOf(oldElement), newElement);
            }
            filteredObjects.remove(oldElement);
        }
        Collection sortingStyles = EMFCoreUtil.getReferencers((EObject)oldElement, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getSortingStyle_SortedObjects()});
        Iterator i2 = sortingStyles.iterator();
        while (i2.hasNext()) {
            EList sortingObjects = ((SortingStyle)i2.next()).getSortedObjects();
            if (!sortingObjects.contains(oldElement)) {
                sortingObjects.add(sortingObjects.indexOf(oldElement), newElement);
            }
            sortingObjects.remove(oldElement);
        }
    }

    protected Node refactorNode(Node oldNode, EObject newElement) {
        Node newNode;
        if (oldNode.eContainingFeature() == NotationPackage.eINSTANCE.getView_PersistedChildren() && (newNode = this.createNode(oldNode, newElement)) != null) {
            this.copyNodeFeatures(oldNode, newNode);
            View container = (View)oldNode.eContainer();
            container.getPersistedChildren().move(container.getPersistedChildren().indexOf((Object)oldNode), (Object)newNode);
            this.refactorGuides(oldNode, newNode);
            return newNode;
        }
        return null;
    }

    protected Edge refactorEdge(Edge oldEdge, EObject newElement) {
        Edge newEdge;
        if (oldEdge.eContainingFeature() == NotationPackage.eINSTANCE.getDiagram_PersistedEdges() && (newEdge = this.createEdge(oldEdge, newElement)) != null) {
            this.copyEdgeFeatures(oldEdge, newEdge);
            Diagram container = (Diagram)oldEdge.eContainer();
            container.getPersistedEdges().move(container.getPersistedEdges().indexOf((Object)oldEdge), (Object)newEdge);
            return newEdge;
        }
        return null;
    }

    protected Diagram refactorDiagram(Diagram oldDiagram, EObject newElement) {
        Diagram newDiagram;
        if (oldDiagram.eContainingFeature() == EcorePackage.eINSTANCE.getEAnnotation_Contents() && (newDiagram = this.createDiagram(oldDiagram, newElement)) != null) {
            this.copyDiagramFeatures(oldDiagram, newDiagram);
            EAnnotation container = (EAnnotation)oldDiagram.eContainer();
            container.getContents().add(container.getContents().indexOf((Object)oldDiagram), (Object)newDiagram);
            this.refactorDiagramLinks(oldDiagram, newDiagram);
            return newDiagram;
        }
        return null;
    }

    protected void refactorDiagramLinks(Diagram oldDiagram, Diagram newDiagram) {
        Collection links = EMFCoreUtil.getReferencers((EObject)oldDiagram, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getView_Element()});
        for (View view : links) {
            view.setElement((EObject)newDiagram);
        }
    }

    protected void copyNodeFeatures(Node oldNode, Node newNode) {
        newNode.setLayoutConstraint(oldNode.getLayoutConstraint());
        this.copyViewFeatures((View)oldNode, (View)newNode);
    }

    protected void copyEdgeFeatures(Edge oldEdge, Edge newEdge) {
        newEdge.setBendpoints(oldEdge.getBendpoints());
        newEdge.setSourceAnchor(oldEdge.getSourceAnchor());
        newEdge.setTargetAnchor(oldEdge.getTargetAnchor());
        this.copyViewFeatures((View)oldEdge, (View)newEdge);
    }

    protected void copyDiagramFeatures(Diagram oldDiagram, Diagram newDiagram) {
        newDiagram.setName(oldDiagram.getName());
        if (oldDiagram.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getDiagram_PersistedEdges())) {
            newDiagram.getPersistedEdges().addAll((Collection)oldDiagram.getPersistedEdges());
        }
        this.copyViewFeatures((View)oldDiagram, (View)newDiagram);
    }

    protected void copyViewFeatures(View oldView, View newView) {
        this.copyViewAppearance(oldView, newView, new ArrayList());
        if (oldView.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getView_SourceEdges())) {
            newView.getSourceEdges().addAll((Collection)oldView.getSourceEdges());
        }
        if (oldView.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getView_TargetEdges())) {
            newView.getTargetEdges().addAll((Collection)oldView.getTargetEdges());
        }
        this.copyViewChildren(oldView, newView);
    }

    public void copyViewAppearance(View oldView, View newView, List excludeStyles) {
        newView.setVisible(oldView.isVisible());
        this.copyViewStyles(oldView, newView, excludeStyles);
        for (Node oldChildNode : new ArrayList(oldView.getPersistedChildren())) {
            Node newChildNode;
            if (oldView.getElement() != oldChildNode.getElement() || oldChildNode.getType() == null || (newChildNode = (Node)ViewUtil.getChildBySemanticHint(newView, oldChildNode.getType())) == null) continue;
            this.copyViewAppearance((View)oldChildNode, (View)newChildNode, excludeStyles);
        }
    }

    protected void copyViewStyles(View oldView, View newView) {
        this.copyViewStyles(oldView, newView, new ArrayList());
    }

    protected void copyViewStyles(View oldView, View newView, List excludeStyles) {
        if (oldView.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getView_Styles())) {
            for (Style oldStyle : oldView.getStyles()) {
                this.copyViewStyle(oldView, newView, oldStyle, excludeStyles);
            }
        }
    }

    protected void copyViewStyle(View oldView, View newView, Style oldStyle, List excludeStyles) {
        HashMap<EClass, Style> eClassMap = new HashMap<EClass, Style>();
        for (EStructuralFeature feature : oldStyle.eClass().getEAllStructuralFeatures()) {
            Style newStyle;
            EClass containingStyleEClass = feature.getEContainingClass();
            if (excludeStyles.contains(containingStyleEClass)) continue;
            if (eClassMap.containsKey(feature.getEContainingClass())) {
                newStyle = (Style)eClassMap.get(feature.getEContainingClass());
            } else {
                newStyle = newView.getStyle(feature.getEContainingClass());
                eClassMap.put(feature.getEContainingClass(), newStyle);
            }
            if (newStyle == null) continue;
            newStyle.eSet(feature, oldStyle.eGet(feature));
        }
    }

    protected void copyViewChildren(View oldView, View newView) {
        for (Node oldChildNode : new ArrayList(oldView.getPersistedChildren())) {
            this.copyViewChild(oldView, newView, oldChildNode);
        }
    }

    protected void copyViewChild(View oldView, View newView, Node oldChildNode) {
        if (oldView.getElement() == oldChildNode.getElement() && oldChildNode.getType() != null) {
            Node newChildNode = (Node)ViewUtil.getChildBySemanticHint(newView, oldChildNode.getType());
            if (newChildNode != null) {
                this.copyNodeFeatures(oldChildNode, newChildNode);
            }
        } else {
            newView.getPersistedChildren().add((Object)oldChildNode);
        }
    }

    protected final void refactorGuides(Node oldNode, Node newNode) {
        Collection guides = EMFCoreUtil.getReferencers((EObject)oldNode, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getNodeEntry_Key()});
        Iterator i = guides.iterator();
        while (i.hasNext()) {
            EMap nodeMap = ((Guide)((EObject)i.next()).eContainer()).getNodeMap();
            nodeMap.put((Object)newNode, nodeMap.get((Object)oldNode));
            nodeMap.remove((Object)oldNode);
        }
    }

    protected Collection getReferencingViews(EObject element) {
        Collection views = EMFCoreUtil.getReferencers((EObject)element, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getView_Element()});
        Iterator i = views.iterator();
        block0: while (i.hasNext()) {
            View view = (View)i.next();
            EObject parent = null;
            while ((parent = view.eContainer()) instanceof View) {
                if (views.contains(parent)) {
                    i.remove();
                    continue block0;
                }
                view = (View)parent;
            }
        }
        return views;
    }

    protected Node createNode(Node oldNode, EObject newElement) {
        return ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter(newElement), (View)oldNode.eContainer(), this.getNewViewType((View)oldNode, newElement), -1, this.preferencesHint);
    }

    protected Edge createEdge(Edge oldEdge, EObject newElement) {
        Edge edge = (Edge)ViewService.getInstance().createEdge((IAdaptable)new EObjectAdapter(newElement), (View)oldEdge.getDiagram(), this.getNewViewType((View)oldEdge, newElement), -1, this.preferencesHint);
        if (edge != null) {
            edge.setSource(oldEdge.getSource());
            edge.setTarget(oldEdge.getTarget());
        }
        return edge;
    }

    protected Diagram createDiagram(Diagram oldDiagram, EObject newElement) {
        return ViewService.getInstance().createDiagram((IAdaptable)new EObjectAdapter(newElement), this.getNewViewType((View)oldDiagram, newElement), this.preferencesHint);
    }

    protected String getNewViewType(View oldView, EObject newElement) {
        return oldView.getType();
    }
}

