/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.xtend.ast.QvtResource;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.ocl.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtExtensions
extends TestCase {
    private static final Object[] YES_NO = new Object[]{"YES", "NO"};
    private StringBuilder buffer;
    private TestsResourceManager resourceManager;
    private XpandFacade xpandFacade;
    private ExecutionContextImpl execCtx;

    protected void setUp() throws Exception {
        super.setUp();
        if (QvtPlugin.getDefault() == null) {
            new QvtPlugin();
        }
        this.buffer = new StringBuilder();
        this.resourceManager = new TestsResourceManager();
        this.execCtx = new ExecutionContextImpl(new Scope((ResourceManager)this.resourceManager, null, (Output)new BufferOutput(this.buffer)));
        this.xpandFacade = new XpandFacade((ExecutionContext)this.execCtx);
    }

    public void testQvtLibraryCompilation() {
        QvtResource qvtResource = this.resourceManager.loadQvtResource("org::eclipse::gmf::tests::xpand::evaluate::QvtLibrary");
        LinkedHashSet<AnalysationIssue> issues = new LinkedHashSet<AnalysationIssue>();
        qvtResource.analyze((ExecutionContext)this.execCtx, issues);
        this.checkIssues(issues);
        XpandResource template = this.execCtx.getScope().findTemplate("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension");
        template.analyze((ExecutionContext)this.execCtx, issues);
        this.checkIssues(issues);
    }

    private void checkIssues(Set<AnalysationIssue> issues) {
        if (issues.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (AnalysationIssue analysationIssue : issues) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(analysationIssue.getMessage());
        }
        QvtExtensions.fail((String)sb.toString());
    }

    public void testContextInvocationContextualQuery() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkStringContextInvocation", "ContextString1");
    }

    public void testQvtoIsCapableToDefineContextOpsToCollections() throws AmbiguousDefinitionException {
        String arg = "Str";
        this.xpandFacade.evaluate("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::collectionContextOp", (Object)arg, null);
        QvtExtensions.assertEquals((String)arg, (String)this.buffer.toString().trim());
    }

    public void testStaticInvocationStaticQuery() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkIntStaticInvocation", 20);
    }

    public void testBooleanTypeQuery() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkBoolean", false);
    }

    public void _testDeployedMetaType() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkDeployedMetaType", EcoreFactory.eINSTANCE.createEAttribute());
    }

    public void testCollectionOfStrings() throws AmbiguousDefinitionException {
        List sequence = CollectionUtil.createNewSequence();
        sequence.add("SampleString1");
        sequence.add("SampleString2");
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkCollection", sequence);
    }

    public void testSetOfBooleans() throws AmbiguousDefinitionException {
        HashSet<Boolean> collection = new HashSet<Boolean>();
        collection.add(true);
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkSet", collection);
    }

    public void testSequenceOfBooleans() throws AmbiguousDefinitionException {
        ArrayList<Boolean> collection = new ArrayList<Boolean>();
        collection.add(true);
        collection.add(false);
        collection.add(false);
        collection.add(true);
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkSequence", collection);
    }

    public void testBagOfBooleans() throws AmbiguousDefinitionException {
        ArrayList<Boolean> collection = new ArrayList<Boolean>();
        collection.add(true);
        collection.add(false);
        collection.add(false);
        collection.add(true);
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkBag", collection);
    }

    public void testOrderedSetOfIntegers() throws AmbiguousDefinitionException {
        HashSet<Integer> collection = new HashSet<Integer>();
        collection.add(1);
        collection.add(2);
        collection.add(5);
        collection.add(10);
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkOrderedSet", collection);
    }

    public void testQueryParametersNotPolymorphycForSelf() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkQueryParametersNotPolymorphycForSelf", "ContextString1");
    }

    public void testQueryParametersNotPolymorphycForParameter() throws AmbiguousDefinitionException {
        Object[] yes_no_string = new Object[]{YES_NO[0], YES_NO[1], "OneMoreString"};
        this.xpandFacade.evaluate("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkQueryParametersNotPolymorphycForParameter", (Object)"ContextString1", yes_no_string);
        QvtExtensions.assertEquals((Object)yes_no_string[0], (Object)this.buffer.toString());
    }

    public void testQueryParametersNotPolymorphycForLet() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkQueryParametersNotPolymorphycForLet", "ContextString1");
    }

    public void testQueryContextPolymorphycForSelf() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkQueryContextPolymorphycForSelf", "ContextString1");
    }

    public void testQueryParametersNotPolymorphycForForeach() throws AmbiguousDefinitionException {
        this.checkQueryCall("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkQueryParametersNotPolymorphycForForeach", "ContextString1");
    }

    private void checkQueryCall(String queryName, Object selfObject) throws AmbiguousDefinitionException {
        this.xpandFacade.evaluate(queryName, selfObject, YES_NO);
        QvtExtensions.assertEquals((Object)YES_NO[0], (Object)this.buffer.toString());
    }

    public void testQVTOCLExtensions() throws Exception {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add("string1");
        args.add(10);
        args.add("string2");
        args.add(5L);
        args.add("string3");
        args.add(20);
        args.add(Float.valueOf(4.0f));
        this.xpandFacade.evaluate("org::eclipse::gmf::tests::xpand::evaluate::QvtExtension::checkQVTOCLExtensions", (Object)"aaa", new Object[]{args});
        QvtExtensions.assertEquals((String)"xx", (String)this.buffer.toString().trim());
    }
}

