/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.Advice;
import org.eclipse.gmf.internal.xpand.ast.Definition;
import org.eclipse.gmf.internal.xpand.ast.ImportDeclaration;
import org.eclipse.gmf.internal.xpand.ast.NamespaceImport;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.xtend.ast.QvtResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends SyntaxElement
implements XpandResource {
    private final NamespaceImport[] imports;
    private final Definition[] definitions;
    private final ImportDeclaration[] extensions;
    private final Advice[] advices;
    private String qualifiedName;
    private String[] importStrings = null;
    private String[] importedExtensions = null;

    public Template(int start, int end, int line, NamespaceImport[] imports, ImportDeclaration[] extensions, Definition[] definitions, Advice[] advices) {
        super(start, end, line);
        AbstractDefinition element;
        this.imports = imports;
        this.extensions = extensions;
        AbstractDefinition[] abstractDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.setOwner(this);
            ++n2;
        }
        this.definitions = definitions;
        abstractDefinitionArray = advices;
        n = advices.length;
        n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.setOwner(this);
            ++n2;
        }
        this.advices = advices;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.qualifiedName == null ? this.getFileName() : this.qualifiedName;
    }

    public void setFullyQualifiedName(String name) {
        this.qualifiedName = name;
    }

    @Override
    public XpandDefinition[] getDefinitions() {
        return this.definitions;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        AbstractDefinition element;
        ctx = ctx.cloneWithResource(this);
        SyntaxElement[] syntaxElementArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            element = syntaxElementArray[n2];
            element.analyze(ctx, issues);
            ++n2;
        }
        syntaxElementArray = this.advices;
        n = this.advices.length;
        n2 = 0;
        while (n2 < n) {
            element = syntaxElementArray[n2];
            ((Advice)element).analyze(ctx, issues);
            ++n2;
        }
        syntaxElementArray = this.extensions;
        n = this.extensions.length;
        n2 = 0;
        while (n2 < n) {
            SyntaxElement importDeclaration = syntaxElementArray[n2];
            QvtResource extension = ctx.getScope().findExtension(((ImportDeclaration)importDeclaration).getImportString());
            if (extension == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.EXTENSION_NOT_FOUND, "Couldn't find " + ((ImportDeclaration)importDeclaration).getImportString(), importDeclaration));
            }
            ++n2;
        }
        EPackage.Registry packageRegistry = ctx.getScope().createPackageRegistry(this.getImportedNamespaces());
        NamespaceImport[] namespaceImportArray = this.imports;
        int n3 = this.imports.length;
        n = 0;
        while (n < n3) {
            NamespaceImport namespaceImport = namespaceImportArray[n];
            if (!packageRegistry.containsKey((Object)namespaceImport.getImportString())) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.NAMESPACE_NOT_FOUND, "Couldn't find " + namespaceImport.getImportString(), namespaceImport));
            }
            ++n;
        }
    }

    @Override
    public String[] getImportedNamespaces() {
        if (this.importStrings == null) {
            this.importStrings = new String[this.imports.length];
            int i = 0;
            while (i < this.importStrings.length) {
                this.importStrings[i] = this.imports[i].getImportString();
                ++i;
            }
        }
        return this.importStrings;
    }

    @Override
    public String[] getImportedExtensions() {
        if (this.importedExtensions == null) {
            this.importedExtensions = new String[this.extensions.length];
            int i = 0;
            while (i < this.extensions.length) {
                this.importedExtensions[i] = this.extensions[i].getImportString();
                ++i;
            }
        }
        return this.importedExtensions;
    }

    @Override
    public XpandAdvice[] getAdvices() {
        return this.advices;
    }
}

