/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class ModelURISelector
implements Listener {
    private final String myGroupTitle;
    private final String myFileExt;
    private final Loader myModelLoader;
    private Text uriText;
    private Menu browseMenu;
    private Group myControl;
    private Listener mySetTextActionListener;
    private ToolItem myLoadBtn;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.wizards.pages.ModelURISelector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ModelURISelector(String groupTitle, String fileExt, Loader modelLoader) {
        this.myGroupTitle = groupTitle;
        this.myFileExt = fileExt;
        this.myModelLoader = modelLoader;
    }

    public void setURIText(String text) {
        this.uriText.setText(text);
    }

    public void setURIText(URI uri) {
        this.setURIText(uri.toString());
    }

    public Control createControl(Composite parent) {
        this.myControl = new Group(parent, 0);
        GridLayout l = new GridLayout();
        l.numColumns = 2;
        this.myControl.setLayout((Layout)l);
        this.myControl.setText(this.myGroupTitle);
        this.uriText = new Text((Composite)this.myControl, 2052);
        this.uriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.browseMenu = this.createBrowseMenu((Control)this.myControl);
        this.createToolBar((Composite)this.myControl);
        return this.myControl;
    }

    public Menu getBrowseMenu() {
        return this.browseMenu;
    }

    public void addBrowseMenuSeparator() {
        new MenuItem(this.getBrowseMenu(), 2);
    }

    public void addBrowseMenuAction(String text, String uriValue) {
        if (!($assertionsDisabled || text != null && uriValue != null)) {
            throw new AssertionError();
        }
        MenuItem item = new MenuItem(this.getBrowseMenu(), 8);
        item.setText(text);
        item.setData((Object)uriValue);
        item.addListener(13, this.getTextActionListener());
    }

    public void addBrowseMenuAction(String text, Listener l) {
        if (!($assertionsDisabled || text != null && l != null)) {
            throw new AssertionError();
        }
        MenuItem item = new MenuItem(this.getBrowseMenu(), 8);
        item.setText(text);
        item.addListener(13, l);
    }

    public void disableLoad() {
        if (!$assertionsDisabled && this.myLoadBtn == null) {
            throw new AssertionError();
        }
        this.myLoadBtn.setEnabled(false);
    }

    public void enableLoad() {
        if (!$assertionsDisabled && this.myLoadBtn == null) {
            throw new AssertionError();
        }
        this.myLoadBtn.setEnabled(true);
    }

    private Listener getTextActionListener() {
        if (this.mySetTextActionListener == null) {
            this.mySetTextActionListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.widget.getData() instanceof URI) {
                        ModelURISelector.this.setURIText((URI)event.widget.getData());
                    } else {
                        ModelURISelector.this.setURIText(String.valueOf(event.widget.getData()));
                    }
                    ModelURISelector.this.enableLoad();
                }
            };
        }
        return this.mySetTextActionListener;
    }

    private void createToolBar(Composite parent) {
        final ToolBar toolBar = new ToolBar(parent, 0);
        new ToolItem(toolBar, 2);
        new ToolItem(toolBar, 2);
        final ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setText(Messages.uriSelectorBrowse);
        toolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rect = toolItem.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBar.toDisplay(pt);
                    ModelURISelector.this.getBrowseMenu().setLocation(pt.x, pt.y);
                    ModelURISelector.this.getBrowseMenu().setVisible(true);
                } else {
                    ModelURISelector.this.handleDefaultToolBarAction();
                }
            }
        });
        new ToolItem(toolBar, 2);
        new ToolItem(toolBar, 2);
        this.myLoadBtn = new ToolItem(toolBar, 8);
        this.myLoadBtn.setText(Messages.uriSelectorLoad);
        this.myLoadBtn.addListener(13, (Listener)this);
    }

    protected Menu createBrowseMenu(Control parent) {
        Menu menu = new Menu(parent);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.uriSelectorWorkspace);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ModelURISelector.this.handleBrowseWorkspace();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.uriSelectorFilesystem);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ModelURISelector.this.handleBrowseFilesystem();
            }
        });
        return menu;
    }

    protected void handleDefaultToolBarAction() {
        this.handleBrowseWorkspace();
    }

    protected void handleBrowseWorkspace() {
        IResource resource;
        ResourceSelectionDialog d = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), null);
        if (d.open() != 0) {
            return;
        }
        Object[] result = d.getResult();
        if (result != null && this.isValidWorkspaceResource(resource = (IResource)result[0])) {
            this.setURIText(URI.createURI((String)URI.createPlatformResourceURI((String)resource.getFullPath().toString()).toString(), (boolean)true).toString());
            this.enableLoad();
        }
    }

    protected void handleBrowseFilesystem() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4100);
        fileDialog.setFilterExtensions(new String[]{"*." + this.myFileExt});
        if (fileDialog.open() != null && fileDialog.getFileNames().length > 0) {
            String filePath = fileDialog.getFileNames()[0];
            this.setURIText(URI.createFileURI((String)filePath).toString());
            this.enableLoad();
        }
    }

    protected boolean isValidWorkspaceResource(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        return this.myFileExt.equals(((IFile)resource).getFileExtension());
    }

    protected Shell getShell() {
        return this.myControl.getShell();
    }

    public void handleEvent(Event event) {
        this.myModelLoader.run(this, this.uriText.getText());
    }

    static interface Loader {
        public void run(ModelURISelector var1, String var2);
    }
}

