/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardActionRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Plugin
extends AbstractUIPlugin {
    public static final String GMF_LOGO_IMAGE = "/icons/viewban/logo.png";
    public static final String SYNC_ICON = "/icons/cview16/synced.gif";
    public static final String DGM_ICON = "/icons/full/obj16/GenModelModelFile.gif";
    public static final String GDM_ICON = "/icons/full/obj16/GMFGraphModelFile.gif";
    public static final String DM_ICON = "/icons/full/obj16/EcoreModelFile.gif";
    public static final String TDM_ICON = "/icons/full/obj16/GMFToolModelFile.gif";
    public static final String MM_ICON = "/icons/full/obj16/GMFMapModelFile.gif";
    public static final String GM_ICON = "/icons/full/obj16/GMFGenModelFile.gif";
    private static Plugin plugin;
    private DashboardActionRegistry daRegistry;

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.daRegistry != null) {
            this.daRegistry.dispose();
            this.daRegistry = null;
        }
        super.stop(context);
        plugin = null;
    }

    public static Plugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.loadImage(reg, GMF_LOGO_IMAGE);
        this.loadImage(reg, SYNC_ICON);
        this.loadImage(reg, DGM_ICON, "org.eclipse.emf.codegen.ecore.ui");
        this.loadImage(reg, GDM_ICON, "org.eclipse.gmf.graphdef.edit");
        this.loadImage(reg, DM_ICON, "org.eclipse.emf.ecore.editor");
        this.loadImage(reg, TDM_ICON, "org.eclipse.gmf.tooldef.edit");
        this.loadImage(reg, MM_ICON, "org.eclipse.gmf.map.edit");
        this.loadImage(reg, GM_ICON, "org.eclipse.gmf.codegen.edit");
    }

    protected void loadImage(ImageRegistry registry, String id) {
        this.loadImage(registry, id, this.getBundle().getSymbolicName());
    }

    protected void loadImage(ImageRegistry registry, String id, String bundleId) {
        ImageDescriptor descriptor = Plugin.imageDescriptorFromPlugin((String)bundleId, (String)id);
        if (descriptor != null) {
            registry.put(id, descriptor);
        }
    }

    public static String getBundleString(String key) {
        return Platform.getResourceBundle((Bundle)Plugin.getDefault().getBundle()).getString(key);
    }

    public static String getBundleString(String key, Object[] args) {
        String val = Plugin.getBundleString(key);
        if (val == null) {
            return key;
        }
        return MessageFormat.format(val, args);
    }

    public DashboardActionRegistry getDashboardActionRegistry() {
        if (this.daRegistry == null) {
            this.daRegistry = new DashboardActionRegistry();
        }
        return this.daRegistry;
    }

    public static IStatus createStatus(int statusCode, String message, Exception ex) {
        return new Status(statusCode, Plugin.getPluginID(), 0, message, (Throwable)ex);
    }

    public static IStatus createError(String message, Exception ex) {
        return Plugin.createStatus(4, message, ex);
    }

    public static IStatus createWarning(String message) {
        return Plugin.createStatus(2, message, null);
    }

    public static IStatus createInfo(String message) {
        return Plugin.createStatus(1, message, null);
    }

    public static String getPluginID() {
        return Plugin.getDefault().getBundle().getSymbolicName();
    }
}

