/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.document;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.EditorInputProxy;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IEditorInput;
import org.osgi.framework.Bundle;

public class DiagramInputDocumentProvider
extends AbstractDocumentProvider
implements IDiagramDocumentProvider {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramInputDocumentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document;
        if (element instanceof IDiagramEditorInput && this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element)) {
            this.setupDocument(element, document);
            return document;
        }
        return null;
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    protected IDocument createEmptyDocument() {
        return new DiagramDocument();
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IDiagramEditorInput) {
            IDocument document = null;
            IStatus status = null;
            try {
                document = this.createDocument(element);
            }
            catch (CoreException x) {
                this.handleCoreException(x, EditorMessages.DiagramInputDocumentProvider_createElementInfo);
                status = x.getStatus();
                document = this.createEmptyDocument();
            }
            DiagramModificationListener listener = new DiagramModificationListener(this, (DiagramDocument)document);
            DiagramResourceInfo info = new DiagramResourceInfo(document, listener);
            info.fStatus = status;
            listener.startListening();
            return info;
        }
        return super.createElementInfo(element);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        super.disposeElementInfo(element, info);
        ((DiagramResourceInfo)info).fListener.stopListening();
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        if (editorInput instanceof IDiagramEditorInput) {
            Diagram diagram = ((IDiagramEditorInput)editorInput).getDiagram();
            document.setContent(diagram);
            return true;
        }
        return false;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    protected void updateCache(IDiagramEditorInput input) throws CoreException {
        DiagramResourceInfo info = (DiagramResourceInfo)this.getElementInfo(input);
        if (info != null) {
            IStorage storage;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((storage = (IStorage)input.getAdapter((Class)clazz)) != null) {
                boolean readOnly;
                info.fIsReadOnly = readOnly = storage.isReadOnly();
                info.fIsModifiable = !readOnly;
            }
            info.fUpdateCache = false;
        }
    }

    public boolean isReadOnly(Object element) {
        DiagramResourceInfo info;
        if (element instanceof IDiagramEditorInput && (info = (DiagramResourceInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IDiagramEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, EditorMessages.DiagramInputDocumentProvider_isReadOnly);
                }
            }
            return info.fIsReadOnly;
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        DiagramResourceInfo info;
        if (element instanceof IDiagramEditorInput && (info = (DiagramResourceInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IDiagramEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, EditorMessages.DiagramInputDocumentProvider_isModifiable);
                }
            }
            return info.fIsModifiable;
        }
        return super.isModifiable(element);
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
        DiagramResourceInfo info;
        if (element instanceof IDiagramEditorInput && (info = (DiagramResourceInfo)this.getElementInfo(element)) != null) {
            info.fUpdateCache = true;
        }
        super.doUpdateStateCache(element);
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public IDiagramDocument getDiagramDocument(Object element) {
        IDocument doc = this.getDocument(element);
        if (doc instanceof IDiagramDocument) {
            return (IDiagramDocument)doc;
        }
        return null;
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput editorInput, TransactionalEditingDomain domain) {
        if (editorInput instanceof IDiagramEditorInput) {
            return new EditorInputProxy(editorInput, domain);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected class DiagramResourceInfo
    extends AbstractDocumentProvider.ElementInfo {
        public boolean fIsModifiable;
        public boolean fIsReadOnly;
        public boolean fUpdateCache;
        public DiagramModificationListener fListener;

        public DiagramResourceInfo(IDocument document, DiagramModificationListener listener) {
            super(document);
            this.fIsModifiable = false;
            this.fIsReadOnly = true;
            this.fUpdateCache = true;
            this.fListener = null;
            this.fListener = listener;
        }
    }
}

