/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.ast.Definition;
import org.eclipse.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;
import org.eclipse.gmf.tests.xpand.AbstractXpandTest;
import org.eclipse.gmf.tests.xpand.DumpEvaluationListener;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;

public class StatementEvaluatorTest
extends AbstractXpandTest {
    private XpandExecutionContextImpl execCtx;
    private BufferOutput out;
    private StringBuilder buffer;

    protected void setUp() throws Exception {
        super.setUp();
        this.buffer = new StringBuilder();
        this.out = new BufferOutput(this.buffer);
        this.execCtx = this.createCtx((Output)this.out);
    }

    private XpandExecutionContextImpl createCtx(Output out) {
        this.buffer.setLength(0);
        XpandExecutionContextImpl result = new XpandExecutionContextImpl((ResourceManager)new TestsResourceManager(), out, null);
        result.setEvaluationListener((EvaluationListener)new DumpEvaluationListener());
        return result;
    }

    public final void testEvaluation() throws Exception {
        new XpandFacade((XpandExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::EvaluateStart::start", (Object)"test", new Object[0]);
        System.out.println(this.buffer.toString());
    }

    public final void testIf() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("IF test==1") + "if" + this.tag("ELSEIF test==2") + "elseif" + this.tag("ELSE") + "else" + this.tag("ENDIF") + this.tag("ENDDEFINE"));
        StatementEvaluatorTest.assertEquals((int)1, (int)t.getDefinitions().length);
        IfStatement ifSt = (IfStatement)((Definition)t.getDefinitions()[0]).getBody()[1];
        XpandExecutionContext ctx = (XpandExecutionContext)this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{new Variable("test", (Object)new Integer(1))});
        ifSt.evaluate(ctx);
        StatementEvaluatorTest.assertEquals((String)"if", (String)this.buffer.toString());
        ifSt.evaluate((XpandExecutionContext)((XpandExecutionContextImpl)this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{new Variable("test", (Object)new Integer(2))})));
        StatementEvaluatorTest.assertEquals((String)"elseif", (String)this.buffer.toString());
        ifSt.evaluate((XpandExecutionContext)((XpandExecutionContextImpl)this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{new Variable("test", (Object)new Integer(3))})));
        StatementEvaluatorTest.assertEquals((String)"else", (String)this.buffer.toString());
    }

    public final void testForeach() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("FOREACH tests AS test SEPARATOR ','") + this.tag("test") + this.tag("ENDFOREACH") + this.tag("ENDDEFINE"));
        StatementEvaluatorTest.assertEquals((int)1, (int)t.getDefinitions().length);
        ForEachStatement foreachSt = (ForEachStatement)((Definition)t.getDefinitions()[0]).getBody()[1];
        ArrayList<String> tests = new ArrayList<String>();
        foreachSt.evaluate((XpandExecutionContext)((XpandExecutionContextImpl)this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{new Variable("tests", tests)})));
        StatementEvaluatorTest.assertEquals((String)"", (String)this.buffer.toString());
        tests.add("hallo");
        foreachSt.evaluate((XpandExecutionContext)((XpandExecutionContextImpl)this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{new Variable("tests", tests)})));
        StatementEvaluatorTest.assertEquals((String)"hallo", (String)this.buffer.toString());
        tests.add("Du");
        foreachSt.evaluate((XpandExecutionContext)((XpandExecutionContextImpl)this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{new Variable("tests", tests)})));
        StatementEvaluatorTest.assertEquals((String)"hallo,Du", (String)this.buffer.toString());
        tests.add("da");
        foreachSt.evaluate((XpandExecutionContext)((XpandExecutionContextImpl)this.createCtx((Output)this.out).cloneWithVariable(new Variable[]{new Variable("tests", tests)})));
        StatementEvaluatorTest.assertEquals((String)"hallo,Du,da", (String)this.buffer.toString());
    }

    public final void testMultilineText() throws Exception {
        String text = "abc\r\ncba";
        String str = String.valueOf(this.tag("DEFINE z FOR o")) + text + this.tag("ENDDEFINE");
        Template t = this.parse(str);
        StatementEvaluatorTest.assertNotNull((Object)t);
        TextStatement textStmt = (TextStatement)((Definition)t.getDefinitions()[0]).getBody()[0];
        StatementEvaluatorTest.assertEquals((String)text, (String)textStmt.getValue());
    }

    public final void testTrailingText() {
        String str = String.valueOf(this.tag("DEFINE z FOR o")) + "abc" + this.tag("ENDDEFINExxx");
        try {
            Template t = this.parse(str);
            StatementEvaluatorTest.assertNull((Object)t);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StatementEvaluatorTest.fail((String)("Parsing should not fail with exception (" + ex.getClass().getSimpleName() + ")even when the grammar is incorrect"));
        }
    }

    public final void testCommentOnly() throws Exception {
        StatementEvaluatorTest.assertNotNull((Object)this.parse(String.valueOf(this.tag("REM")) + "zx" + this.tag("ENDREM")));
    }

    public final void testCommentNestedTag() throws Exception {
        String nestedTag = String.valueOf(this.tag("DEFINE")) + "placeholder" + this.tag("ENDDEFINE");
        String string = String.valueOf(this.tag("REM")) + " bla-bla " + nestedTag + " foo" + this.tag("ENDREM");
        string = String.valueOf(string) + this.tag("DEFINE z FOR o") + this.tag("ENDDEFINE");
        StatementEvaluatorTest.assertNotNull((Object)this.parse(string));
    }

    public final void testWhitespacesAtTopLevel() throws Exception {
        String text = String.valueOf(this.tag("REM")) + "zx" + this.tag("ENDREM");
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + this.tag("DEFINE test FOR Object") + this.tag("ENDDEFINE");
        text = String.valueOf(text) + "\r";
        StatementEvaluatorTest.assertNotNull((Object)this.parse(text));
    }

    public final void testComment() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + "TEST" + this.tag("REM") + "zx" + this.tag("ENDREM") + "test" + this.tag("FOREACH tests AS test SEPARATOR ','") + this.tag("test") + this.tag("ENDFOREACH") + this.tag("ENDDEFINE"));
        TextStatement text = (TextStatement)((Definition)t.getDefinitions()[0]).getBody()[0];
        StatementEvaluatorTest.assertEquals((String)"TEST", (String)text.getValue());
        text = (TextStatement)((Definition)t.getDefinitions()[0]).getBody()[1];
        StatementEvaluatorTest.assertEquals((String)"test", (String)text.getValue());
    }

    public final void testMultiParams1() throws Exception {
        new XpandFacade((XpandExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::MultiParams::test", (Object)"A", new Object[]{"B", "C"});
        StatementEvaluatorTest.assertEquals((String)"ABC1", (String)this.buffer.toString());
    }

    public final void testMultiParams2() throws Exception {
        new XpandFacade((XpandExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::MultiParams::test", (Object)"A", new Object[]{"B", new Integer(1)});
        StatementEvaluatorTest.assertEquals((String)"AB12", (String)this.buffer.toString());
    }

    public final void testForeach2() throws Exception {
        new XpandFacade((XpandExecutionContext)this.execCtx).evaluate("org::eclipse::gmf::tests::xpand::evaluate::Foreach::test", (Object)"ABC", new Object[0]);
        String[] result = this.buffer.toString().trim().split(",");
        StatementEvaluatorTest.assertEquals((String)"ABC", (String)result[0].trim());
        StatementEvaluatorTest.assertEquals((String)"AABCBABCC", (String)result[1].trim());
    }

    public void testReferenceAnotherDefinition() throws Exception {
        String test = String.valueOf(this.tag("DEFINE test FOR String")) + "TEST" + this.tag("EXPAND test2") + this.tag("ENDDEFINE");
        String test2 = String.valueOf(this.tag("DEFINE test2 FOR String")) + "2" + this.tag("ENDDEFINE");
        Template t = this.parse(String.valueOf(test) + "\n" + test2);
        XpandDefinition xpandDefinition = t.getDefinitions()[0];
        XpandExecutionContext ctx = ContextFactory.createXpandContext(null, (Output)this.out, Collections.emptyList());
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable[]{new Variable("this", (Object)"")});
        xpandDefinition.evaluate(ctx);
        StatementEvaluatorTest.assertEquals((String)"TEST2", (String)this.buffer.toString());
    }
}

