/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.CollectionTypesSupport;
import org.eclipse.gmf.internal.xpand.StringHelper;
import org.eclipse.gmf.internal.xpand.expression.PolymorphicResolver;
import org.eclipse.gmf.internal.xpand.migration.Activator;
import org.eclipse.gmf.internal.xpand.model.XpandDefinitionWrap;
import org.eclipse.gmf.internal.xpand.model.XpandIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinMetaModel {
    public static final String SET = "Set";
    public static final String LIST = "List";
    protected static EPackage XECORE = EcoreFactory.eINSTANCE.createEPackage();
    private static EClass PARAMETERIZED_TYPE;
    private static EReference PT_INNER_TYPE_REF;
    private static EAttribute PT_INNER_TYPE_ATTR;
    public static final EClass VOID;
    protected static CollectionTypesSupport collectionTypes;
    public static final EClass DEFINITION_TYPE;
    public static final EClass ITERATOR_TYPE;
    private static Map<String, String> attrNameSubsts;
    public static EOperation Collection_IsEmpty;
    public static EOperation Collection_Add;
    public static EOperation Collection_AddAll;
    public static EOperation Collection_Clear;
    public static EOperation Collection_Flatten;
    public static EOperation Collection_Size;
    public static EOperation Collection_Union;
    public static EOperation Collection_Intersect;
    public static EOperation Collection_Without;
    public static EOperation Collection_ToSet;
    public static EOperation Collection_ToList;
    public static EOperation Collection_Contains;
    public static EOperation Collection_ContainsAll;
    public static EOperation List_Get;
    public static EOperation List_First;
    public static EOperation List_Last;
    public static EOperation List_WithoutFirst;
    public static EOperation List_WithoutLast;
    public static EOperation List_PurgeDups;
    public static EOperation List_IndexOf;
    public static EOperation Boolean_NE;
    public static EOperation Int_Plus_Int;
    public static EOperation Int_Plus_Double;
    public static EOperation Int_Minus_Int;
    public static EOperation Int_Minus_Double;
    public static EOperation Int_Mult_Int;
    public static EOperation Int_Mult_Double;
    public static EOperation Int_Div_Int;
    public static EOperation Int_Div_Double;
    public static EOperation Int_Unary_Minus;
    public static EOperation Int_GreatOrEqual;
    public static EOperation Int_LessOrEqual;
    public static EOperation Int_Less;
    public static EOperation Int_Greater;
    public static EOperation Int_UpTo;
    public static EOperation Double_Plus_Double;
    public static EOperation Double_Plus_Int;
    public static EOperation Double_Minus_Double;
    public static EOperation Double_Minus_Int;
    public static EOperation Double_Mult_Double;
    public static EOperation Double_Mult_Int;
    public static EOperation Double_Div_Double;
    public static EOperation Double_Div_Int;
    public static EOperation Double_Unary_Minus;
    public static EOperation Object_EQ;
    public static EOperation EString_ToFirstUpper;
    public static EOperation EString_Plus_EJavaObject;
    public static EOperation EString_ToFirstLower;
    public static EOperation EString_ToCharList;
    public static EOperation EString_StartsWith;
    public static EOperation EString_EndsWith;
    public static EOperation EString_SubString_StartEnd;
    public static EOperation EString_SubString;
    public static EOperation EString_ToUpperCase;
    public static EOperation EString_ToLowerCase;
    public static EOperation EString_ReplaceAll;
    public static EOperation EString_ReplaceFirst;
    public static EOperation EString_Split;
    public static EOperation EString_Matches;
    public static EOperation EString_Trim;
    public static EOperation EString_Length;
    public static EOperation Object_CompareTo;
    public static EOperation Object_ToString;
    public static EOperation Object_NotEQ;
    private static final Map<EClassifier, List<InternalOperation>> internalOperationsMap;
    private static final Map<EOperation, Method> externalOpImplementations;

    static {
        XECORE.setName("xecore");
        XECORE.setNsPrefix("xecore");
        XECORE.setNsURI("uri:org.eclipse.modeling/m2t/xpand/xecore/1.0");
        PARAMETERIZED_TYPE = EcoreFactory.eINSTANCE.createEClass();
        PT_INNER_TYPE_REF = EcoreFactory.eINSTANCE.createEReference();
        PT_INNER_TYPE_ATTR = EcoreFactory.eINSTANCE.createEAttribute();
        PARAMETERIZED_TYPE.setName("ParameterizedType");
        PARAMETERIZED_TYPE.getESuperTypes().add((Object)EcorePackage.eINSTANCE.getEClass());
        PARAMETERIZED_TYPE.setAbstract(true);
        PT_INNER_TYPE_REF.setName("innerType");
        PT_INNER_TYPE_REF.setContainment(false);
        PT_INNER_TYPE_REF.setEType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        PARAMETERIZED_TYPE.getEStructuralFeatures().add((Object)PT_INNER_TYPE_REF);
        PT_INNER_TYPE_ATTR.setName("innerDataType");
        PT_INNER_TYPE_ATTR.setEType((EClassifier)EcorePackage.eINSTANCE.getEDataType());
        PARAMETERIZED_TYPE.getEStructuralFeatures().add((Object)PT_INNER_TYPE_ATTR);
        XECORE.getEClassifiers().add((Object)PARAMETERIZED_TYPE);
        VOID = EcoreFactory.eINSTANCE.createEClass();
        VOID.setName("void");
        XECORE.getEClassifiers().add((Object)VOID);
        collectionTypes = new CollectionTypesSupport();
        collectionTypes.init(XECORE, PARAMETERIZED_TYPE);
        DEFINITION_TYPE = EcoreFactory.eINSTANCE.createEClass();
        DEFINITION_TYPE.setName("xpand2::Definition");
        DEFINITION_TYPE.getESuperTypes().add((Object)EcorePackage.eINSTANCE.getEClass());
        XECORE.getEClassifiers().add((Object)DEFINITION_TYPE);
        ITERATOR_TYPE = EcoreFactory.eINSTANCE.createEClass();
        ITERATOR_TYPE.setName("xpand2::Iterator");
        ITERATOR_TYPE.getESuperTypes().add((Object)EcorePackage.eINSTANCE.getEClass());
        XECORE.getEClassifiers().add((Object)ITERATOR_TYPE);
        attrNameSubsts = new TreeMap<String, String>();
        attrNameSubsts.put("default_", "default");
        internalOperationsMap = new HashMap<EClassifier, List<InternalOperation>>();
        EcorePackage ecorePkg = EcorePackage.eINSTANCE;
        OperationFactory opf = new OperationFactory();
        LinkedList<InternalOperation> objectOps = new LinkedList<InternalOperation>();
        Object_CompareTo = opf.create("compareTo", (EClassifier)ecorePkg.getEBoolean(), new EClassifier[]{ecorePkg.getEJavaObject()});
        objectOps.add(new InternalOperation<Object>(Object_CompareTo){

            @Override
            public Object evaluate(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? 0 : -1;
                }
                if (params[0] == null) {
                    return 1;
                }
                if (target instanceof Comparable) {
                    return ((Comparable)target).compareTo(params[0]);
                }
                return String.valueOf(target).compareTo(String.valueOf(params[0]));
            }
        });
        Object_ToString = opf.create("toString", (EClassifier)ecorePkg.getEString(), new EClassifier[0]);
        objectOps.add(new InternalOperation<Object>(Object_ToString){

            @Override
            public Object evaluate(Object target, Object[] params) {
                return String.valueOf(target);
            }
        });
        Object_EQ = opf.create("==", Boolean.TYPE, Object.class);
        objectOps.add(new InternalOperation<Object>(Object_EQ){

            @Override
            public Object evaluate(Object target, Object[] params) {
                return target == null ? params[0] == null : target.equals(params[0]);
            }
        });
        Object_NotEQ = opf.create("!=", Boolean.TYPE, Object.class);
        objectOps.add(new InternalOperation<Object>(Object_NotEQ){

            @Override
            public Object evaluate(Object target, Object[] params) {
                return target == null ? params[0] != null : !target.equals(params[0]);
            }
        });
        List unmodifiableObjectOps = Collections.unmodifiableList(objectOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEJavaObject(), unmodifiableObjectOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEEnumerator(), unmodifiableObjectOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEEnum(), unmodifiableObjectOps);
        LinkedList<InternalOperation<Object>> stringOps = new LinkedList<InternalOperation<Object>>();
        EString_Plus_EJavaObject = opf.create("+", (EClassifier)ecorePkg.getEString(), new EClassifier[]{ecorePkg.getEJavaObject()});
        stringOps.add(new InternalOperation<String>(EString_Plus_EJavaObject){

            @Override
            public Object evaluate(String target, Object[] params) {
                return String.valueOf(target) + String.valueOf(params[0]);
            }
        });
        EString_ToFirstUpper = opf.create("toFirstUpper", (EClassifier)ecorePkg.getEString(), new EClassifier[0]);
        stringOps.add(new InternalOperation<String>(EString_ToFirstUpper){

            @Override
            public Object evaluate(String target, Object[] params) {
                return StringHelper.firstUpper(target);
            }
        });
        EString_ToFirstLower = opf.create("toFirstLower", (EClassifier)ecorePkg.getEString(), new EClassifier[0]);
        stringOps.add(new InternalOperation<String>(EString_ToFirstLower){

            @Override
            public Object evaluate(String target, Object[] params) {
                return StringHelper.firstLower(target);
            }
        });
        EString_ToCharList = opf.create("toCharList", (EClassifier)collectionTypes.getListType((EClassifier)ecorePkg.getEString()), new EClassifier[0]);
        stringOps.add(new InternalOperation<String>(EString_ToCharList){

            @Override
            public Object evaluate(String target, Object[] params) {
                ArrayList<String> rv = new ArrayList<String>(target.length());
                int i = 0;
                while (i < target.length()) {
                    rv.add(target.substring(i, i + 1));
                    ++i;
                }
                return rv;
            }
        });
        InternalOperation internalOp = opf.createReflective(String.class, "startsWith", String.class);
        stringOps.add(internalOp);
        EString_StartsWith = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "endsWith", String.class);
        stringOps.add(internalOp);
        EString_EndsWith = internalOp.metaOp;
        InternalOperation subStringOp = opf.createReflective(String.class, "substring", Integer.TYPE, Integer.TYPE);
        subStringOp.metaOp.setName("subString");
        EString_SubString_StartEnd = subStringOp.metaOp;
        stringOps.add(subStringOp);
        subStringOp = opf.createReflective(String.class, "substring", Integer.TYPE);
        subStringOp.metaOp.setName("subString");
        EString_SubString = subStringOp.metaOp;
        stringOps.add(subStringOp);
        internalOp = opf.createReflective(String.class, "toUpperCase", new Class[0]);
        stringOps.add(internalOp);
        EString_ToUpperCase = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "toLowerCase", new Class[0]);
        stringOps.add(internalOp);
        EString_ToLowerCase = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "replaceAll", String.class, String.class);
        stringOps.add(internalOp);
        EString_ReplaceAll = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "replaceFirst", String.class, String.class);
        stringOps.add(internalOp);
        EString_ReplaceFirst = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "split", String.class);
        stringOps.add(internalOp);
        EString_Split = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "matches", String.class);
        stringOps.add(internalOp);
        EString_Matches = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "trim", new Class[0]);
        stringOps.add(internalOp);
        EString_Trim = internalOp.metaOp;
        internalOp = opf.createReflective(String.class, "length", new Class[0]);
        stringOps.add(internalOp);
        EString_Length = internalOp.metaOp;
        stringOps.addAll(unmodifiableObjectOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEString(), Collections.unmodifiableList(stringOps));
        LinkedList<9> booleanOps = new LinkedList<9>();
        Boolean_NE = opf.create("!", Boolean.TYPE, new Class[0]);
        booleanOps.add(new InternalOperation<Boolean>(Boolean_NE){

            @Override
            public Object evaluate(Boolean target, Object[] params) {
                return target == false;
            }
        });
        booleanOps.addAll(unmodifiableObjectOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEBoolean(), Collections.unmodifiableList(booleanOps));
        LinkedList voidOps = new LinkedList();
        voidOps.addAll(unmodifiableObjectOps);
        internalOperationsMap.put((EClassifier)VOID, Collections.unmodifiableList(voidOps));
        LinkedList<InternalOperation<Object>> intOps = new LinkedList<InternalOperation<Object>>();
        Int_Plus_Int = opf.create("+", Integer.TYPE, Integer.TYPE);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternalSumOp
        extends InternalOperation<Number> {
            InternalSumOp(EOperation metaOp) {
                super(metaOp);
            }

            @Override
            public Object evaluate(Number target, Object[] params) {
                if (target instanceof Double || params[0] instanceof Double) {
                    return new Double(target.doubleValue() + ((Number)params[0]).doubleValue());
                }
                return new Integer(target.intValue() + ((Number)params[0]).intValue());
            }
        }
        intOps.add(new InternalSumOp(Int_Plus_Int));
        Int_Plus_Double = opf.create("+", Integer.TYPE, Double.TYPE);
        intOps.add(new InternalSumOp(Int_Plus_Double));
        Int_Minus_Int = opf.create("-", Integer.TYPE, Integer.TYPE);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternalSubOp
        extends InternalOperation<Number> {
            InternalSubOp(EOperation metaOp) {
                super(metaOp);
            }

            @Override
            public Object evaluate(Number target, Object[] params) {
                if (target instanceof Double || params[0] instanceof Double) {
                    return new Double(target.doubleValue() - ((Number)params[0]).doubleValue());
                }
                return new Integer(target.intValue() - ((Number)params[0]).intValue());
            }
        }
        intOps.add(new InternalSubOp(Int_Minus_Int));
        Int_Minus_Double = opf.create("-", Double.TYPE, Double.TYPE);
        intOps.add(new InternalSubOp(Int_Minus_Double));
        Int_Mult_Int = opf.create("*", Integer.TYPE, Integer.TYPE);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternalMulOp
        extends InternalOperation<Number> {
            InternalMulOp(EOperation metaOp) {
                super(metaOp);
            }

            @Override
            public Object evaluate(Number target, Object[] params) {
                if (target instanceof Double || params[0] instanceof Double) {
                    return new Double(target.doubleValue() * ((Number)params[0]).doubleValue());
                }
                return new Integer(target.intValue() * ((Number)params[0]).intValue());
            }
        }
        intOps.add(new InternalMulOp(Int_Mult_Int));
        Int_Mult_Double = opf.create("*", Integer.TYPE, Double.TYPE);
        intOps.add(new InternalMulOp(Int_Mult_Double));
        Int_Div_Int = opf.create("/", Integer.TYPE, Integer.TYPE);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternalDivOp
        extends InternalOperation<Number> {
            InternalDivOp(EOperation metaOp) {
                super(metaOp);
            }

            @Override
            public Object evaluate(Number target, Object[] params) {
                if (target instanceof Double || params[0] instanceof Double) {
                    return new Double(target.doubleValue() / ((Number)params[0]).doubleValue());
                }
                return new Integer(target.intValue() / ((Number)params[0]).intValue());
            }
        }
        intOps.add(new InternalDivOp(Int_Div_Int));
        Int_Div_Double = opf.create("/", Integer.TYPE, Double.TYPE);
        intOps.add(new InternalDivOp(Int_Div_Double));
        Int_Unary_Minus = opf.create("-", Integer.TYPE, new Class[0]);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternalNegateOp
        extends InternalOperation<Number> {
            InternalNegateOp(EOperation metaOp) {
                super(metaOp);
            }

            @Override
            public Object evaluate(Number target, Object[] params) {
                if (target instanceof Double) {
                    return -target.doubleValue();
                }
                return -target.intValue();
            }
        }
        intOps.add(new InternalNegateOp(Int_Unary_Minus));
        Int_GreatOrEqual = opf.create(">=", Boolean.TYPE, Integer.TYPE);
        intOps.add(new InternalOperation<Number>(Int_GreatOrEqual){

            @Override
            public Object evaluate(Number target, Object[] params) {
                return target.intValue() >= ((Number)params[0]).intValue();
            }
        });
        Int_LessOrEqual = opf.create("<=", Boolean.TYPE, Integer.TYPE);
        intOps.add(new InternalOperation<Number>(Int_LessOrEqual){

            @Override
            public Object evaluate(Number target, Object[] params) {
                return target.intValue() <= ((Number)params[0]).intValue();
            }
        });
        Int_Less = opf.create("<", Boolean.TYPE, Integer.TYPE);
        intOps.add(new InternalOperation<Number>(Int_Less){

            @Override
            public Object evaluate(Number target, Object[] params) {
                return target.intValue() < ((Number)params[0]).intValue();
            }
        });
        Int_Greater = opf.create(">", Boolean.TYPE, Integer.TYPE);
        intOps.add(new InternalOperation<Number>(Int_Greater){

            @Override
            public Object evaluate(Number target, Object[] params) {
                return target.intValue() > ((Number)params[0]).intValue();
            }
        });
        Int_UpTo = opf.create("upTo", (EClassifier)collectionTypes.getListType((EClassifier)ecorePkg.getEInt()), new EClassifier[]{ecorePkg.getEInt()});
        intOps.add(new InternalOperation<Number>(Int_UpTo){

            @Override
            public Object evaluate(Number target, Object[] params) {
                ArrayList<Integer> result = new ArrayList<Integer>();
                int l1 = target.intValue();
                int l2 = ((Number)params[0]).intValue();
                while (l1 <= l2) {
                    result.add(new Integer(l1));
                    ++l1;
                }
                return result;
            }
        });
        intOps.addAll(unmodifiableObjectOps);
        List unmodifiableListIntOps = Collections.unmodifiableList(intOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEIntegerObject(), unmodifiableListIntOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEInt(), unmodifiableListIntOps);
        LinkedList<InternalOperation<Object>> doubleOps = new LinkedList<InternalOperation<Object>>();
        Double_Plus_Double = opf.create("+", Double.TYPE, Double.TYPE);
        doubleOps.add(new InternalSumOp(Double_Plus_Double));
        Double_Plus_Int = opf.create("+", Double.TYPE, Integer.TYPE);
        doubleOps.add(new InternalSumOp(Double_Plus_Int));
        Double_Minus_Double = opf.create("-", Double.TYPE, Double.TYPE);
        doubleOps.add(new InternalSubOp(Double_Minus_Double));
        Double_Minus_Int = opf.create("-", Double.TYPE, Integer.TYPE);
        doubleOps.add(new InternalSubOp(Double_Minus_Int));
        Double_Mult_Double = opf.create("*", Double.TYPE, Double.TYPE);
        doubleOps.add(new InternalMulOp(Double_Mult_Double));
        Double_Mult_Int = opf.create("*", Double.TYPE, Integer.TYPE);
        doubleOps.add(new InternalMulOp(Double_Mult_Int));
        Double_Div_Double = opf.create("/", Double.TYPE, Double.TYPE);
        doubleOps.add(new InternalDivOp(Double_Div_Double));
        Double_Div_Int = opf.create("/", Double.TYPE, Integer.TYPE);
        doubleOps.add(new InternalDivOp(Double_Div_Int));
        Double_Unary_Minus = opf.create("-", Double.TYPE, new Class[0]);
        doubleOps.add(new InternalNegateOp(Double_Unary_Minus));
        doubleOps.addAll(unmodifiableObjectOps);
        internalOperationsMap.put((EClassifier)ecorePkg.getEDouble(), doubleOps);
        LinkedList<InternalOperation> collectionOps = new LinkedList<InternalOperation>();
        Collection_IsEmpty = opf.create("isEmpty", (EClassifier)ecorePkg.getEBoolean(), new EClassifier[0]);
        collectionOps.add(new InternalOperation<Collection>(Collection_IsEmpty){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                return target.isEmpty();
            }
        });
        Collection_Add = opf.create("add", (EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, new EClassifier[]{ecorePkg.getEJavaObject()});
        collectionOps.add(new InternalOperation<Collection>(Collection_Add){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                target.add(params[0]);
                return target;
            }
        });
        Collection_AddAll = opf.create("addAll", (EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, new EClassifier[]{CollectionTypesSupport.COLLECTION_OF_OBJECT});
        collectionOps.add(new InternalOperation<Collection>(Collection_AddAll){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                target.addAll((Collection)params[0]);
                return target;
            }
        });
        Collection_Clear = opf.create("clear", (EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, new EClassifier[0]);
        collectionOps.add(new InternalOperation<Collection>(Collection_Clear){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                target.clear();
                return target;
            }
        });
        Collection_Flatten = opf.create("flatten", (EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, new EClassifier[0]);
        collectionOps.add(new InternalOperation<Collection>(Collection_Flatten){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                LinkedList rv = new LinkedList();
                for (Object o : target) {
                    if (o instanceof Collection) {
                        rv.addAll((Collection)o);
                        continue;
                    }
                    rv.add(o);
                }
                return rv;
            }
        });
        Collection_Size = opf.create("size", (EClassifier)ecorePkg.getEInt(), new EClassifier[0]);
        collectionOps.add(new InternalOperation<Collection>(Collection_Size){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                return target.size();
            }
        });
        Collection_Union = opf.create("union", (EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, new EClassifier[]{CollectionTypesSupport.COLLECTION_OF_OBJECT});
        collectionOps.add(new InternalOperation<Collection>(Collection_Union){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                LinkedHashSet rv = new LinkedHashSet(target);
                rv.addAll((Collection)params[0]);
                return rv;
            }
        });
        Collection_Intersect = opf.create("intersect", (EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, new EClassifier[]{CollectionTypesSupport.COLLECTION_OF_OBJECT});
        collectionOps.add(new InternalOperation<Collection>(Collection_Intersect){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                LinkedHashSet rv = new LinkedHashSet(target);
                rv.retainAll((Collection)params[0]);
                return rv;
            }
        });
        Collection_Without = opf.create("without", (EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, new EClassifier[]{CollectionTypesSupport.COLLECTION_OF_OBJECT});
        collectionOps.add(new InternalOperation<Collection>(Collection_Without){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                LinkedHashSet rv = new LinkedHashSet(target);
                rv.removeAll((Collection)params[0]);
                return rv;
            }
        });
        Collection_ToSet = opf.create("toSet", (EClassifier)CollectionTypesSupport.SET_OF_OBJECT, new EClassifier[0]);
        collectionOps.add(new InternalOperation<Collection>(Collection_ToSet){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                return new LinkedHashSet(target);
            }
        });
        Collection_ToList = opf.create("toList", (EClassifier)CollectionTypesSupport.LIST_OF_OBJECT, new EClassifier[0]);
        collectionOps.add(new InternalOperation<Collection>(Collection_ToList){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                return new LinkedList(target);
            }
        });
        Collection_Contains = opf.create("contains", (EClassifier)ecorePkg.getEBoolean(), new EClassifier[]{ecorePkg.getEJavaObject()});
        collectionOps.add(new InternalOperation<Collection>(Collection_Contains){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                return target.contains(params[0]);
            }
        });
        Collection_ContainsAll = opf.create("containsAll", (EClassifier)ecorePkg.getEBoolean(), new EClassifier[]{CollectionTypesSupport.COLLECTION_OF_OBJECT});
        collectionOps.add(new InternalOperation<Collection>(Collection_ContainsAll){

            @Override
            public Object evaluate(Collection target, Object[] params) {
                return target.containsAll((Collection)params[0]);
            }
        });
        List unmodifiableListCollectionOps = Collections.unmodifiableList(collectionOps);
        internalOperationsMap.put((EClassifier)CollectionTypesSupport.COLLECTION_TYPE, unmodifiableListCollectionOps);
        internalOperationsMap.put((EClassifier)CollectionTypesSupport.SET_TYPE, unmodifiableListCollectionOps);
        LinkedList<InternalOperation> listOps = new LinkedList<InternalOperation>(unmodifiableListCollectionOps);
        List_Get = opf.create("get", (EClassifier)ecorePkg.getEJavaObject(), new EClassifier[]{ecorePkg.getEInt()});
        listOps.add(new InternalOperation<List>(List_Get){

            @Override
            public Object evaluate(List target, Object[] params) {
                int index = ((Number)params[0]).intValue();
                return index < target.size() ? target.get(index) : null;
            }
        });
        List_First = opf.create("first", (EClassifier)ecorePkg.getEJavaObject(), new EClassifier[0]);
        listOps.add(new InternalOperation<List>(List_First){

            @Override
            public Object evaluate(List target, Object[] params) {
                return target.isEmpty() ? null : target.get(0);
            }
        });
        List_Last = opf.create("last", (EClassifier)ecorePkg.getEJavaObject(), new EClassifier[0]);
        listOps.add(new InternalOperation<List>(List_Last){

            @Override
            public Object evaluate(List target, Object[] params) {
                return target.isEmpty() ? null : target.get(target.size() - 1);
            }
        });
        List_WithoutFirst = opf.create("withoutFirst", (EClassifier)CollectionTypesSupport.LIST_OF_OBJECT, new EClassifier[0]);
        listOps.add(new InternalOperation<List>(List_WithoutFirst){

            @Override
            public Object evaluate(List target, Object[] params) {
                if (!target.isEmpty()) {
                    LinkedList rv = new LinkedList(target);
                    rv.removeFirst();
                    return rv;
                }
                return target;
            }
        });
        List_WithoutLast = opf.create("withoutLast", (EClassifier)CollectionTypesSupport.LIST_OF_OBJECT, new EClassifier[0]);
        listOps.add(new InternalOperation<List>(List_WithoutLast){

            @Override
            public Object evaluate(List target, Object[] params) {
                if (!target.isEmpty()) {
                    LinkedList rv = new LinkedList(target);
                    rv.removeLast();
                    return rv;
                }
                return target;
            }
        });
        List_PurgeDups = opf.create("purgeDups", (EClassifier)CollectionTypesSupport.LIST_OF_OBJECT, new EClassifier[0]);
        listOps.add(new InternalOperation<List>(List_PurgeDups){

            @Override
            public Object evaluate(List target, Object[] params) {
                if (target.isEmpty()) {
                    return target;
                }
                return new LinkedList(new LinkedHashSet(target));
            }
        });
        List_IndexOf = opf.create("indexOf", (EClassifier)ecorePkg.getEInt(), new EClassifier[]{ecorePkg.getEJavaObject()});
        listOps.add(new InternalOperation<List>(List_IndexOf){

            @Override
            public Object evaluate(List target, Object[] params) {
                return target.indexOf(params[0]);
            }
        });
        internalOperationsMap.put((EClassifier)CollectionTypesSupport.LIST_TYPE, Collections.unmodifiableList(listOps));
        LinkedList<35> definitionOps = new LinkedList<35>();
        definitionOps.add(new InternalOperation<XpandDefinitionWrap>(opf.create("proceed", (EClassifier)VOID, new EClassifier[0])){

            @Override
            public Object evaluate(XpandDefinitionWrap target, Object[] params) {
                target.proceed();
                return null;
            }
        });
        internalOperationsMap.put((EClassifier)DEFINITION_TYPE, Collections.unmodifiableList(definitionOps));
        LinkedList<36> iteratorOps = new LinkedList<36>();
        iteratorOps.add(new InternalOperation<XpandIterator>(opf.create("isFirstIteration", (EClassifier)ecorePkg.getEBoolean(), new EClassifier[0])){

            @Override
            public Object evaluate(XpandIterator target, Object[] params) {
                return target.isFirstIteration();
            }
        });
        internalOperationsMap.put((EClassifier)ITERATOR_TYPE, Collections.unmodifiableList(iteratorOps));
        externalOpImplementations = new HashMap<EOperation, Method>();
    }

    public static boolean isParameterizedType(EClassifier parameterizedTypeM1) {
        return PARAMETERIZED_TYPE.isSuperTypeOf(parameterizedTypeM1.eClass());
    }

    public static boolean isCollectionType(EClassifier parameterizedTypeM1) {
        return BuiltinMetaModel.isAssignableFrom((EClassifier)CollectionTypesSupport.COLLECTION_OF_OBJECT, parameterizedTypeM1);
    }

    public static EClassifier getInnerType(EClassifier parameterizedTypeM1) {
        assert (BuiltinMetaModel.isParameterizedType(parameterizedTypeM1));
        if (parameterizedTypeM1.eIsSet((EStructuralFeature)PT_INNER_TYPE_REF)) {
            return (EClass)parameterizedTypeM1.eGet((EStructuralFeature)PT_INNER_TYPE_REF);
        }
        return (EDataType)parameterizedTypeM1.eGet((EStructuralFeature)PT_INNER_TYPE_ATTR);
    }

    public static EClass cloneParametrizedType(EClassifier parameterizedTypeM1, EClassifier innerTypeM1) {
        assert (BuiltinMetaModel.isParameterizedType(parameterizedTypeM1));
        return collectionTypes.getCollectionType(parameterizedTypeM1.eClass(), innerTypeM1);
    }

    static EClass internalNewParameterizedType(EClass parameterizedTypeM2, EClassifier inner) {
        assert (PARAMETERIZED_TYPE.isSuperTypeOf(parameterizedTypeM2));
        EObject anInstance = XECORE.getEFactoryInstance().create(parameterizedTypeM2);
        assert (anInstance instanceof EClass) : "EClass is first supertype with instanceClass set";
        ((EClass)anInstance).setName(String.valueOf(inner.getName()) + parameterizedTypeM2.getName());
        anInstance.eSet((EStructuralFeature)(inner instanceof EClass ? PT_INNER_TYPE_REF : PT_INNER_TYPE_ATTR), (Object)inner);
        return (EClass)anInstance;
    }

    public static boolean isCollectionMetaType(String name) {
        return collectionTypes.isCollectionMetaType(name);
    }

    public static EClass getCollectionType(String metaTypeName, EClassifier innerType) {
        return collectionTypes.getCollectionType(metaTypeName, innerType);
    }

    public static EClass getCollectionType(EClassifier innerType) {
        return collectionTypes.getCollectionType(innerType);
    }

    public static EClass getListType(EClassifier innerType) {
        return collectionTypes.getListType(innerType);
    }

    public static EClass getSetType(EClassifier innerType) {
        return collectionTypes.getSetType(innerType);
    }

    public static EClassifier getReturnType(EEnumLiteral sp) {
        return sp.getEEnum();
    }

    public static EClassifier getType(Object obj) {
        if (obj == null) {
            return VOID;
        }
        if (obj instanceof Enumerator) {
            return EcorePackage.eINSTANCE.getEEnumerator();
        }
        if (obj instanceof EObject) {
            return ((EObject)obj).eClass();
        }
        if (obj instanceof Collection) {
            EClassifier type = null;
            if (!((Collection)obj).isEmpty()) {
                type = BuiltinMetaModel.getType(((Collection)obj).iterator().next());
            }
            if (obj instanceof Set) {
                return collectionTypes.getSetType(type);
            }
            if (obj instanceof List) {
                return collectionTypes.getListType(type);
            }
            return collectionTypes.getCollectionType(type);
        }
        if (obj instanceof Boolean) {
            return EcorePackage.eINSTANCE.getEBoolean();
        }
        if (obj instanceof Byte || obj instanceof Integer || obj instanceof Long || obj instanceof Short) {
            return EcorePackage.eINSTANCE.getEInt();
        }
        if (obj instanceof Float || obj instanceof Double) {
            return EcorePackage.eINSTANCE.getEDouble();
        }
        if (obj instanceof String) {
            return EcorePackage.eINSTANCE.getEString();
        }
        if (obj instanceof XpandDefinitionWrap) {
            return DEFINITION_TYPE;
        }
        if (obj instanceof XpandIterator) {
            return ITERATOR_TYPE;
        }
        return EcorePackage.eINSTANCE.getEJavaObject();
    }

    public static Object newInstance(EClassifier t) {
        if (BuiltinMetaModel.isCollectionType(t)) {
            return collectionTypes.newInstance(t);
        }
        if (t.getInstanceClass() != null) {
            try {
                return t.getInstanceClass().newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static Operation executableOperation(String name, Object[] args, Object instance) {
        EClassifier[] argTypes = new EClassifier[args.length];
        int i = 0;
        while (i < args.length) {
            argTypes[i] = BuiltinMetaModel.getType(args[i]);
            ++i;
        }
        EOperation metaOp = BuiltinMetaModel.findOperation(BuiltinMetaModel.getType(instance), name, argTypes);
        if (metaOp == null) {
            return null;
        }
        if (InternalOperation.isInternalOp(metaOp)) {
            for (List<InternalOperation> ops : internalOperationsMap.values()) {
                for (InternalOperation internalOp : ops) {
                    if (internalOp.metaOp != metaOp) continue;
                    return new OperationEx(instance, args, internalOp);
                }
            }
            throw new IllegalStateException("Can't find implementation of built-in operation" + metaOp);
        }
        return new Operation(instance, args, metaOp, null, null);
    }

    public static EOperation findOperation(EClassifier targetType, String name, EClassifier[] args) {
        List<EOperation> allOp;
        if (BuiltinMetaModel.hasBuiltinSupport(targetType)) {
            allOp = BuiltinMetaModel.findInternalOp(targetType);
        } else if (BuiltinMetaModel.hasBuiltinSupport((EClassifier)targetType.eClass())) {
            allOp = BuiltinMetaModel.findInternalOp((EClassifier)targetType.eClass());
        } else {
            if (!(targetType instanceof EClass)) {
                return null;
            }
            allOp = new LinkedList<EOperation>((Collection<EOperation>)((EClass)targetType).getEAllOperations());
            allOp.addAll(BuiltinMetaModel.findInternalOp((EClassifier)EcorePackage.eINSTANCE.getEJavaObject()));
        }
        return PolymorphicResolver.filterOperation(allOp, name, targetType, Arrays.asList(args));
    }

    public static EStructuralFeature getAttribute(EClassifier type, String name) {
        if (BuiltinMetaModel.hasBuiltinSupport(type)) {
            return BuiltinMetaModel.findInternalAttr(type, name);
        }
        if (type instanceof EClass) {
            return ((EClass)type).getEStructuralFeature(attrNameSubsts.containsKey(name) ? attrNameSubsts.get(name) : name);
        }
        if (type instanceof EEnum || type == EcorePackage.eINSTANCE.getEEnumLiteral() || type == EcorePackage.eINSTANCE.getEEnumerator()) {
            return EcorePackage.eINSTANCE.getEEnumLiteral().getEStructuralFeature(name);
        }
        return null;
    }

    public static Object getValue(EStructuralFeature prop, Object instance) {
        if (instance instanceof Enumerator) {
            if (prop == EcorePackage.eINSTANCE.getEEnumLiteral_Literal()) {
                return ((Enumerator)instance).getLiteral();
            }
            if (prop == EcorePackage.eINSTANCE.getENamedElement_Name()) {
                return ((Enumerator)instance).getName();
            }
            if (prop == EcorePackage.eINSTANCE.getEEnumLiteral_Value()) {
                return ((Enumerator)instance).getValue();
            }
        }
        if (instance instanceof EObject) {
            return ((EObject)instance).eGet(prop);
        }
        return "HeyHo!";
    }

    private static boolean hasBuiltinSupport(EClassifier type) {
        return internalOperationsMap.containsKey(type);
    }

    private static EStructuralFeature findInternalAttr(EClassifier type, String name) {
        if (type instanceof EClass) {
            return ((EClass)type).getEStructuralFeature(name);
        }
        if (type instanceof EDataType && type == EcorePackage.eINSTANCE.getEEnumerator()) {
            return EcorePackage.eINSTANCE.getEEnumLiteral().getEStructuralFeature(name);
        }
        return null;
    }

    private static List<EOperation> findInternalOp(EClassifier targetType) {
        List<InternalOperation> ops = internalOperationsMap.get(targetType);
        if (ops != null) {
            ArrayList<EOperation> rv = new ArrayList<EOperation>(ops.size());
            for (InternalOperation iop : ops) {
                rv.add(iop.metaOp);
            }
            return rv;
        }
        if (targetType.eClass() == EcorePackage.eINSTANCE.getEClass()) {
            return ((EClass)targetType).getEAllOperations();
        }
        return null;
    }

    public static EClassifier getTypedElementType(ETypedElement p) {
        if (p.isMany()) {
            return p.isOrdered() ? BuiltinMetaModel.getListType(p.getEType()) : (p.isUnique() ? BuiltinMetaModel.getSetType(p.getEType()) : BuiltinMetaModel.getCollectionType(p.getEType()));
        }
        return p.getEType();
    }

    public static void registerOperationImpl(EOperation metaOp, Method implementation) {
        assert (metaOp != null);
        assert (implementation != null);
        assert (Modifier.isStatic(implementation.getModifiers()));
        externalOpImplementations.put(metaOp, implementation);
    }

    public static boolean isAssignableFrom(EClassifier c1, EClassifier t) {
        if (t == null || c1 == null) {
            return false;
        }
        if (BuiltinMetaModel.primEquals(c1, t)) {
            return true;
        }
        if (t.equals(VOID)) {
            return true;
        }
        if (!(t instanceof EClass)) {
            if (c1 instanceof EEnum && t == EcorePackage.eINSTANCE.getEEnumerator()) {
                return true;
            }
            if (c1 instanceof EDataType && t instanceof EDataType) {
                return BuiltinMetaModel.isCompatibleDataTypes((EDataType)c1, (EDataType)t);
            }
            return false;
        }
        if (c1 instanceof EDataType) {
            Class c1Class = ((EDataType)c1).getInstanceClass();
            return c1Class.isAssignableFrom(t.getInstanceClass() == null ? Object.class : t.getInstanceClass());
        }
        if (BuiltinMetaModel.isParameterizedType(c1) && BuiltinMetaModel.isParameterizedType(t)) {
            return c1.eClass().isSuperTypeOf(t.eClass()) && BuiltinMetaModel.isAssignableFrom(BuiltinMetaModel.getInnerType(c1), BuiltinMetaModel.getInnerType(t));
        }
        for (EClass superType : ((EClass)t).getEAllSuperTypes()) {
            if (!BuiltinMetaModel.primEquals((EClassifier)superType, c1)) continue;
            return true;
        }
        return false;
    }

    private static boolean primEquals(EClassifier c1, EClassifier obj) {
        if (obj == null) {
            return false;
        }
        if (c1 == obj) {
            return true;
        }
        boolean namesEqual = c1.getName().equals(obj.getName());
        if (!namesEqual) {
            return false;
        }
        if (c1.getEPackage() == null) {
            return obj.getEPackage() == null;
        }
        if (obj.getEPackage() == null) {
            return false;
        }
        if (c1.getEPackage().getNsURI() == null) {
            return obj.getEPackage().getNsURI() == null;
        }
        return c1.getEPackage().getNsURI().equals(obj.getEPackage().getNsURI());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isCompatibleDataTypes(EDataType dt1, EDataType dt2) {
        try {
            Class dt1Class = dt1.getInstanceClass();
            Class dt2Class = dt2.getInstanceClass();
            if (dt1Class != null && dt2Class != null) {
                if (dt1Class == Object.class) {
                    return true;
                }
                if (dt1Class.isPrimitive() && !dt2Class.isPrimitive()) {
                    Field f = dt2Class.getField("TYPE");
                    return dt1Class.equals(f.get(null));
                }
                if (dt1Class.isPrimitive()) return dt1Class.isAssignableFrom(dt2Class);
                if (!dt2Class.isPrimitive()) return dt1Class.isAssignableFrom(dt2Class);
                Field f = dt1Class.getField("TYPE");
                return dt2Class.equals(f.get(null));
            }
            if (dt1Class == null) return false;
            if (dt2Class != null) return false;
            if (dt1Class != Object.class) return false;
            return true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    public static List<EStructuralFeature> getAllFeatures(EClassifier targetType) {
        if (targetType instanceof EClass) {
            return ((EClass)targetType).getEAllStructuralFeatures();
        }
        return Collections.emptyList();
    }

    public static List<EOperation> getAllOperation(EClassifier targetType) {
        if (BuiltinMetaModel.hasBuiltinSupport(targetType)) {
            return BuiltinMetaModel.findInternalOp(targetType);
        }
        if (targetType instanceof EClass) {
            return ((EClass)targetType).getEAllOperations();
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class InternalOperation<T> {
        private final EOperation metaOp;
        private static String INTERNAL_OP_ANNOTATION = "::internalop::";

        private InternalOperation(EOperation metaOp) {
            assert (metaOp != null);
            this.metaOp = metaOp;
            EAnnotation internalOpAnn = EcoreFactory.eINSTANCE.createEAnnotation();
            internalOpAnn.setSource(INTERNAL_OP_ANNOTATION);
            metaOp.getEAnnotations().add((Object)internalOpAnn);
        }

        public abstract Object evaluate(T var1, Object[] var2);

        static boolean isInternalOp(EOperation op) {
            return op.getEAnnotation(INTERNAL_OP_ANNOTATION) != null;
        }
    }

    public static class Operation {
        protected final EOperation metaOp;
        protected final Object[] args;
        protected final Object targetObject;

        private Operation(Object targetObject, Object[] args, EOperation metaOp) {
            this.targetObject = targetObject;
            this.args = args;
            this.metaOp = metaOp;
        }

        public Object evaluate() {
            try {
                Method m = externalOpImplementations.containsKey(this.metaOp) ? (Method)externalOpImplementations.get(this.metaOp) : this.targetObject.getClass().getMethod(this.metaOp.getName(), this.getParameterClasses());
                return m.invoke(this.targetObject, this.args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Class[] getParameterClasses() {
            EList emfParams = this.metaOp.getEParameters();
            Class[] paramClasses = new Class[emfParams.size()];
            int i = 0;
            int x = emfParams.size();
            while (i < x) {
                EParameter param = (EParameter)emfParams.get(i);
                paramClasses[i] = param.getEType().getInstanceClass();
                ++i;
            }
            return paramClasses;
        }

        /* synthetic */ Operation(Object object, Object[] objectArray, EOperation eOperation, Operation operation, Operation operation2) {
            this(object, objectArray, eOperation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OperationEx
    extends Operation {
        private final InternalOperation<Object> internalOp;

        private OperationEx(Object targetObject, Object[] args, InternalOperation<Object> internalOp) {
            super(targetObject, args, ((InternalOperation)internalOp).metaOp);
            this.internalOp = internalOp;
        }

        @Override
        public Object evaluate() {
            return this.internalOp.evaluate(this.targetObject, this.args);
        }
    }

    private static class OperationFactory {
        private OperationFactory() {
        }

        EOperation create(String name, Class returnType, Class ... params) {
            EClassifier[] paramsNew = new EClassifier[params.length];
            int i = 0;
            while (i < paramsNew.length) {
                paramsNew[i] = this.toEClassifier(params[i]);
                assert (params[i] != null);
                ++i;
            }
            EClassifier rt = this.toEClassifier(returnType);
            assert (rt != null) : "Unrecognized return type:" + returnType;
            return this.create(name, rt, paramsNew);
        }

        InternalOperation createReflective(Class targetType, String methodName, Class ... params) {
            try {
                final Method m = targetType.getMethod(methodName, params);
                assert (m != null);
                return new InternalOperation<Object>(this.create(methodName, m.getReturnType(), params)){

                    @Override
                    public Object evaluate(Object target, Object[] params) {
                        try {
                            Object rv = m.invoke(target, params);
                            if (rv != null && rv.getClass().isArray()) {
                                return new LinkedList<Object>(Arrays.asList((Object[])rv));
                            }
                            return rv;
                        }
                        catch (Exception e) {
                            Activator.logError(e);
                            return null;
                        }
                    }
                };
            }
            catch (NoSuchMethodException ex) {
                assert (false) : ex.getMessage();
                return null;
            }
        }

        private EClassifier toEClassifier(Class targetType) {
            if (targetType == Void.TYPE) {
                return VOID;
            }
            for (EClassifier c : EcorePackage.eINSTANCE.getEClassifiers()) {
                if (c.getInstanceClass() != targetType) continue;
                return c;
            }
            if (targetType.isArray()) {
                EClassifier t = this.toEClassifier(targetType.getComponentType());
                assert (t != null) : "Unrecognized array component type:" + targetType;
                return BuiltinMetaModel.getListType(t);
            }
            return null;
        }

        EOperation create(String name, EClassifier returnType, EClassifier ... params) {
            EOperation op = EcoreFactory.eINSTANCE.createEOperation();
            op.setName(name);
            op.setEType(returnType);
            EClassifier[] eClassifierArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier c = eClassifierArray[n2];
                EParameter p1 = EcoreFactory.eINSTANCE.createEParameter();
                p1.setName("arg" + c.getName());
                p1.setEType(c);
                op.getEParameters().add((Object)p1);
                ++n2;
            }
            return op;
        }
    }
}

