/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.build;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.WorkspaceModelRegistry;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.XpandMarkerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandBuilder
extends IncrementalProjectBuilder
implements RootManager.IRootChangeListener {
    private RootManager myRootManager;
    private WorkspaceModelRegistry modelRegistry;
    private boolean myRootsChanged = true;

    public static final String getBUILDER_ID() {
        return String.valueOf(Activator.getId()) + ".xpandBuilder";
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.myRootManager = Activator.getRootManager(this.getProject());
        this.myRootManager.addRootChangeListener(this);
        this.modelRegistry = new WorkspaceModelRegistry(this.getProject(), Activator.getWorkspaceMetamodelsResourceSet());
        Activator.registerModelSource(this.modelRegistry);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Building " + this.getProject().getName() + " xpand project", 11);
        Map<RootManager.RootDescription, Collection<IFile>> resourcesToBuild = this.collectResourcesToBuild(kind, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCanceled(monitor);
        this.doBuild(resourcesToBuild, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        this.myRootsChanged = false;
        Set<IProject> referencedProjects = this.myRootManager.getReferencedProjects();
        referencedProjects.remove(this.getProject());
        return referencedProjects.toArray(new IProject[referencedProjects.size()]);
    }

    private Map<RootManager.RootDescription, Collection<IFile>> collectResourcesToBuild(int kind, IProgressMonitor monitor) throws CoreException {
        if (kind == 6 || this.haveRootsChangedSinceLastBuild()) {
            return this.fullBuild(monitor);
        }
        Set<IProject> referencedProjects = this.myRootManager.getReferencedProjects();
        referencedProjects.remove(this.getProject());
        ArrayList<IResourceDelta> deltas = new ArrayList<IResourceDelta>(referencedProjects.size());
        IResourceDelta projectDelta = this.getDelta(this.getProject());
        if (projectDelta == null) {
            return this.fullBuild(monitor);
        }
        for (IProject next : referencedProjects) {
            IResourceDelta delta = this.getDelta(next);
            if (delta == null) {
                return this.fullBuild(monitor);
            }
            deltas.add(delta);
        }
        return this.incrementalBuild(projectDelta, deltas, monitor);
    }

    private void doBuild(Map<RootManager.RootDescription, Collection<IFile>> resourcesToBuild, IProgressMonitor monitor) {
        monitor.beginTask("Building " + this.getProject().getName() + " xpand project", resourcesToBuild.size());
        for (RootManager.RootDescription rootDescription : resourcesToBuild.keySet()) {
            WorkspaceResourceManager resourceManager = Activator.createWorkspaceResourceManager(this.getProject(), rootDescription);
            Scope scope = new Scope(resourceManager, null, null);
            this.checkCanceled(monitor);
            this.doBuid(resourceManager, scope, resourcesToBuild.get(rootDescription), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private void doBuid(WorkspaceResourceManager resourceManager, Scope scope, Collection<IFile> xpandFiles, IProgressMonitor monitor) {
        monitor.beginTask("Building " + this.getProject().getName() + " xpand project", xpandFiles.size() * 2);
        for (IFile xpandFile : xpandFiles) {
            monitor.setTaskName("Building " + xpandFile.getProjectRelativePath().toOSString());
            try {
                XpandResource xpandResource = resourceManager.loadXpandResource(xpandFile);
                this.checkCanceled(monitor);
                monitor.worked(1);
                ExecutionContextImpl context = new ExecutionContextImpl(scope);
                HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
                try {
                    xpandResource.analyze(context, issues);
                    this.checkCanceled(monitor);
                    monitor.worked(1);
                    XpandBuilder.updateMarkers(xpandFile, issues);
                }
                catch (RuntimeException ex) {
                    Activator.logError(ex);
                    XpandMarkerManager.addMarkers(xpandFile, new ParserException.ErrorLocationInfo(ex.toString()));
                }
            }
            catch (ParserException ex) {
                XpandBuilder.updateMarkers(xpandFile, ex.getParsingErrors());
            }
            catch (IOException ex) {
                XpandBuilder.updateMarkers(xpandFile, ex);
            }
            catch (CoreException ex) {
                XpandBuilder.updateMarkers(xpandFile, (Exception)((Object)ex));
            }
        }
    }

    @Override
    public void rootsChanged(RootManager rootManager) {
        this.myRootsChanged = true;
    }

    private boolean haveRootsChangedSinceLastBuild() {
        return this.myRootsChanged;
    }

    private RootManager.RootDescription getRootDescription(IFile file) {
        return this.myRootManager.getRootDescription(file);
    }

    protected Map<RootManager.RootDescription, Collection<IFile>> fullBuild(IProgressMonitor monitor) throws CoreException {
        Set<IProject> referencedProjects = this.myRootManager.getReferencedProjects();
        referencedProjects.add(this.getProject());
        XpandMarkerManager.deleteMarkers((IResource)this.getProject());
        monitor.beginTask(null, 1 + referencedProjects.size());
        HashMap<RootManager.RootDescription, Collection<IFile>> result = new HashMap<RootManager.RootDescription, Collection<IFile>>();
        try {
            for (IProject next : referencedProjects) {
                this.checkCanceled(monitor);
                next.accept((IResourceVisitor)new XpandResourceVisitor(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            this.checkCanceled(monitor);
            this.modelRegistry.build((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return result;
    }

    protected Map<RootManager.RootDescription, Collection<IFile>> incrementalBuild(IResourceDelta projectDelta, Collection<IResourceDelta> referencedProjectDeltas, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 2 + referencedProjectDeltas.size());
        HashMap<RootManager.RootDescription, Collection<IFile>> result = new HashMap<RootManager.RootDescription, Collection<IFile>>();
        try {
            for (IResourceDelta delta : referencedProjectDeltas) {
                this.checkCanceled(monitor);
                delta.accept((IResourceDeltaVisitor)new XpandResourceVisitor(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            this.checkCanceled(monitor);
            projectDelta.accept((IResourceDeltaVisitor)new XpandResourceVisitor(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            this.checkCanceled(monitor);
            this.modelRegistry.build(projectDelta, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static void updateMarkers(IFile resource, Set<AnalysationIssue> issues) {
        XpandMarkerManager.deleteMarkers((IResource)resource);
        XpandMarkerManager.addMarkers(resource, issues.toArray(new AnalysationIssue[issues.size()]));
    }

    private static void updateMarkers(IFile resource, Exception exception) {
        Activator.logError(exception);
        XpandMarkerManager.deleteMarkers((IResource)resource);
        XpandMarkerManager.addErrorMarker(resource, exception.getMessage(), -1, -1);
    }

    private static void updateMarkers(IFile resource, ParserException.ErrorLocationInfo[] parsingErrors) {
        XpandMarkerManager.deleteMarkers((IResource)resource);
        XpandMarkerManager.addMarkers(resource, parsingErrors);
    }

    private static boolean isXpand(IFile resource) {
        return "xpt".equals(resource.getFileExtension());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XpandResourceVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private final IProgressMonitor monitor;
        private Map<RootManager.RootDescription, Collection<IFile>> description2ResourcesMap;

        public XpandResourceVisitor(Map<RootManager.RootDescription, Collection<IFile>> description2ResourcesMap, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.description2ResourcesMap = description2ResourcesMap;
        }

        public boolean visit(IResource resource) {
            if (!resource.isDerived() && resource instanceof IFile && this.isFileOfInterest((IFile)resource)) {
                this.reloadResource((IFile)resource);
            }
            this.monitor.worked(1);
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.isDerived()) {
                return false;
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (!this.isFileOfInterest(file)) {
                    return false;
                }
                switch (delta.getKind()) {
                    case 1: {
                        this.reloadResource(file);
                        break;
                    }
                    case 2: {
                        this.handleRemovement(file);
                        break;
                    }
                    case 4: {
                        this.reloadResource(file);
                    }
                }
            } else if (resource instanceof IProject) {
                if (delta.getKind() == 2) {
                    System.err.println("Project removed:" + resource.getName());
                }
                if (delta.getKind() == 16384) {
                    System.err.println("Project open:" + ((IProject)resource).isOpen());
                }
            }
            this.monitor.worked(1);
            return true;
        }

        private void handleRemovement(IFile resource) {
            XpandMarkerManager.deleteMarkers((IResource)resource);
        }

        private void reloadResource(IFile resource) {
            assert (resource.exists());
            if (XpandBuilder.isXpand(resource)) {
                RootManager.RootDescription rootDescription = XpandBuilder.this.getRootDescription(resource);
                Collection<IFile> resources = this.description2ResourcesMap.get(rootDescription);
                if (resources == null) {
                    resources = new ArrayList<IFile>();
                    this.description2ResourcesMap.put(rootDescription, resources);
                }
                resources.add(resource);
            }
        }

        private boolean isFileOfInterest(IFile file) {
            if (!XpandBuilder.isXpand(file)) {
                return false;
            }
            return XpandBuilder.this.getRootDescription(file) != null;
        }
    }
}

