/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.builder;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.atl.adt.builder.AtlBuildVisitor;
import org.eclipse.m2m.atl.adt.builder.AtlBuilderMessages;
import org.eclipse.m2m.atl.adt.builder.AtlCleanVisitor;

public class AtlBuilder
extends IncrementalProjectBuilder {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    public static final String ATL_BUILDER_ID = "org.eclipse.m2m.atl.adt.builder.atlBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AtlBuilder.this.fullBuild(monitor);
            }
        };
        this.run(wr, monitor);
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) {
        try {
            IProject p = this.getProject();
            monitor.beginTask(AtlBuilderMessages.getString("AtlBuilder.COMPILETASK", new Object[]{p.getName()}), -1);
            p.accept((IResourceVisitor)new AtlBuildVisitor(monitor));
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    IProject p = AtlBuilder.this.getProject();
                    monitor.beginTask(AtlBuilderMessages.getString("AtlBuilder.CLEANTASK", new Object[]{p.getName()}), -1);
                    p.accept((IResourceVisitor)new AtlCleanVisitor(monitor));
                }
                catch (CoreException e) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        };
        this.run(wr, monitor);
    }

    protected void run(IWorkspaceRunnable wr, IProgressMonitor monitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(wr, monitor);
    }
}

