/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.env.IVirtualOperationTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ConstructorOperationAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.evaluator.DeferredAssignmentListener;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationMessages;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ImportToNonTransformCtxHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.IntermediatePropertyModelAdapter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.InternalEvaluator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelParameterHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.NumberConversions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.OCLAnnotationSupport;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtAssertionFailed;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtGenericEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtTransitionReachedException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ThisInstanceResolver;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TraceUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateCollectSelect;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateForExp;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateXCollect;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateXSelect;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ConstructorBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.EntryOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.impl.OperationBodyImpl;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.library.EObjectEStructuralFeaturePair;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.library.LateResolveInTask;
import org.eclipse.m2m.internal.qvt.oml.library.LateResolveTask;
import org.eclipse.m2m.internal.qvt.oml.library.QvtResolveUtil;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.DictionaryImpl;
import org.eclipse.m2m.internal.qvt.oml.stdlib.MutableListImpl;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AltExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssertExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BreakExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.CatchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ComputeExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ContinueExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ForExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeLoopExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.LogExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.RaiseExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ReturnExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SeverityKind;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SwitchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.TryExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnlinkExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnpackExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.WhileExp;
import org.eclipse.m2m.qvt.oml.util.EvaluationMonitor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorImpl;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.Visitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalEvaluationVisitorImpl
extends EvaluationVisitorImpl<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>
implements QvtOperationalEvaluationVisitor,
InternalEvaluator,
DeferredAssignmentListener {
    private static int tempCounter = 0;
    private QvtOperationalEvaluationEnv myEvalEnv;
    private OCLAnnotationSupport oclAnnotationSupport;

    public QvtOperationalEvaluationVisitorImpl(QvtOperationalEnv env, QvtOperationalEvaluationEnv evalEnv) {
        super((Environment)env, (EvaluationEnvironment)evalEnv, evalEnv.createExtentMap(null));
        this.myEvalEnv = evalEnv;
    }

    protected QvtOperationalEvaluationVisitorImpl(QvtOperationalEvaluationVisitorImpl parent, QvtOperationalEvaluationEnv nestedEvalEnv) {
        this(parent.getOperationalEnv(), nestedEvalEnv);
        this.oclAnnotationSupport = parent.getOCLAnnotationSupport();
    }

    protected QvtOperationalEvaluationVisitorImpl createNestedEvaluationVisitor(QvtOperationalEvaluationVisitorImpl parent, QvtOperationalEvaluationEnv nestedEvalEnv) {
        return new QvtOperationalEvaluationVisitorImpl(parent, nestedEvalEnv);
    }

    public Object visitDictLiteralExp(DictLiteralExp dictLiteralExp) {
        DictionaryImpl<Object, Object> result = new DictionaryImpl<Object, Object>();
        for (DictLiteralPart part : dictLiteralExp.getPart()) {
            Object key = part.getKey().accept((Visitor)this.getVisitor());
            Object value = part.getValue().accept((Visitor)this.getVisitor());
            if (key == this.getOclInvalid() || value == this.getOclInvalid()) continue;
            result.put(key, value);
        }
        return result;
    }

    public Object visitVariableExp(VariableExp<EClassifier, EParameter> v) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        org.eclipse.ocl.expressions.Variable vd = v.getReferredVariable();
        String varName = vd.getName();
        Object value = evalEnv.getValueOf(varName);
        if ("this".equals(varName)) {
            Module referredThisModule;
            ModuleInstance thisObj;
            EClassifier varType = (EClassifier)v.getType();
            if (varType instanceof Module && (thisObj = evalEnv.getThisOfType(referredThisModule = (Module)varType)) != null) {
                return thisObj;
            }
        } else if (vd instanceof ModelParameter) {
            OperationalTransformation transformation = (OperationalTransformation)vd.eContainer();
            TransformationInstance transformationInstance = (TransformationInstance)evalEnv.getThisOfType(transformation);
            assert (transformationInstance != null);
            ModelInstance model = transformationInstance.getModel((ModelParameter)vd);
            assert (model != null);
            return model;
        }
        return value;
    }

    public static QvtOperationalEvaluationVisitorImpl createNonTransformationExecutionContextVisitor(Context context, ImportToNonTransformCtxHelper importProvider) {
        QvtOperationalEnv env = QvtOperationalEnvFactory.INSTANCE.createEnvironment();
        QvtOperationalEvaluationEnv evalEnv = QvtOperationalEnvFactory.INSTANCE.createEvaluationEnvironment(context, null);
        return QvtOperationalEvaluationVisitorImpl.createNonTransformationExecutionContextVisitor(env, evalEnv, importProvider);
    }

    public static QvtOperationalEvaluationVisitorImpl createNonTransformationExecutionContextVisitor(QvtOperationalEnv env, QvtOperationalEvaluationEnv evalEnv, ImportToNonTransformCtxHelper importsProvider) {
        QvtOperationalEvaluationVisitorImpl visitor = new QvtOperationalEvaluationVisitorImpl(env, evalEnv);
        InternalEvaluationEnv internalEvalEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        ThisInstanceResolver importsByAccess = importsProvider.createImportedInstanceResolver();
        internalEvalEnv.setThisResolver(importsByAccess);
        for (ModuleInstance nextModuleToInit : importsProvider.getModuleInstances(false)) {
            ModuleInstance.Internal internalModule = nextModuleToInit.getAdapter(ModuleInstance.Internal.class);
            if (internalModule.isInitialized()) continue;
            visitor.initModule(nextModuleToInit, null);
        }
        return visitor;
    }

    public static QvtOperationalEvaluationVisitor createVisitor(QvtOperationalEnv env, QvtOperationalEvaluationEnv evalEnv) {
        return new QvtOperationalEvaluationVisitorImpl(env, evalEnv).createInterruptibleVisitor();
    }

    public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> getEvaluationEnvironment() {
        return this.myEvalEnv;
    }

    @Override
    public void setOperationalEvaluationEnv(QvtOperationalEvaluationEnv evalEnv) {
        this.myEvalEnv = evalEnv;
    }

    protected void pushedStack(QvtOperationalEvaluationEnv env) {
    }

    protected void poppedStack() {
    }

    @Override
    public IContext getContext() {
        return this.getOperationalEvaluationEnv().getContext();
    }

    @Override
    public void notifyAfterDeferredAssign(AssignExp assignExp, Object leftValue) {
    }

    public Object visitIfExp(IfExp<EClassifier> ie) {
        Boolean condVal;
        org.eclipse.ocl.expressions.OCLExpression condition = ie.getCondition();
        Object condRawVal = condition.accept((Visitor)this.getVisitor());
        Boolean bl = condVal = condRawVal != this.getOclInvalid() ? (Boolean)condRawVal : Boolean.FALSE;
        if (condVal != null && condVal.booleanValue()) {
            return ie.getThenExpression().accept((Visitor)this.getVisitor());
        }
        if (ie.getElseExpression() != null) {
            return ie.getElseExpression().accept((Visitor)this.getVisitor());
        }
        return null;
    }

    public Object visitExpression(org.eclipse.ocl.expressions.OCLExpression<EClassifier> expression) {
        return expression.accept((Visitor)this.getVisitor());
    }

    public Object visitAssignExp(AssignExp assignExp) {
        Object ownerObj;
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        InternalEvaluationEnv internEnv = env.getAdapter(InternalEvaluationEnv.class);
        boolean isDeferred = false;
        OCLExpression lValue = assignExp.getLeft();
        if (assignExp.getValue().size() == 1 && (isDeferred = QvtResolveUtil.hasDeferredRightSideValue(assignExp)) && (ownerObj = this.getAssignExpLValueOwner((org.eclipse.ocl.expressions.OCLExpression<EClassifier>)lValue)) instanceof EObject) {
            PropertyCallExp lvalueExp = (PropertyCallExp)assignExp.getLeft();
            Iterator referredProperty = (EStructuralFeature)lvalueExp.getReferredProperty();
            internEnv.setLastAssignmentLvalueEval(new EObjectEStructuralFeaturePair((EObject)ownerObj, (EStructuralFeature)referredProperty));
        }
        Object exprValue = null;
        for (org.eclipse.ocl.expressions.OCLExpression exp : assignExp.getValue()) {
            exprValue = exp.accept((Visitor)this.getVisitor());
        }
        if (isDeferred) {
            return null;
        }
        if (lValue instanceof VariableExp) {
            VariableExp varExp = (VariableExp)lValue;
            org.eclipse.ocl.expressions.Variable referredVariable = varExp.getReferredVariable();
            if (referredVariable != null) {
                String varName = referredVariable.getName();
                Object oldValue = this.getRuntimeValue(varName);
                EClassifier variableType = (EClassifier)lValue.getType();
                if (variableType instanceof CollectionType && oldValue instanceof Collection) {
                    Collection oldOclCollection = (Collection)oldValue;
                    Collection leftOclCollection = assignExp.isIsReset() ? EvaluationUtil.createNewCollectionOfSameKind(oldOclCollection) : oldOclCollection;
                    CollectionKind leftCollectionKind = QvtOperationalEvaluationVisitorImpl.getCollectionKind(leftOclCollection);
                    if (exprValue instanceof Collection) {
                        if (leftCollectionKind == CollectionKind.ORDERED_SET_LITERAL) {
                            LinkedHashSet values = new LinkedHashSet();
                            values.addAll(leftOclCollection);
                            values.addAll((Collection)exprValue);
                            leftOclCollection = CollectionUtil.createNewCollection((CollectionKind)((CollectionType)variableType).getKind(), values);
                        } else if (leftCollectionKind != null) {
                            leftOclCollection = CollectionUtil.union((Collection)leftOclCollection, (Collection)((Collection)exprValue));
                        } else {
                            leftOclCollection.addAll((Collection)exprValue);
                        }
                    } else if (leftCollectionKind == CollectionKind.ORDERED_SET_LITERAL || leftCollectionKind == CollectionKind.SEQUENCE_LITERAL) {
                        leftOclCollection = CollectionUtil.append(leftOclCollection, (Object)exprValue);
                    } else if (leftCollectionKind != null) {
                        leftOclCollection = CollectionUtil.including((Collection)leftOclCollection, (Object)exprValue);
                    } else {
                        leftOclCollection.add(exprValue);
                    }
                    this.replaceInEnv(varName, leftOclCollection, variableType);
                } else {
                    this.replaceInEnv(varName, exprValue, variableType);
                }
            }
        } else if (lValue instanceof PropertyCallExp) {
            Object ownerObj2 = this.getAssignExpLValueOwner((org.eclipse.ocl.expressions.OCLExpression<EClassifier>)lValue);
            if (ownerObj2 instanceof EObject) {
                EObject oldIP = this.setCurrentEnvInstructionPointer((EObject)assignExp);
                env.callSetter((EObject)ownerObj2, (EStructuralFeature)((PropertyCallExp)lValue).getReferredProperty(), exprValue, this.isUndefined(exprValue), assignExp.isIsReset());
                this.setCurrentEnvInstructionPointer(oldIP);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported LValue type: " + (lValue == null ? null : (EClassifier)lValue.getType()));
        }
        return exprValue;
    }

    private Object getAssignExpLValueOwner(org.eclipse.ocl.expressions.OCLExpression<EClassifier> lValue) {
        if (lValue instanceof PropertyCallExp) {
            PropertyCallExp propertyCallExp = (PropertyCallExp)lValue;
            org.eclipse.ocl.expressions.OCLExpression sourceExp = propertyCallExp.getSource();
            Object owner = sourceExp.accept((Visitor)this.getVisitor());
            return owner;
        }
        return null;
    }

    private Object visitConfigProperty(EStructuralFeature configProperty) {
        this.setCurrentEnvInstructionPointer((EObject)configProperty);
        IContext context = this.getOperationalEvaluationEnv().getContext();
        Object rawValue = context.getConfigProperty(configProperty.getName());
        EClassifier propertyType = configProperty.getEType();
        Object value = rawValue;
        if (rawValue instanceof String && propertyType != this.getEnvironment().getOCLStandardLibrary().getString()) {
            value = this.createFromString(propertyType, (String)rawValue);
        }
        if (value == this.getOclInvalid()) {
            this.throwQVTException(new QvtRuntimeException(NLS.bind((String)EvaluationMessages.QvtOperationalEvaluationVisitorImpl_invalidConfigPropertyValue, (Object)configProperty.getName(), (Object)rawValue)));
        }
        return value;
    }

    @Override
    public Object visitEntryOperation(EntryOperation entryOperation) {
        this.visitImperativeOperation(entryOperation);
        return new OperationCallResult(this.visitOperationBody(entryOperation.getBody()), this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitHelper(Helper helper) {
        this.visitImperativeOperation(helper);
        return new OperationCallResult(this.visitOperationBody(helper.getBody()), this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitImperativeOperation(ImperativeOperation imperativeOperation) {
        if (imperativeOperation.isIsBlackbox()) {
            throw new IllegalArgumentException("Blackbox rules are not supported: " + imperativeOperation.getName());
        }
        List<Object> args = this.getOperationalEvaluationEnv().getOperationArgs();
        Iterator<Object> argIt = args.iterator();
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        for (EParameter nextParam : imperativeOperation.getEParameters()) {
            if (!argIt.hasNext()) {
                throw new IllegalArgumentException("arguments mismatch: got" + args + ", expected " + imperativeOperation.getEParameters());
            }
            VarParameter param = (VarParameter)nextParam;
            Object arg = argIt.next();
            this.addToEnv(param.getName(), arg, param.getEType());
        }
        EClassifier contextType = QvtOperationalParserUtil.getContextualType(imperativeOperation);
        if (contextType != null) {
            this.addToEnv("self", env.getOperationSelf(), contextType);
        }
        this.pushedStack(this.getOperationalEvaluationEnv());
        return null;
    }

    @Override
    public Object visitLibrary(Library library) {
        return null;
    }

    public Object visitLocalProperty(EStructuralFeature property) {
        org.eclipse.ocl.expressions.OCLExpression<EClassifier> initExp = QvtOperationalParserUtil.getInitExpression(property);
        if (initExp != null) {
            return initExp.accept((Visitor)this.getVisitor());
        }
        return null;
    }

    @Override
    public Object visitContextualProperty(ContextualProperty contextualProperty) {
        if (contextualProperty.getInitExpression() != null) {
            return contextualProperty.getInitExpression().accept((Visitor)this.getVisitor());
        }
        return null;
    }

    protected boolean isWhenPreconditionSatisfied(MappingOperation mappingOperation) {
        if (mappingOperation.getWhen().isEmpty()) {
            return true;
        }
        for (org.eclipse.ocl.expressions.OCLExpression nextCond : mappingOperation.getWhen()) {
            if (Boolean.TRUE.equals(nextCond.accept((Visitor)this.getVisitor()))) continue;
            return false;
        }
        return true;
    }

    private void setupInitialResultVariables(MappingBody mappingBody) {
        ImperativeOperation operation = mappingBody.getOperation();
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        for (VarParameter resultParam : operation.getResult()) {
            if (evalEnv.getValueOf(resultParam.getName()) != null) continue;
            this.replaceInEnv(resultParam.getName(), null, resultParam.getEType());
        }
        if (operation.getResult().size() > 1 && evalEnv.getValueOf("result") == null) {
            this.replaceInEnv("result", null, operation.getEType());
        }
    }

    @Override
    public Object visitMappingBody(MappingBody mappingBody) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        this.setupInitialResultVariables(mappingBody);
        for (org.eclipse.ocl.expressions.OCLExpression initExp : mappingBody.getInitSection()) {
            initExp.accept((Visitor)this.getVisitor());
        }
        Object result = this.createOrGetResult((MappingOperation)mappingBody.getOperation());
        MappingOperation currentMappingCalled = (MappingOperation)evalEnv.getOperation();
        if (!currentMappingCalled.getInherited().isEmpty()) {
            for (MappingOperation extendedMapping : currentMappingCalled.getInherited()) {
                this.executeImperativeOperation(extendedMapping, evalEnv.getOperationSelf(), evalEnv.getOperationArgs(), true);
            }
        }
        this.visitOperationBody(mappingBody);
        for (org.eclipse.ocl.expressions.OCLExpression endExp : mappingBody.getEndSection()) {
            endExp.accept((Visitor)this.getVisitor());
        }
        if (!currentMappingCalled.getMerged().isEmpty()) {
            for (MappingOperation extendedMapping : currentMappingCalled.getMerged()) {
                this.executeImperativeOperation(extendedMapping, evalEnv.getOperationSelf(), evalEnv.getOperationArgs(), true);
            }
        }
        return result;
    }

    @Override
    public Object visitMappingCallExp(MappingCallExp mappingCallExp) {
        return this.visitOperationCallExp((OperationCallExp<EClassifier, EOperation>)mappingCallExp);
    }

    public Object visitOperationCallExp(OperationCallExp<EClassifier, EOperation> operationCallExp) {
        EObject oldIP = this.setCurrentEnvInstructionPointer((EObject)operationCallExp);
        Object result = this.doVisitOperationCallExp(operationCallExp);
        this.setCurrentEnvInstructionPointer(oldIP);
        return result;
    }

    protected Object doVisitOperationCallExp(OperationCallExp<EClassifier, EOperation> operationCallExp) {
        EOperation referredOperation = (EOperation)operationCallExp.getReferredOperation();
        boolean isImperative = QvtOperationalUtil.isImperativeOperation(referredOperation);
        if (isImperative && !CallHandler.Access.hasHandler(referredOperation)) {
            EOperation actualOperation;
            Object source = operationCallExp.getSource().accept((Visitor)this.getVisitor());
            List<Object> args = this.makeArgs(operationCallExp);
            if (this.isUndefined(source)) {
                return this.getOclInvalid();
            }
            ImperativeOperation method = null;
            if (QvtOperationalParserUtil.isOverloadableMapping(referredOperation, this.getOperationalEnv()) && (actualOperation = this.findOperationByActualSourceType(source, referredOperation)) instanceof ImperativeOperation) {
                method = (ImperativeOperation)actualOperation;
            }
            if (method == null && referredOperation instanceof ImperativeOperation) {
                method = (ImperativeOperation)referredOperation;
            }
            if (method != null) {
                ImperativeOperation overridingOper;
                ImperativeCallExp imperativeCall;
                if (operationCallExp instanceof ImperativeCallExp && (imperativeCall = (ImperativeCallExp)operationCallExp).isIsVirtual() && (overridingOper = EvaluationUtil.getOverridingOperation(this.getOperationalEvaluationEnv(), method)) != null) {
                    method = overridingOper;
                }
                return this.executeImperativeOperation((ImperativeOperation)method, (Object)source, args, (boolean)false).myResult;
            }
        }
        Object result = null;
        try {
            result = super.visitOperationCallExp(operationCallExp);
        }
        catch (QvtRuntimeException e) {
            throw e;
        }
        catch (RuntimeException ex) {
            if (this.canBePropagated(ex)) {
                throw ex;
            }
            Logger.getLogger().log(Logger.WARNING, "QvtEvaluator: failed to evaluate oclOperationCall", ex);
            result = this.getOclInvalid();
        }
        if (result == this.getOclInvalid() && (e = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class).getException()) != null) {
            throw e;
        }
        return result;
    }

    private EOperation findOperationByActualSourceType(Object source, EOperation referredOperation) {
        EClassifier sourceEClass;
        EOperation actualOperation = referredOperation;
        IVirtualOperationTable vTable = this.getVirtualTable(referredOperation);
        if (vTable != null && (sourceEClass = (EClassifier)this.getEvaluationEnvironment().getType(source)) != null) {
            InternalEvaluationEnv internEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
            EOperation oper = vTable.lookupActualOperation(sourceEClass, this.getEnvironment(), internEnv);
            if (oper != null) {
                actualOperation = oper;
            }
        }
        return actualOperation;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp<EClassifier, EEnumLiteral> el) {
        return ((EEnumLiteral)el.getReferredEnumLiteral()).getInstance();
    }

    @Override
    public Object visitMappingOperation(MappingOperation mappingOperation) {
        this.visitImperativeOperation(mappingOperation);
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        if (!this.isWhenPreconditionSatisfied(mappingOperation)) {
            return new MappingCallResult(null, evalEnv, 2);
        }
        if (!mappingOperation.getDisjunct().isEmpty()) {
            return this.dispatchDisjuctMapping(mappingOperation);
        }
        TraceRecord traceRecord = TraceUtil.getTraceRecord(evalEnv, mappingOperation);
        if (traceRecord != null) {
            return new MappingCallResult(TraceUtil.fetchResultFromTrace(evalEnv, traceRecord), evalEnv, 4);
        }
        return new MappingCallResult(((OperationBodyImpl)mappingOperation.getBody()).accept(this.getVisitor()), evalEnv, 0);
    }

    @Override
    public Object execute(OperationalTransformation transformation) throws QvtRuntimeException {
        try {
            Object object = this.doVisitTransformation(transformation);
            return object;
        }
        finally {
            IntermediatePropertyModelAdapter.cleanup(transformation);
        }
    }

    @Override
    public Object visitModule(Module module) {
        if (!(module instanceof OperationalTransformation)) {
            throw new IllegalArgumentException(NLS.bind((String)EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ModuleNotExecutable, (Object)module.getName()));
        }
        try {
            Object object = this.doVisitTransformation((OperationalTransformation)module);
            return object;
        }
        catch (QvtRuntimeException e) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            e.printQvtStackTrace(printWriter);
            this.getContext().getLog().log(strWriter.getBuffer().toString());
            throw e;
        }
        finally {
            IntermediatePropertyModelAdapter.cleanup(module);
        }
    }

    public Object executeHelperOperation(Helper method, Object self, List<Object> args) {
        Helper actualHelper = method;
        EOperation actualOperation = this.findOperationByActualSourceType(self, method);
        if (!(actualOperation instanceof Helper)) {
            return this.getEvaluationEnvironment().callOperation((Object)method, -1, self, args.toArray(new Object[args.size()]));
        }
        actualHelper = (Helper)actualOperation;
        OperationCallResult result = this.executeImperativeOperation(actualHelper, self, args, false);
        return result.myResult;
    }

    public Object visitInstantiationExp(InstantiationExp objectExp) {
        EClass _class = objectExp.getInstantiatedClass();
        if (_class instanceof OperationalTransformation) {
            EList formalArguments = objectExp.getArgument();
            ArrayList<ModelInstance> actualArguments = new ArrayList<ModelInstance>(formalArguments.size());
            for (org.eclipse.ocl.expressions.OCLExpression nextArg : formalArguments) {
                Object argVal = nextArg.accept((Visitor)this.getVisitor());
                if (!(argVal instanceof ModelInstance)) {
                    this.throwQVTException(new QvtRuntimeException(EvaluationMessages.QvtOperationalEvaluationVisitorImpl_UndefModelParamInTransf));
                }
                ModelInstance modelInstance = (ModelInstance)argVal;
                actualArguments.add(modelInstance);
            }
            OperationalTransformation targetTransf = (OperationalTransformation)_class;
            QvtOperationalEvaluationEnv currentEnv = this.getOperationalEvaluationEnv();
            Context nestedContext = EvaluationUtil.createAggregatedContext(currentEnv);
            QvtOperationalEnvFactory envFactory = this.getOperationalEnv().getFactory();
            QvtOperationalEvaluationEnv nestedEvalEnv = envFactory.createEvaluationEnvironment(nestedContext, null);
            nestedEvalEnv.getOperationArgs().addAll(actualArguments);
            InternalEvaluator nestedVisitor = this.createNestedEvaluationVisitor(this, nestedEvalEnv).createInterruptibleVisitor();
            try {
                this.setOperationalEvaluationEnv(nestedEvalEnv);
                ModuleInstance moduleInstance = nestedVisitor.callTransformationImplicitConstructor(targetTransf, actualArguments);
                moduleInstance.getAdapter(TransformationInstance.InternalTransformation.class).setEntryOperationHandler(QvtOperationalEvaluationVisitorImpl.createEntryOperationHandler(nestedVisitor));
                ModuleInstance moduleInstance2 = moduleInstance;
                return moduleInstance2;
            }
            finally {
                this.setOperationalEvaluationEnv(currentEnv);
            }
        }
        this.setCurrentEnvInstructionPointer((EObject)objectExp);
        Object owner = this.createInstance((EClassifier)objectExp.getType(), (ModelParameter)objectExp.getExtent());
        Adapter adapter = EcoreUtil.getAdapter((List)objectExp.eAdapters(), ConstructorOperationAdapter.class);
        if (adapter != null) {
            Constructor constructorOp = ((ConstructorOperationAdapter)adapter).getReferredConstructor();
            EList formalArguments = objectExp.getArgument();
            ArrayList<Object> actualArguments = new ArrayList<Object>(formalArguments.size());
            for (org.eclipse.ocl.expressions.OCLExpression nextArg : formalArguments) {
                Object argVal = nextArg.accept((Visitor)this.getVisitor());
                actualArguments.add(argVal);
            }
            this.executeImperativeOperation(constructorOp, owner, actualArguments, false);
        } else if (!objectExp.getArgument().isEmpty()) {
            this.throwQVTException(new QvtRuntimeException("Undefined constructor is called"));
        }
        return owner;
    }

    @Override
    public TransformationInstance callTransformationImplicitConstructor(OperationalTransformation transformation, List<ModelInstance> transfArgs) {
        ModuleInstanceFactory eFactory = (ModuleInstanceFactory)transformation.getEFactoryInstance();
        assert (eFactory != null) : "Module class must have factory";
        TransformationInstance instance = (TransformationInstance)eFactory.create(transformation);
        this.getEvaluationEnvironment().add("this", (Object)instance);
        ModelParameterHelper modelParameters = new ModelParameterHelper(transformation, transfArgs);
        this.initModule(instance, modelParameters);
        this.setCurrentEnvInstructionPointer((EObject)transformation);
        return instance;
    }

    private Object doVisitTransformation(OperationalTransformation transformation) {
        ImperativeOperation entryPoint = QvtOperationalParserUtil.getMainOperation(transformation);
        if (entryPoint == null) {
            throw new IllegalArgumentException(NLS.bind((String)EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ModuleNotExecutable, (Object)transformation.getName()));
        }
        QvtOperationalEvaluationEnv evaluationEnv = this.getOperationalEvaluationEnv();
        List<ModelInstance> modelArgs = EvaluationUtil.getTransfromationModelArguments(evaluationEnv, transformation);
        ModuleInstance moduleInstance = this.callTransformationImplicitConstructor(transformation, (List)modelArgs);
        CallHandler entryOperationHandler = QvtOperationalEvaluationVisitorImpl.createEntryOperationHandler(this);
        TransformationInstance.InternalTransformation internTransf = moduleInstance.getAdapter(TransformationInstance.InternalTransformation.class);
        internTransf.setEntryOperationHandler(entryOperationHandler);
        OperationCallResult callResult = (OperationCallResult)entryOperationHandler.invoke(null, moduleInstance, this.makeEntryOperationArgs(entryPoint, transformation).toArray(), evaluationEnv);
        QvtEvaluationResult evalResult = EvaluationUtil.createEvaluationResult(callResult.myEvalEnv);
        if (evalResult.getModelExtents().isEmpty()) {
            if (callResult.myResult instanceof EObject) {
                ModelParameterExtent modelParameter = new ModelParameterExtent(Collections.singletonList((EObject)callResult.myResult), null, null);
                evalResult.getModelExtents().add(modelParameter.getContents());
            } else {
                return callResult.myResult;
            }
        }
        return evalResult;
    }

    private static CallHandler createEntryOperationHandler(final InternalEvaluator evaluator) {
        return new CallHandler(){

            public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                TransformationInstance transformation = (TransformationInstance)source;
                try {
                    OperationCallResult operationCallResult = evaluator.runMainEntry(transformation.getTransformation(), Arrays.asList(args));
                    return operationCallResult;
                }
                finally {
                    transformation.getAdapter(TransformationInstance.InternalTransformation.class).dispose();
                }
            }
        };
    }

    protected void processDeferredTasks() {
        InternalEvaluationEnv internalEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        internalEvalEnv.processDeferredTasks();
    }

    @Override
    public Object visitModuleImport(ModuleImport moduleImport) {
        return null;
    }

    @Override
    public Object visitObjectExp(ObjectExp objectExp) {
        InternalEvaluationEnv internEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        internEnv.setCurrentIP((EObject)objectExp);
        Object owner = this.getOutOwner(objectExp);
        if (objectExp.getBody() != null) {
            EList<OCLExpression> contents = objectExp.getBody().getContent();
            for (org.eclipse.ocl.expressions.OCLExpression exp : contents) {
                exp.accept((Visitor)this.getVisitor());
            }
        }
        if (this.getOperationalEnv().isTemporaryElement(objectExp.getName())) {
            this.getOperationalEvaluationEnv().remove(objectExp.getName());
        }
        return owner;
    }

    public Object visitReturnExp(ReturnExp returnExp) {
        EList<OCLExpression> content;
        OperationBody body;
        Object value = null;
        OCLExpression valueExp = returnExp.getValue();
        if (valueExp != null) {
            value = valueExp.accept((Visitor)this.getVisitor());
        }
        if ((body = QvtOperationalParserUtil.findParentElement(returnExp, OperationBody.class)) != null && !(content = body.getContent()).isEmpty() && content.get(content.size() - 1) == returnExp) {
            return value;
        }
        throw new ReturnExpEvent(value, this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitOperationBody(OperationBody operationBody) {
        Object result = null;
        for (org.eclipse.ocl.expressions.OCLExpression exp : operationBody.getContent()) {
            result = exp.accept((Visitor)this.getVisitor());
        }
        ImperativeOperation operation = operationBody.getOperation();
        if (operation.getResult().size() > 1) {
            return this.createTupleResult(operation);
        }
        return result;
    }

    @Override
    public Object visitVarParameter(VarParameter varParameter) {
        return null;
    }

    public Object visitVariableInitExp(VariableInitExp variableInitExp) {
        Variable referredVariable = variableInitExp.getReferredVariable();
        org.eclipse.ocl.expressions.OCLExpression initExpression = referredVariable.getInitExpression();
        Collection<Object> value = null;
        if (initExpression != null) {
            value = initExpression.accept((Visitor)this.getVisitor());
        } else {
            CollectionType collectionType;
            CollectionKind kind;
            OCLStandardLibrary oclstdlib = this.getEnvironment().getOCLStandardLibrary();
            EClassifier varDeclType = (EClassifier)referredVariable.getType();
            if (varDeclType == oclstdlib.getString()) {
                value = "";
            } else if (varDeclType == oclstdlib.getBoolean()) {
                value = Boolean.FALSE;
            } else if (varDeclType == oclstdlib.getInteger()) {
                value = 0;
            } else if (varDeclType == oclstdlib.getReal()) {
                value = 0.0;
            } else if (varDeclType == oclstdlib.getUnlimitedNatural()) {
                value = 0;
            } else if (varDeclType instanceof ListType) {
                value = Utils.createList();
            } else if (varDeclType instanceof DictionaryType) {
                value = Utils.createDictionary();
            } else if (varDeclType instanceof CollectionType && (kind = (collectionType = (CollectionType)varDeclType).getKind()) != null && kind != CollectionKind.COLLECTION_LITERAL) {
                value = CollectionUtil.createNewCollection((CollectionKind)kind);
            }
        }
        this.replaceInEnv(referredVariable.getName(), value, (EClassifier)variableInitExp.getType());
        return variableInitExp.isWithResult() ? value : null;
    }

    public Object visitBlockExp(BlockExp blockExp) {
        LinkedList<String> scopeVars = null;
        boolean isInImperativeOper = blockExp.eContainer() instanceof ImperativeOperation;
        for (org.eclipse.ocl.expressions.OCLExpression exp : blockExp.getBody()) {
            if (exp instanceof VariableInitExp && !isInImperativeOper) {
                if (scopeVars == null) {
                    scopeVars = new LinkedList<String>();
                }
                VariableInitExp varInitExp = (VariableInitExp)exp;
                scopeVars.add(varInitExp.getName());
            }
            exp.accept((Visitor)this.getVisitor());
        }
        if (scopeVars != null) {
            EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> evalEnv = this.getEvaluationEnvironment();
            for (String varName : scopeVars) {
                evalEnv.remove(varName);
            }
        }
        return null;
    }

    public Object visitComputeExp(ComputeExp computeExp) {
        Variable returnedElement = computeExp.getReturnedElement();
        Object initExpressionValue = null;
        org.eclipse.ocl.expressions.OCLExpression initExpression = returnedElement.getInitExpression();
        if (initExpression != null) {
            initExpressionValue = initExpression.accept((Visitor)this.getVisitor());
        }
        this.replaceInEnv(returnedElement.getName(), initExpressionValue, (EClassifier)returnedElement.getType());
        computeExp.getBody().accept((Visitor)this.getVisitor());
        return this.getEvaluationEnvironment().remove(returnedElement.getName());
    }

    public Object visitWhileExp(WhileExp whileExp) {
        Object condition;
        while (Boolean.TRUE.equals(condition = whileExp.getCondition().accept((Visitor)this.getVisitor()))) {
            try {
                whileExp.getBody().accept((Visitor)this.getVisitor());
            }
            catch (QvtTransitionReachedException ex) {
                if (ex.getReason() == 1) break;
                if (ex.getReason() != 2) continue;
            }
        }
        return null;
    }

    public Object visitAltExp(AltExp switchAltExp) {
        SwitchAltExpResult result = new SwitchAltExpResult();
        result.myCondition = switchAltExp.getCondition().accept((Visitor)this.getVisitor());
        if (Boolean.TRUE.equals(result.myCondition)) {
            result.myResult = switchAltExp.getBody().accept((Visitor)this.getVisitor());
        }
        return result;
    }

    public Object visitSwitchExp(SwitchExp switchExp) {
        for (AltExp altExp : switchExp.getAlternativePart()) {
            Object altResult = altExp.accept((Visitor)this.getVisitor());
            if (altResult instanceof SwitchAltExpResult) {
                if (!Boolean.TRUE.equals(((SwitchAltExpResult)altResult).myCondition)) continue;
                return ((SwitchAltExpResult)altResult).myResult;
            }
            if (!Boolean.TRUE.equals(altResult)) continue;
            return null;
        }
        OCLExpression elsePart = switchExp.getElsePart();
        if (elsePart != null) {
            return elsePart.accept((Visitor)this.getVisitor());
        }
        return null;
    }

    @Override
    public Object visitResolveExp(ResolveExp resolveExp) {
        InternalEvaluationEnv internalEvalEnv;
        if (resolveExp.isIsDeferred() && !(internalEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class)).isDeferredExecution()) {
            LateResolveTask lateResolveTask = new LateResolveTask(resolveExp, internalEvalEnv.getLastAssignmentLvalueEval(), this.getQVTVisitor(), this.getOperationalEvaluationEnv(), this);
            internalEvalEnv.addDeferredTask(lateResolveTask);
            return null;
        }
        return QvtResolveUtil.resolveNow(resolveExp, this, this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitResolveInExp(ResolveInExp resolveInExp) {
        InternalEvaluationEnv internalEvalEnv;
        if (resolveInExp.isIsDeferred() && !(internalEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class)).isDeferredExecution()) {
            LateResolveInTask lateResolveInTask = new LateResolveInTask(resolveInExp, internalEvalEnv.getLastAssignmentLvalueEval(), this.getQVTVisitor(), this.getOperationalEvaluationEnv(), (DeferredAssignmentListener)this);
            internalEvalEnv.addDeferredTask(lateResolveInTask);
            return null;
        }
        return QvtResolveUtil.resolveInNow(resolveInExp, this, this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitModelType(ModelType modelType) {
        return null;
    }

    public Object visitLogExp(LogExp logExp) {
        this.doVisitLogExp(logExp, this.getContext().getLog(), null);
        return null;
    }

    private boolean doVisitLogExp(LogExp logExp, Log logger, String messagePrefix) {
        Object message;
        if (logExp.getCondition() != null && !Boolean.TRUE.equals(logExp.getCondition().accept((Visitor)this.getVisitor()))) {
            return false;
        }
        InternalEvaluationEnv internalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        Object invalid = internalEnv.getInvalid();
        String invalidRepr = "<Invalid>";
        Integer level = null;
        EList args = logExp.getArgument();
        if (args.size() > 2) {
            Object levelObj = ((org.eclipse.ocl.expressions.OCLExpression)args.get(2)).accept((Visitor)this.getVisitor());
            level = NumberConversions.strictConvertNumber(levelObj, Integer.class);
        }
        if ((message = ((org.eclipse.ocl.expressions.OCLExpression)args.get(0)).accept((Visitor)this.getVisitor())) == null) {
            message = "<null>";
        } else if (message == invalid) {
            message = invalidRepr;
        }
        if (messagePrefix != null) {
            message = String.valueOf(messagePrefix) + " : " + message;
        }
        Object element = null;
        String formatedElement = null;
        if (args.size() > 1) {
            element = ((org.eclipse.ocl.expressions.OCLExpression)args.get(1)).accept((Visitor)this.getVisitor());
            formatedElement = element == invalid ? invalidRepr : EvaluationUtil.formatLoggedElement(element);
        }
        if (level == null) {
            if (element == null) {
                logger.log(String.valueOf(message));
            } else {
                logger.log(String.valueOf(message), formatedElement);
            }
        } else if (element == null) {
            logger.log(level, String.valueOf(message));
        } else {
            logger.log(level, String.valueOf(message), formatedElement);
        }
        return true;
    }

    public Object visitAssertExp(AssertExp assertExp) {
        Object assertionValue = assertExp.getAssertion().accept((Visitor)this.getVisitor());
        if (Boolean.FALSE.equals(assertionValue)) {
            this.setCurrentEnvInstructionPointer((EObject)assertExp);
            InternalEvaluationEnv internEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
            Module currentModule = internEvalEnv.getCurrentModule().getModule();
            IModuleSourceInfo moduleSource = ASTBindingHelper.getModuleSourceBinding(currentModule);
            String source = moduleSource != null ? moduleSource.getSourceURI().lastSegment() : EvaluationMessages.UknownSourceLabel;
            StringBuilder locationBuf = new StringBuilder(source);
            if (assertExp.getStartPosition() >= 0 && moduleSource != null) {
                int lineNum = moduleSource.getLineNumberProvider().getLineNumber(assertExp.getStartPosition());
                locationBuf.append(':').append(lineNum);
            }
            String message = NLS.bind((String)EvaluationMessages.AssertFailedMessage, (Object)assertExp.getSeverity(), (Object)locationBuf.toString());
            Log logger = this.getContext().getLog();
            if (assertExp.getLog() != null) {
                this.doVisitLogExp(assertExp.getLog(), logger, message);
            } else {
                logger.log(message);
            }
            if (SeverityKind.FATAL.equals((Object)assertExp.getSeverity())) {
                logger.log(EvaluationMessages.TerminatingExecution);
            }
            if (SeverityKind.FATAL.equals((Object)assertExp.getSeverity())) {
                this.throwQVTException(new QvtAssertionFailed(EvaluationMessages.FatalAssertionFailed));
            }
        }
        return null;
    }

    public Object visitImperativeLoopExp(ImperativeLoopExp imperativeLoopExp) {
        throw new UnsupportedOperationException();
    }

    public Object visitForExp(ForExp forExp) {
        Object sourceValue = forExp.getSource().accept((Visitor)this.getVisitor());
        if (!this.isUndefined(sourceValue)) {
            String resultName = QvtOperationalEvaluationVisitorImpl.generateName();
            this.getEvaluationEnvironment().add(resultName, null);
            Collection sourceCollection = (Collection)sourceValue;
            EList iterators = forExp.getIterator();
            OCLExpression condition = forExp.getCondition();
            org.eclipse.ocl.expressions.OCLExpression body = forExp.getBody();
            QvtIterationTemplateForExp.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)null, condition, body, resultName, "forOne".equals(forExp.getName()));
            this.getEvaluationEnvironment().remove(resultName);
        }
        return null;
    }

    public Object visitImperativeIterateExp(ImperativeIterateExp imperativeIterateExp) {
        EClassifier sourceType = (EClassifier)imperativeIterateExp.getSource().getType();
        if (sourceType instanceof PredefinedType) {
            Object sourceValue = imperativeIterateExp.getSource().accept((Visitor)this.getVisitor());
            if (this.isUndefined(sourceValue)) {
                return this.getOclInvalid();
            }
            CollectionType collType = (CollectionType)imperativeIterateExp.getSource().getType();
            Collection initResultVal = null;
            if (imperativeIterateExp.getName().equals("xselect")) {
                initResultVal = CollectionUtil.createNewCollection((CollectionKind)collType.getKind());
            } else if (imperativeIterateExp.getName().equals("xcollect") || imperativeIterateExp.getName().equals("collectselect")) {
                initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionUtil.createNewBag() : CollectionUtil.createNewSequence();
            }
            String resultName = QvtOperationalEvaluationVisitorImpl.generateName();
            this.getEvaluationEnvironment().add(resultName, (Object)initResultVal);
            Collection sourceCollection = (Collection)sourceValue;
            EList iterators = imperativeIterateExp.getIterator();
            Variable target = imperativeIterateExp.getTarget();
            OCLExpression condition = imperativeIterateExp.getCondition();
            org.eclipse.ocl.expressions.OCLExpression body = imperativeIterateExp.getBody();
            Object result = null;
            if ("xcollect".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXCollect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, false);
            } else if ("xselect".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, false);
            } else if ("collectselect".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateCollectSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, false);
            } else if ("collectOne".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXCollect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, true);
            } else if ("selectOne".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, true);
            } else if ("collectselectOne".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateCollectSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, true);
            }
            this.getEvaluationEnvironment().remove(resultName);
            return result;
        }
        String message = NLS.bind((String)EvaluationMessages.IteratorNotImpl, (Object)imperativeIterateExp.getName());
        throw new UnsupportedOperationException(message);
    }

    @Override
    public Object visitConstructor(Constructor constructor) {
        this.visitImperativeOperation(constructor);
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        env.add("result", env.remove("self"));
        return new OperationCallResult(this.visitOperationBody(constructor.getBody()), this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitConstructorBody(ConstructorBody constructorBody) {
        return this.visitOperationBody(constructorBody);
    }

    public Object visitBreakExp(BreakExp astNode) {
        throw new QvtTransitionReachedException(1);
    }

    public Object visitCatchtExp(CatchExp astNode) {
        return null;
    }

    public Object visitContinueExp(ContinueExp astNode) {
        throw new QvtTransitionReachedException(2);
    }

    public Object visitDictLiteralPart(DictLiteralPart astNode) {
        return null;
    }

    public Object visitOrderedTupleLiteralExp(OrderedTupleLiteralExp astNode) {
        return null;
    }

    public Object visitOrderedTupleLiteralPart(OrderedTupleLiteralPart astNode) {
        return null;
    }

    public Object visitRaiseExp(RaiseExp astNode) {
        return null;
    }

    public Object visitTryExp(TryExp astNode) {
        return null;
    }

    public Object visitUnlinkExp(UnlinkExp astNode) {
        return null;
    }

    public Object visitUnpackExp(UnpackExp astNode) {
        return null;
    }

    private static synchronized String generateName() {
        return "__qvtresult__" + tempCounter++;
    }

    private void initModule(ModuleInstance moduleInstance, ModelParameterHelper modelParameters) {
        Module type = moduleInstance.getModule();
        QvtOperationalEnv env = (QvtOperationalEnv)this.getEnvironment();
        QvtOperationalEvaluationEnv currentEvalEnv = this.getOperationalEvaluationEnv();
        QvtOperationalEvaluationEnv nestedEvalEnv = (QvtOperationalEvaluationEnv)env.getFactory().createEvaluationEnvironment((EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)this.getOperationalEvaluationEnv());
        nestedEvalEnv.add("this", moduleInstance);
        nestedEvalEnv.getOperationArgs().addAll(currentEvalEnv.getOperationArgs());
        nestedEvalEnv.getAdapter(InternalEvaluationEnv.class).setCurrentIP((EObject)type);
        try {
            this.setOperationalEvaluationEnv(nestedEvalEnv);
            EvaluationUtil.checkCurrentStackDepth(currentEvalEnv);
            this.pushedStack(nestedEvalEnv);
            for (ModuleImport moduleImport : type.getModuleImport()) {
                ModuleInstance.Internal importedInternal;
                Module importedModule = moduleImport.getImportedModule();
                ModuleInstance importedInstance = moduleInstance.getThisInstanceOf(importedModule);
                if (importedInstance == null || (importedInternal = importedInstance.getAdapter(ModuleInstance.Internal.class)).isInitialized()) continue;
                this.initModule(importedInstance, modelParameters);
            }
            this.doInitModule(moduleInstance, modelParameters);
            moduleInstance.getAdapter(ModuleInstance.Internal.class).setInitialized();
        }
        finally {
            this.setOperationalEvaluationEnv(this.getOperationalEvaluationEnv().getParent());
            this.poppedStack();
        }
    }

    private void doInitModule(ModuleInstance moduleInstance, ModelParameterHelper modelParameters) {
        Module module = moduleInstance.getModule();
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        if (modelParameters != null && module.eClass() == ExpressionsPackage.eINSTANCE.getOperationalTransformation()) {
            modelParameters.initModelParameters((TransformationInstance)moduleInstance);
        }
        for (EStructuralFeature feature : module.getConfigProperty()) {
            Object propValue = this.visitConfigProperty(feature);
            env.callSetter(moduleInstance, feature, propValue, this.isUndefined(propValue), true);
        }
        for (EStructuralFeature feature : module.getEStructuralFeatures()) {
            if (feature instanceof ContextualProperty || module.getConfigProperty().contains((Object)feature)) continue;
            this.setCurrentEnvInstructionPointer((EObject)feature);
            org.eclipse.ocl.expressions.OCLExpression<EClassifier> initExp = QvtOperationalParserUtil.getInitExpression(feature);
            Object propValue = null;
            if (initExp != null) {
                propValue = initExp.accept((Visitor)this.getVisitor());
            }
            env.callSetter(moduleInstance, feature, propValue, this.isUndefined(propValue), true);
        }
    }

    private IVirtualOperationTable getVirtualTable(EOperation operation) {
        return IVirtualOperationTable.Access.INSTANCE.getVirtualTable(operation);
    }

    private Object createOrGetResult(MappingOperation mappingOperation) {
        Object result = null;
        if (!mappingOperation.getResult().isEmpty() && this.isUndefined(result = this.getRuntimeValue("result"))) {
            EList<VarParameter> resultParams = mappingOperation.getResult();
            if (resultParams.size() > 1) {
                result = this.createTupleResult(mappingOperation);
            } else {
                VarParameter type;
                VarParameter varParameter = type = resultParams.isEmpty() ? null : (VarParameter)resultParams.get(0);
                if (type != null && !(type.getEType() instanceof VoidType)) {
                    result = this.createInstance(type.getEType(), ((MappingParameter)type).getExtent());
                }
            }
            this.replaceInEnv("result", result, mappingOperation.getEType());
        }
        TraceUtil.addTraceRecord(this.getOperationalEvaluationEnv(), mappingOperation);
        return result;
    }

    /*
     * Exception decompiling
     */
    private OperationCallResult executeImperativeOperation(ImperativeOperation method, Object source, List<Object> args, boolean isReusingMappingCall) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MappingCallResult dispatchDisjuctMapping(MappingOperation method) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        Object source = evalEnv.getOperationSelf();
        List<Object> args = evalEnv.getOperationArgs();
        for (MappingOperation nextDisjunct : method.getDisjunct()) {
            EList params;
            EClassifier ctxType = QvtOperationalParserUtil.getContextualType(nextDisjunct);
            if (ctxType != null && !evalEnv.isKindOf(source, nextDisjunct.getContext().getEType()) || (params = nextDisjunct.getEParameters()).size() != args.size()) continue;
            int i = 0;
            while (i < args.size()) {
                EClassifier nextParamType;
                Object nextArg = args.get(i);
                if (!evalEnv.isKindOf(nextArg, nextParamType = ((EParameter)params.get(i)).getEType())) {
                    // empty if block
                }
                ++i;
            }
            MappingCallResult result = (MappingCallResult)this.executeImperativeOperation(nextDisjunct, source, args, false);
            if (result.isPreconditionFailed()) continue;
            result.myStatus = 0;
            return result;
        }
        return new MappingCallResult(null, this.myEvalEnv, 8);
    }

    protected boolean canBePropagated(RuntimeException exception) {
        return exception instanceof ReturnExpEvent;
    }

    protected final void throwQVTException(QvtRuntimeException exception) throws QvtRuntimeException {
        this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class).throwQVTException(exception);
    }

    protected Object call(EOperation operation, org.eclipse.ocl.expressions.OCLExpression<EClassifier> body, Object target, Object[] args) {
        org.eclipse.ocl.expressions.OCLExpression<EClassifier> actualOperBody;
        EOperation actualOperation;
        EObject eTarget;
        if (target instanceof EObject && OCLAnnotationSupport.isDynamicInstance(eTarget = (EObject)target) && operation.eClass() != eTarget.eClass() && (actualOperation = this.getOCLAnnotationSupport().resolveDynamic(operation, eTarget)) != null && actualOperation != operation && (actualOperBody = this.getOperationBody(actualOperation)) != null) {
            EvaluationVisitor visitor;
            Environment myEnv = this.getEnvironment();
            EnvironmentFactory factory = myEnv.getFactory();
            EvaluationEnvironment nested = factory.createEvaluationEnvironment(this.getEvaluationEnvironment());
            nested.add("self", target);
            if (args.length > 0) {
                int i = 0;
                UMLReflection uml = myEnv.getUMLReflection();
                for (EParameter param : uml.getParameters((Object)operation)) {
                    nested.add(uml.getName((Object)param), args[i]);
                }
            }
            if ((visitor = factory.createEvaluationVisitor(myEnv, nested, this.getExtentMap())) instanceof QvtOperationalEvaluationVisitorImpl) {
                ((QvtOperationalEvaluationVisitorImpl)visitor).oclAnnotationSupport = this.getOCLAnnotationSupport();
            }
            return visitor.visitExpression(actualOperBody);
        }
        return super.call((Object)operation, body, target, args);
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp<EClassifier> cl) {
        if (cl.getType() instanceof ListType) {
            MutableListImpl<Object> result = new MutableListImpl<Object>();
            for (CollectionLiteralPart part : cl.getPart()) {
                if (part instanceof CollectionItem) {
                    CollectionItem item = (CollectionItem)part;
                    org.eclipse.ocl.expressions.OCLExpression itemExp = item.getItem();
                    Object itemVal = itemExp.accept((Visitor)this.getVisitor());
                    if (itemVal == null) continue;
                    result.add(itemVal);
                    continue;
                }
                CollectionRange range = (CollectionRange)part;
                org.eclipse.ocl.expressions.OCLExpression first = range.getFirst();
                org.eclipse.ocl.expressions.OCLExpression last = range.getLast();
                Integer firstVal = (Integer)first.accept((Visitor)this.getVisitor());
                Integer lastVal = (Integer)last.accept((Visitor)this.getVisitor());
                if (firstVal == null || lastVal == null) continue;
                int firstInt = firstVal;
                int lastInt = lastVal;
                int i = firstInt;
                while (i <= lastInt) {
                    result.add(new Integer(i));
                    ++i;
                }
            }
            return result;
        }
        return super.visitCollectionLiteralExp(cl);
    }

    protected Object navigate(EStructuralFeature property, org.eclipse.ocl.expressions.OCLExpression<EClassifier> derivation, Object target) {
        Environment myEnv = this.getEnvironment();
        EnvironmentFactory factory = myEnv.getFactory();
        EvaluationEnvironment nested = factory.createEvaluationEnvironment(this.getEvaluationEnvironment());
        nested.add("self", target);
        EvaluationVisitor visitor = factory.createEvaluationVisitor(myEnv, nested, this.getExtentMap());
        if (visitor instanceof QvtOperationalEvaluationVisitorImpl) {
            ((QvtOperationalEvaluationVisitorImpl)visitor).oclAnnotationSupport = this.getOCLAnnotationSupport();
        }
        return visitor.visitExpression(derivation);
    }

    protected org.eclipse.ocl.expressions.OCLExpression<EClassifier> getPropertyBody(EStructuralFeature property) {
        if (OCLAnnotationSupport.isDynamicClassFeature(property)) {
            return this.getOCLAnnotationSupport().getDerivedProperty(property);
        }
        return super.getPropertyBody((Object)property);
    }

    protected org.eclipse.ocl.expressions.OCLExpression<EClassifier> getOperationBody(EOperation operation) {
        if (operation != null && OCLAnnotationSupport.isDynamicClassOperation(operation)) {
            return this.getOCLAnnotationSupport().getBody(operation);
        }
        return super.getOperationBody((Object)operation);
    }

    private OCLAnnotationSupport getOCLAnnotationSupport() {
        if (this.oclAnnotationSupport == null) {
            this.oclAnnotationSupport = new OCLAnnotationSupport();
            this.oclAnnotationSupport.setErrorHandler(new OCLAnnotationSupport.ParseErrorHandler(){
                OCLExpression invalidBodyExpr = EcoreFactory.eINSTANCE.createInvalidLiteralExp();

                public OCLExpression handleError(ParserException parserException, EModelElement contextElement) {
                    QvtPlugin.log(QvtPlugin.createErrorStatus("Failed to parse OCL annotation :" + QvtOperationalEvaluationVisitorImpl.this.getUMLReflection().getQualifiedName((Object)contextElement), (Exception)((Object)parserException)));
                    return this.invalidBodyExpr;
                }
            });
        }
        return this.oclAnnotationSupport;
    }

    protected QvtOperationalEnv getOperationalEnv() {
        return (QvtOperationalEnv)this.getEnvironment();
    }

    @Override
    public QvtOperationalEvaluationEnv getOperationalEvaluationEnv() {
        return (QvtOperationalEvaluationEnv)this.getEvaluationEnvironment();
    }

    protected void addToEnv(String varName, Object value, EClassifier declaredType) {
        this.getOperationalEvaluationEnv().add(varName, value);
    }

    protected void replaceInEnv(String varName, Object value, EClassifier declaredType) {
        this.getOperationalEvaluationEnv().replace(varName, value);
    }

    private Object getRuntimeValue(String name) {
        return this.getEvaluationEnvironment().getValueOf(name);
    }

    private Object getOutOwner(ObjectExp objectExp) {
        Object owner = this.getRuntimeValue(objectExp.getName());
        if (owner != null) {
            if (!(objectExp.getType() instanceof CollectionType) && !this.oclIsKindOf(owner, objectExp.getType()).booleanValue()) {
                throw new RuntimeException(MessageFormat.format(EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_InvalidObjectExpType, objectExp.getName(), owner, objectExp.getType()));
            }
        } else {
            owner = this.createInstance((EClassifier)objectExp.getType(), (ModelParameter)objectExp.getExtent());
            if (objectExp.getName() != null) {
                this.getOperationalEvaluationEnv().replace(objectExp.getName(), owner);
            }
        }
        return owner;
    }

    private Tuple<EOperation, EStructuralFeature> createTupleResult(ImperativeOperation operation) {
        boolean isMapping = operation.eClass() == ExpressionsPackage.eINSTANCE.getMappingOperation();
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        EList<VarParameter> resultParams = operation.getResult();
        HashMap<EStructuralFeature, Object> values = new HashMap<EStructuralFeature, Object>(2);
        TupleType tupleType = (TupleType)operation.getEType();
        for (EStructuralFeature tupleProp : tupleType.oclProperties()) {
            Object propVal = evalEnv.getValueOf(tupleProp.getName());
            if (propVal == null) {
                ModelParameter extent = null;
                for (VarParameter resultParam : resultParams) {
                    if (!tupleProp.getName().equals(resultParam.getName())) continue;
                    MappingParameter mappingParameter = (MappingParameter)resultParam;
                    extent = mappingParameter.getExtent();
                    break;
                }
                if (isMapping) {
                    propVal = this.createInstance(tupleProp.getEType(), extent);
                }
            }
            values.put(tupleProp, propVal);
            evalEnv.replace(tupleProp.getName(), propVal, tupleProp.getEType());
        }
        return evalEnv.createTuple(operation.getEType(), values);
    }

    private static CollectionKind getCollectionKind(Collection<?> collection) {
        if (collection instanceof ArrayList) {
            return CollectionKind.SEQUENCE_LITERAL;
        }
        if (collection instanceof LinkedHashSet) {
            return CollectionKind.ORDERED_SET_LITERAL;
        }
        if (collection instanceof HashSet) {
            return CollectionKind.SET_LITERAL;
        }
        if (collection instanceof Bag) {
            return CollectionKind.BAG_LITERAL;
        }
        return null;
    }

    private List<Object> makeArgs(OperationCallExp<EClassifier, EOperation> operationCallExp) {
        ArrayList<Object> argValues = new ArrayList<Object>();
        for (org.eclipse.ocl.expressions.OCLExpression arg : operationCallExp.getArgument()) {
            Object value = arg.accept((Visitor)this.getVisitor());
            argValues.add(value);
        }
        return argValues;
    }

    private List<Object> makeEntryOperationArgs(ImperativeOperation entryPoint, OperationalTransformation module) {
        ArrayList<Object> args = new ArrayList<Object>(entryPoint.getEParameters().size());
        int paramIndex = 0;
        for (EParameter param : entryPoint.getEParameters()) {
            int matchedIndex = paramIndex;
            MappingParameter mappingParam = (MappingParameter)param;
            if (mappingParam.getKind() == DirectionKind.OUT) {
                args.add(null);
                continue;
            }
            if (mappingParam.getExtent() != null) {
                int modelParamIndex = 0;
                for (ModelParameter modelParam : module.getModelParameter()) {
                    if (modelParam == mappingParam.getExtent()) {
                        matchedIndex = modelParamIndex;
                        break;
                    }
                    ++modelParamIndex;
                }
            }
            if (matchedIndex < this.getOperationalEvaluationEnv().getOperationArgs().size()) {
                Object envArg = this.getOperationalEvaluationEnv().getOperationArgs().get(matchedIndex);
                ModelInstance argModel = (ModelInstance)envArg;
                ModelParameterExtent argExtent = argModel.getExtent();
                List<EObject> initialObjects = argExtent.getInitialObjects();
                if (!initialObjects.isEmpty()) {
                    args.add(initialObjects.get(0));
                }
            } else {
                throw new IllegalArgumentException("entry operation arguments mismatch: no argument for " + mappingParam + " parameter");
            }
            ++paramIndex;
        }
        return args;
    }

    protected Object createInstance(EClassifier type, ModelParameter extent) throws QvtRuntimeException {
        Object newInstance = null;
        try {
            if (type instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)type;
                newInstance = collectionType.getKind() == CollectionKind.COLLECTION_LITERAL ? CollectionUtil.createNewSequence() : CollectionUtil.createNewCollection((CollectionKind)collectionType.getKind());
            } else {
                newInstance = this.getOperationalEvaluationEnv().createInstance(type, extent);
                EFactory eFactory = type.getEPackage().getEFactoryInstance();
                if (eFactory instanceof IntermediateClassFactory) {
                    IntermediateClassFactory intermFactory = (IntermediateClassFactory)eFactory;
                    intermFactory.doInstancePropertyInit(newInstance, this.getQVTVisitor());
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.throwQVTException(new QvtRuntimeException(e));
        }
        return newInstance;
    }

    private EObject setCurrentEnvInstructionPointer(EObject node) {
        InternalEvaluationEnv internEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        if (node != null) {
            return internEnv.setCurrentIP(node);
        }
        return internEnv.getCurrentIP();
    }

    private InternalEvaluator createInterruptibleVisitor() {
        EvaluationMonitor monitor = this.getContext().getMonitor();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InterruptVisitor
        extends QvtGenericEvaluationVisitor.Any
        implements InternalEvaluator {
            private final /* synthetic */ EvaluationMonitor val$monitor;

            public InterruptVisitor(EvaluationMonitor evaluationMonitor) {
                this.val$monitor = evaluationMonitor;
                super(QvtOperationalEvaluationVisitorImpl.this);
            }

            @Override
            public Object execute(OperationalTransformation transformation) throws QvtRuntimeException {
                return QvtOperationalEvaluationVisitorImpl.this.execute(transformation);
            }

            @Override
            public QvtOperationalEvaluationEnv getOperationalEvaluationEnv() {
                return QvtOperationalEvaluationVisitorImpl.this.getOperationalEvaluationEnv();
            }

            @Override
            public void setOperationalEvaluationEnv(QvtOperationalEvaluationEnv evalEnv) {
                QvtOperationalEvaluationVisitorImpl.this.setOperationalEvaluationEnv(evalEnv);
            }

            @Override
            public IContext getContext() {
                return QvtOperationalEvaluationVisitorImpl.this.getContext();
            }

            @Override
            public ModuleInstance callTransformationImplicitConstructor(OperationalTransformation transformation, List<ModelInstance> args) {
                return QvtOperationalEvaluationVisitorImpl.this.callTransformationImplicitConstructor(transformation, (List)args);
            }

            @Override
            public OperationCallResult runMainEntry(OperationalTransformation transformation, List<Object> args) {
                return QvtOperationalEvaluationVisitorImpl.this.runMainEntry(transformation, args);
            }

            @Override
            protected void genericVisitAny(Object object) {
                if (this.val$monitor != null && this.val$monitor.isCanceled()) {
                    if (object instanceof ASTNode) {
                        QvtOperationalEvaluationVisitorImpl.this.throwQVTException(new QvtInterruptedExecutionException());
                    } else {
                        QvtOperationalEvaluationVisitorImpl.this.throwQVTException(new QvtInterruptedExecutionException());
                    }
                }
            }
        }
        return new InterruptVisitor(monitor);
    }

    @Override
    public OperationCallResult runMainEntry(OperationalTransformation transformation, List<Object> args) {
        ImperativeOperation entryOperation = QvtOperationalParserUtil.getMainOperation(transformation);
        OperationCallResult result = this.executeImperativeOperation(entryOperation, null, args, false);
        this.processDeferredTasks();
        return result;
    }

    protected QvtOperationalEvaluationVisitor getQVTVisitor() {
        return (QvtOperationalEvaluationVisitor)this.getVisitor();
    }

    private Object createFromString(EClassifier type, String stringValue) {
        Object value;
        if (stringValue == null) {
            return null;
        }
        if (!QvtOperationalUtil.isCreateFromStringSupported(type)) {
            return this.getOclInvalid();
        }
        try {
            if (type instanceof PrimitiveType && "Integer".equals(((PrimitiveType)type).getName())) {
                return new Integer(stringValue);
            }
            if (type instanceof PrimitiveType && "Real".equals(((PrimitiveType)type).getName())) {
                return new Double(stringValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return this.getOclInvalid();
        }
        if (type instanceof PrimitiveType && "String".equals(((PrimitiveType)type).getName())) {
            return new String(stringValue);
        }
        if (type instanceof PrimitiveType && "Boolean".equals(((PrimitiveType)type).getName())) {
            return Boolean.valueOf(stringValue);
        }
        if (type instanceof EDataType && type.getEPackage() != null && type.getEPackage().getEFactoryInstance() != null && (value = type.getEPackage().getEFactoryInstance().createFromString((EDataType)type, stringValue)) != null) {
            return value;
        }
        return this.getOclInvalid();
    }

    private static class MappingCallResult
    extends OperationCallResult {
        static final int BODY_EXECUTED = 0;
        static final int PRECOND_FAILED = 2;
        static final int FETCHED_FROM_TRACE = 4;
        static final int NO_DISJUCT_SELECTED = 8;
        int myStatus;

        private MappingCallResult(Object myResult, QvtOperationalEvaluationEnv myEvalEnv, int status) {
            super(myResult, myEvalEnv);
            this.myStatus = status;
        }

        boolean isBodyExecuted() {
            return this.myStatus == 0;
        }

        boolean isPreconditionFailed() {
            return (this.myStatus & 2) != 0;
        }

        boolean isFetchedFromTrace() {
            return (this.myStatus & 4) != 0;
        }

        boolean isNoDisjunctSelected() {
            return (this.myStatus & 8) != 0;
        }
    }

    static class OperationCallResult {
        public Object myResult;
        public QvtOperationalEvaluationEnv myEvalEnv;

        OperationCallResult(Object myResult, QvtOperationalEvaluationEnv myEvalEnv) {
            this.myResult = myResult;
            this.myEvalEnv = myEvalEnv;
        }
    }

    private static class ReturnExpEvent
    extends RuntimeException {
        private static final long serialVersionUID = 2971434369853642555L;
        private final OperationCallResult fResult;

        ReturnExpEvent(Object returnValue, QvtOperationalEvaluationEnv evalEnv) {
            this.fResult = new OperationCallResult(returnValue, evalEnv);
        }

        public OperationCallResult getResult() {
            return this.fResult;
        }
    }

    private static class SwitchAltExpResult {
        public Object myCondition;
        public Object myResult;

        private SwitchAltExpResult() {
        }
    }
}

