/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newproject;

import java.util.StringTokenizer;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AcceleoNewUIConfigurationPage
extends WizardPage {
    private static final String DEFAULT_MODEL_NAME_FILTER = "*.*";
    private static final String DEFAULT_OUTPUT_FOLDER = "IContainer target = model.getProject().getFolder(\"src-gen\");";
    private Text moduleName;
    private String initialSelectedProjectName;
    private Text modelNameFilter;
    private Text targetFolderAccess;

    public AcceleoNewUIConfigurationPage(String pageName, String initialSelectedProjectName) {
        super(pageName);
        this.setTitle(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.Title"));
        this.setDescription(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.Description"));
        this.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
        this.initialSelectedProjectName = initialSelectedProjectName;
    }

    public void createControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridLayout rootContainerLayout = new GridLayout();
        boolean numColumns = true;
        int marginTop = 14;
        int verticalSpacing = 15;
        int marginLeft = 7;
        int marginRight = 7;
        rootContainerLayout.numColumns = 1;
        rootContainerLayout.marginTop = 14;
        rootContainerLayout.verticalSpacing = 15;
        rootContainerLayout.marginLeft = 7;
        rootContainerLayout.marginRight = 7;
        rootContainer.setLayout((Layout)rootContainerLayout);
        this.createModuleNameGroup(rootContainer);
        this.createConfigurationGroup(rootContainer);
        this.setControl((Control)rootContainer);
        this.dialogChanged();
        this.moduleName.setText(this.computeModuleName());
        this.modelNameFilter.setText(DEFAULT_MODEL_NAME_FILTER);
        this.targetFolderAccess.setText(DEFAULT_OUTPUT_FOLDER);
    }

    private String computeModuleName() {
        if (this.initialSelectedProjectName != null && this.initialSelectedProjectName.length() > 0) {
            String mName = this.initialSelectedProjectName;
            if (mName.endsWith(".ui")) {
                mName = mName.substring(0, mName.length() - ".ui".length());
            }
            if (mName.startsWith("org.eclipse.acceleo.module.")) {
                mName = mName.substring("org.eclipse.acceleo.module.".length());
            } else {
                int i = mName.lastIndexOf(46);
                if (i > -1) {
                    mName = mName.substring(i + 1);
                }
            }
            if (mName.length() > 0) {
                StringTokenizer st = new StringTokenizer(mName, "._-* \t");
                mName = "";
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.length() > 0) {
                        mName = String.valueOf(mName) + Character.toUpperCase(token.charAt(0)) + token.substring(1);
                    }
                    if (token.length() <= 0 || !st.hasMoreTokens()) continue;
                    mName = String.valueOf(mName) + " ";
                }
            }
            return mName;
        }
        return "";
    }

    private void createModuleNameGroup(Composite rootContainer) {
        Group moduleNameGroup = new Group(rootContainer, 0);
        moduleNameGroup.setText(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.ModuleName"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        moduleNameGroup.setLayout((Layout)layout);
        moduleNameGroup.setLayoutData((Object)new GridData(768));
        this.moduleName = new Text((Composite)moduleNameGroup, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.moduleName.setLayoutData((Object)gridData);
        this.moduleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewUIConfigurationPage.this.dialogChanged();
            }
        });
    }

    private void createConfigurationGroup(Composite rootContainer) {
        Group configGroup = new Group(rootContainer, 0);
        configGroup.setText(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.Group"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        configGroup.setLayout((Layout)layout);
        configGroup.setLayoutData((Object)new GridData(768));
        Composite configContainer = new Composite((Composite)configGroup, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        configContainer.setLayoutData((Object)gridData);
        GridLayout configContainerLayout = new GridLayout();
        configContainerLayout.numColumns = 1;
        configContainer.setLayout((Layout)configContainerLayout);
        Label modelLabel = new Label(configContainer, 0);
        modelLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.ModelName")) + ':');
        this.modelNameFilter = new Text(configContainer, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.modelNameFilter.setLayoutData((Object)gridData);
        this.modelNameFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewUIConfigurationPage.this.dialogChanged();
            }
        });
        Label targetLabel = new Label(configContainer, 0);
        targetLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.TargetFolder")) + ':');
        this.targetFolderAccess = new Text(configContainer, 2626);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        int heightHint = 60;
        gridData.heightHint = 60;
        this.targetFolderAccess.setLayoutData((Object)gridData);
        this.targetFolderAccess.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewUIConfigurationPage.this.dialogChanged();
            }
        });
    }

    protected void dialogChanged() {
        if (this.getModuleName().length() == 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.Error.MissingModuleName"));
        } else if (this.getModelNameFilter().length() == 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.Error.MissingModelName"));
        } else if (this.getTargetFolderAccess().length() == 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewUIConfigurationPage.Error.MissingTargetFolder"));
        } else {
            this.updateStatus(null);
        }
    }

    private void updateStatus(String message) {
        this.setMessage(message);
        this.setPageComplete(true);
    }

    public String getModuleName() {
        return this.moduleName.getText();
    }

    public String getModelNameFilter() {
        return this.modelNameFilter.getText();
    }

    public String getTargetFolderAccess() {
        return this.targetFolderAccess.getText();
    }
}

