/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newproject;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizard;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleActivatorWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleBuildWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleClasspathWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleData;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleMANIFESTWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleProjectWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleSettingsWriter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class AcceleoNewProjectWizard
extends AcceleoNewTemplatesWizard {
    public static final String MODULE_NAME_PREFIX = "org.eclipse.acceleo.module.";
    protected WizardNewProjectCreationPage newProjectPage;

    public AcceleoNewProjectWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
    }

    public WizardNewProjectCreationPage getNewProjectPage() {
        return this.newProjectPage;
    }

    protected boolean multipleTemplates() {
        return true;
    }

    public void addPages() {
        this.newProjectPage = new WizardNewProjectCreationPage(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Name"));
        this.newProjectPage.setInitialProjectName("org.eclipse.acceleo.module.sample");
        this.newProjectPage.setTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
        this.newProjectPage.setDescription(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Description"));
        this.newProjectPage.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
        this.addPage((IWizardPage)this.newProjectPage);
        super.addPages();
    }

    public boolean performFinish() {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CreateModuleData arg = new CreateModuleData(AcceleoNewProjectWizard.this);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(AcceleoNewProjectWizard.this.newProjectPage.getProjectName());
                IPath location = AcceleoNewProjectWizard.this.newProjectPage.getLocationPath();
                if (!project.exists()) {
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(AcceleoNewProjectWizard.this.newProjectPage.getProjectName());
                    if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                        location = null;
                    }
                    desc.setLocation(location);
                    project.create(desc, monitor);
                    project.open(monitor);
                    AcceleoNewProjectWizard.this.convert(project, arg, monitor);
                }
                if (!project.isOpen()) {
                    project.open(monitor);
                }
                AcceleoNewProjectWizard.super.performFinish();
                AcceleoNewProjectWizard.this.appendManifestExportedPackages(project, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    protected void convert(IProject project, CreateModuleData arg, IProgressMonitor monitor) {
        CreateModuleActivatorWriter activatorWriter = new CreateModuleActivatorWriter();
        String text = activatorWriter.generate(arg);
        Path file = new Path("/src/" + arg.getProjectName().replaceAll("\\.", "/") + "/Activator.java");
        this.createFile(project, (IPath)file, text, monitor);
        CreateModuleBuildWriter buildWriter = new CreateModuleBuildWriter();
        text = buildWriter.generate(arg);
        file = new Path("build.properties");
        this.createFile(project, (IPath)file, text, monitor);
        CreateModuleClasspathWriter classpathWriter = new CreateModuleClasspathWriter();
        text = classpathWriter.generate(arg);
        file = new Path(".classpath");
        this.createFile(project, (IPath)file, text, monitor);
        CreateModuleMANIFESTWriter manifestWriter = new CreateModuleMANIFESTWriter();
        text = manifestWriter.generate(arg);
        file = new Path("META-INF/MANIFEST.MF");
        this.createFile(project, (IPath)file, text, monitor);
        CreateModuleProjectWriter projectWriter = new CreateModuleProjectWriter();
        text = projectWriter.generate(arg);
        file = new Path(".project");
        this.createFile(project, (IPath)file, text, monitor);
        CreateModuleSettingsWriter settingsWriter = new CreateModuleSettingsWriter();
        text = settingsWriter.generate(arg);
        file = new Path("/.settings/org.eclipse.jdt.core.prefs");
        this.createFile(project, (IPath)file, text, monitor);
    }

    private void createFile(IProject project, IPath projectRelativePath, String content, IProgressMonitor monitor) {
        try {
            ByteArrayInputStream javaStream = new ByteArrayInputStream(content.getBytes("UTF8"));
            IProject container = project;
            String[] folders = projectRelativePath.removeLastSegments(1).segments();
            int i = 0;
            while (i < folders.length) {
                if (!(container = container.getFolder((IPath)new Path(folders[i]))).exists()) {
                    ((IFolder)container).create(true, true, monitor);
                }
                ++i;
            }
            IFile file = container.getFile((IPath)new Path(projectRelativePath.lastSegment()));
            if (!file.exists() && file.getParent().exists()) {
                IResource[] members = file.getParent().members(1);
                int i2 = 0;
                while (i2 < members.length) {
                    if (members[i2] instanceof IFile && file.getName().toLowerCase().equals(members[i2].getName().toLowerCase())) {
                        file = (IFile)members[i2];
                        break;
                    }
                    ++i2;
                }
            }
            if (!file.exists()) {
                file.create((InputStream)javaStream, true, monitor);
            } else {
                file.setContents((InputStream)javaStream, true, false, monitor);
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (UnsupportedEncodingException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void appendManifestExportedPackages(IProject project, IProgressMonitor monitor) throws CoreException {
        StringBuffer exportedContent = new StringBuffer();
        this.computeExportedPackagesContent(exportedContent, "", (IContainer)project.getFolder((IPath)new Path("src")));
        exportedContent.append("\n");
        try {
            ByteArrayInputStream appendStream = new ByteArrayInputStream(exportedContent.toString().getBytes("UTF8"));
            project.getFile((IPath)new Path("META-INF/MANIFEST.MF")).appendContents((InputStream)appendStream, true, false, monitor);
        }
        catch (UnsupportedEncodingException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void computeExportedPackagesContent(StringBuffer exportedContent, String currentPackageName, IContainer folder) throws CoreException {
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof IContainer) {
                String packageName = currentPackageName;
                packageName = packageName.length() == 0 ? members[i].getName() : String.valueOf(packageName) + "." + members[i].getName();
                if (this.hasTemplate((IContainer)members[i])) {
                    if (exportedContent.length() == 0) {
                        exportedContent.append("Export-Package:");
                    } else {
                        exportedContent.append(",\n");
                    }
                    exportedContent.append(" ");
                    exportedContent.append(packageName);
                }
                this.computeExportedPackagesContent(exportedContent, packageName, (IContainer)members[i]);
            }
            ++i;
        }
    }

    private boolean hasTemplate(IContainer folder) throws CoreException {
        IResource[] members = folder.members();
        boolean hasTemplate = false;
        int i = 0;
        while (!hasTemplate && i < members.length) {
            if (members[i] instanceof IFile && "mtl".equals(((IFile)members[i]).getFileExtension())) {
                hasTemplate = true;
            }
            ++i;
        }
        return hasTemplate;
    }
}

