/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.ColorManager;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.FirstVariableRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.SequenceBlockRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoWhitespaceDetector;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.IAcceleoColorConstants;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoBlockScanner
extends AbstractAcceleoScanner {
    private static final String[] KEYWORDS = new String[]{"module", "comment", "import", "extends", "overrides", "template", "public", "protected", "private", "query", "for", "before", "after", "separator", "?", "if", "elseif", "else", "let", "elselet", "trace", "macro", "file", "protected", "self", "super"};
    private static final String[] DELIMITERS = new String[]{"[/", "/]", "[", "]"};

    public AcceleoBlockScanner(ColorManager manager) {
        this(manager, false);
    }

    public AcceleoBlockScanner(ColorManager manager, boolean italic) {
        IRule[] rules = this.getRules(manager, italic);
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)this.getDefaultReturnToken(manager, italic));
    }

    protected IRule[] getRules(ColorManager manager, boolean italic) {
        int style = italic ? 2 : 0;
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)new KeywordRule("'"), (ISequenceRule)new KeywordRule("'"), new KeywordRule("\\'"), (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.LITERAL), null, style))));
        this.computeKeywordRules(rules, manager, italic);
        this.computeDelimitersRules(rules, manager, italic);
        Color foreGroundColor = manager.getColor(IAcceleoColorConstants.KEYWORD);
        Color backGroundColor = manager.getColor(IAcceleoColorConstants.FIRST_VARIABLE);
        rules.add((IRule)new FirstVariableRule(new String[]{"[", "for", "("}, (IToken)new Token((Object)new TextAttribute(foreGroundColor, backGroundColor, style))));
        rules.add((IRule)new FirstVariableRule(new String[]{"[", "let"}, (IToken)new Token((Object)new TextAttribute(foreGroundColor, backGroundColor, style))));
        rules.add((IRule)new FirstVariableRule(new String[]{"[", "elselet"}, (IToken)new Token((Object)new TextAttribute(foreGroundColor, backGroundColor, style))));
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new AcceleoWhitespaceDetector()));
        return rules.toArray(new IRule[rules.size()]);
    }

    private void computeKeywordRules(List<IRule> rules, ColorManager manager, boolean italic) {
        int style = italic ? 3 : 1;
        int i = 0;
        while (i < KEYWORDS.length) {
            String keyword = KEYWORDS[i];
            rules.add((IRule)new KeywordRule(keyword, true, false, (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.KEYWORD), null, style))));
            ++i;
        }
    }

    private void computeDelimitersRules(List<IRule> rules, ColorManager manager, boolean italic) {
        int style = italic ? 3 : 1;
        int i = 0;
        while (i < DELIMITERS.length) {
            String keyword = DELIMITERS[i];
            rules.add((IRule)new KeywordRule(keyword, false, false, (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.KEYWORD), null, style))));
            ++i;
        }
    }

    protected Token getDefaultReturnToken(ColorManager manager, boolean italic) {
        int style = italic ? 2 : 0;
        return new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.BLOCK), null, style));
    }

    @Override
    public String getConfiguredContentType() {
        return "__ACCELEO_block";
    }
}

