/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.AcceleoServicesEclipseUtil;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoServicesRegistry {
    public static final AcceleoServicesRegistry INSTANCE = new AcceleoServicesRegistry();
    private static final String INSTANTIATION_FAILURE_KEY = "AcceleoServicesRegistry.ClassInstantiationFailure";
    private static final String CONSTRUCTOR_FAILURE_KEY = "AcceleoServicesRegistry.ClassConstructorFailure";
    private final Set<Class<?>> registeredServices = new LinkedHashSet();
    private final Map<Class<?>, Object> serviceInstances = new HashMap();

    private AcceleoServicesRegistry() {
    }

    public boolean addServiceClass(Class<?> service) {
        return this.registeredServices.add(service);
    }

    @Deprecated
    public boolean addService(Object service) {
        boolean registered = false;
        registered = service instanceof Class ? this.addServiceClass((Class)service) : this.addServiceClass(service.getClass());
        return registered;
    }

    @Deprecated
    public boolean addService(String bundleName, String qualifiedName) {
        return this.addServiceClass(bundleName, qualifiedName) != null;
    }

    public Class<?> addServiceClass(String bundleName, String qualifiedName) {
        Class<?> clazz = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            clazz = AcceleoServicesEclipseUtil.registerService(bundleName, qualifiedName);
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(qualifiedName);
                if (clazz != null) {
                    this.registeredServices.add(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoServicesRegistry.ClassLookupFailure", qualifiedName), e, true);
            }
        }
        return clazz;
    }

    @Deprecated
    public Object addService(URI uri, String qualifiedName) {
        return this.addServiceClass(uri, qualifiedName);
    }

    public Class<?> addServiceClass(URI uri, String qualifiedName) {
        Class<?> clazz;
        block5: {
            clazz = null;
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                clazz = AcceleoServicesEclipseUtil.registerService(uri, qualifiedName);
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName(qualifiedName);
                    if (clazz != null) {
                        this.registeredServices.add(clazz);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (EMFPlugin.IS_ECLIPSE_RUNNING) break block5;
                    AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoServicesRegistry.ClassLookupFailure", qualifiedName), e, true);
                }
            }
        }
        return clazz;
    }

    public Object getServiceInstance(Class<?> serviceClass) {
        Object serviceInstance = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            serviceInstance = AcceleoServicesEclipseUtil.getServiceInstance(serviceClass);
        }
        if (serviceInstance == null && (serviceInstance = this.serviceInstances.get(serviceClass)) == null) {
            try {
                serviceInstance = serviceClass.newInstance();
                this.serviceInstances.put(serviceClass, serviceInstance);
            }
            catch (InstantiationException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString(INSTANTIATION_FAILURE_KEY, serviceClass.getName()), e, false);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString(CONSTRUCTOR_FAILURE_KEY, serviceClass.getName()), e, false);
            }
        }
        return serviceInstance;
    }

    public boolean removeService(Object service) {
        return this.registeredServices.remove(service);
    }

    public void clearRegistry() {
        this.registeredServices.clear();
    }
}

