/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.writers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.internal.evaluation.JMergeUtil;
import org.eclipse.emf.common.EMFPlugin;

public class AcceleoStringWriter
extends AbstractAcceleoWriter {
    private String oldContent;
    private boolean shouldMerge;
    private final String targetPath;

    public AcceleoStringWriter(File target, boolean appendMode, boolean merge) {
        this(target, appendMode, merge, null);
    }

    public AcceleoStringWriter(File target, boolean appendMode, boolean merge, String fileCharset) {
        this.delegate = new StringWriter(1024);
        this.targetPath = target.getPath();
        try {
            if (appendMode && target.exists() && target.canRead()) {
                this.delegate.append(this.readOldContent(target, fileCharset));
                this.delegate.append(LINE_SEPARATOR);
            }
            if (!appendMode && merge) {
                this.oldContent = this.readOldContent(target, fileCharset);
                this.shouldMerge = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.shouldMerge && EMFPlugin.IS_ECLIPSE_RUNNING) {
            try {
                Class.forName("org.eclipse.emf.codegen.merge.java.JMerger");
                String mergedContent = JMergeUtil.mergeContent(new File(this.targetPath), this.toString(), this.oldContent);
                this.delegate = new StringWriter(1024);
                this.append(mergedContent);
            }
            catch (ClassNotFoundException e) {
                AcceleoEnginePlugin.log(e, true);
            }
        }
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void reinit() {
        this.oldContent = this.toString();
        this.shouldMerge = true;
        this.delegate = new StringWriter(1024);
    }

    private String readOldContent(File target, String charset) throws IOException {
        BufferedReader reader = null;
        StringBuilder fileContent = new StringBuilder();
        try {
            if (charset == null) {
                reader = new BufferedReader(new FileReader(target));
            } else {
                FileInputStream fileInputStream = new FileInputStream(target);
                InputStreamReader fileReader = new InputStreamReader((InputStream)fileInputStream, charset);
                reader = new BufferedReader(fileReader);
            }
            String line = reader.readLine();
            while (line != null) {
                fileContent.append(line);
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return fileContent.toString();
    }
}

