/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.AbstractAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AcceleoEngine;
import org.eclipse.acceleo.engine.generation.IAcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.DefaultStrategy;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.acceleo.engine.internal.utils.AcceleoEngineRegistry;
import org.eclipse.acceleo.engine.internal.utils.AcceleoListenerDescriptor;
import org.eclipse.acceleo.engine.internal.utils.AcceleoTraceabilityRegistryListenerUils;
import org.eclipse.acceleo.engine.internal.utils.DefaultEngineSelector;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoService {
    private static final List<IAcceleoTextGenerationListener> STATIC_LISTENERS = new ArrayList<IAcceleoTextGenerationListener>();
    private static final String TEMPLATE_CALL_NPE = AcceleoEngineMessages.getString("AcceleoService.NullArguments");
    private static final String UNDEFINED_TEMPLATE = "AcceleoService.UndefinedTemplate";
    private IAcceleoEngine generationEngine;
    private final IAcceleoGenerationStrategy strategy;
    private final List<IAcceleoTextGenerationListener> addedListeners = new ArrayList<IAcceleoTextGenerationListener>();
    private final List<String> addedPropertiesfiles = new ArrayList<String>();
    private final List<Map<String, String>> addedProperties = new ArrayList<Map<String, String>>();
    private String generationID;
    private boolean deactivateTraceability;
    private boolean generationHasOccurred;

    public AcceleoService() {
        this(null);
    }

    public AcceleoService(IAcceleoGenerationStrategy generationStrategy) {
        this.strategy = generationStrategy == null ? new DefaultStrategy() : generationStrategy;
        this.createEngine();
    }

    public static void addStaticListener(IAcceleoTextGenerationListener listener) {
        STATIC_LISTENERS.add(listener);
    }

    public static void removeStaticListener(IAcceleoTextGenerationListener listener) {
        STATIC_LISTENERS.remove(listener);
    }

    public void addListener(IAcceleoTextGenerationListener listener) {
        this.generationEngine.addListener(listener);
        this.addedListeners.add(listener);
    }

    public void addProperties(Map<String, String> customProperties) {
        this.generationEngine.addProperties(customProperties);
        this.addedProperties.add(customProperties);
    }

    public void addPropertiesFile(String propertiesFile) throws MissingResourceException {
        this.generationEngine.addProperties(propertiesFile);
        this.addedPropertiesfiles.add(propertiesFile);
    }

    @Deprecated
    public void dispose() {
    }

    public Map<String, String> doGenerate(Map<Module, Set<String>> templates, EObject model, File generationRoot, Monitor monitor) {
        this.generationHasOccurred = false;
        if (templates == null || model == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        HashMap<EClassifier, CompactHashSet> templateTypes = new HashMap<EClassifier, CompactHashSet>();
        for (Map.Entry<Module, Set<String>> entry : templates.entrySet()) {
            for (String string : entry.getValue()) {
                List<Template> templateList = this.findTemplates(entry.getKey(), string, 1);
                for (Template template : templateList) {
                    EClassifier templateType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
                    if (templateTypes.containsKey(templateType)) {
                        ((Set)templateTypes.get(templateType)).add(template);
                        continue;
                    }
                    CompactHashSet temp = new CompactHashSet();
                    temp.add(template);
                    templateTypes.put(templateType, temp);
                }
            }
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        arguments.add(model);
        for (Map.Entry entry : templateTypes.entrySet()) {
            if (!((EClassifier)entry.getKey()).isInstance((Object)model)) continue;
            for (Template template : (Set)entry.getValue()) {
                previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
                this.generationHasOccurred = true;
            }
        }
        TreeIterator treeIterator = model.eAllContents();
        while (treeIterator.hasNext()) {
            EObject potentialTarget = (EObject)treeIterator.next();
            for (Map.Entry entry : templateTypes.entrySet()) {
                if (!((EClassifier)entry.getKey()).isInstance((Object)potentialTarget)) continue;
                arguments.clear();
                arguments.add(potentialTarget);
                for (Template template : (Set)entry.getValue()) {
                    previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
                    this.generationHasOccurred = true;
                }
            }
        }
        if (!this.generationHasOccurred && AcceleoPreferences.isDebugMessagesEnabled()) {
            AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoService.NoGenerationHasOccurred"), false);
        }
        this.generationHasOccurred = false;
        this.clearCaches();
        return previewResult;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, File generationRoot, boolean blockTraceability, Monitor monitor) {
        this.deactivateTraceability = blockTraceability;
        HashMap<String, String> result = new HashMap<String, String>();
        List<Template> templates = this.findTemplates(module, templateName, 1);
        for (Template template : templates) {
            result.putAll(this.doGenerate(template, model, generationRoot, monitor));
        }
        return result;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, File generationRoot, Monitor monitor) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Template> templates = this.findTemplates(module, templateName, 1);
        for (Template template : templates) {
            result.putAll(this.doGenerate(template, model, generationRoot, monitor));
        }
        return result;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        this.generationHasOccurred = false;
        if (model == null || arguments == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        List<Template> templates = this.findTemplates(module, templateName, arguments.size() + 1);
        ArrayList<Template> mainTemplates = new ArrayList<Template>();
        for (Template template : templates) {
            if (!template.isMain()) continue;
            mainTemplates.add(template);
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        for (Template template : mainTemplates) {
            EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
            if (argumentType.eIsProxy()) {
                throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoService.TypeIsProxy", templateName));
            }
            if (argumentType.isInstance((Object)model)) {
                ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
                actualArguments.add(model);
                actualArguments.addAll(arguments);
                previewResult.putAll(this.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
                this.generationHasOccurred = true;
            }
            TreeIterator targetElements = model.eAllContents();
            while (targetElements.hasNext()) {
                EObject potentialTarget = (EObject)targetElements.next();
                if (!argumentType.isInstance((Object)potentialTarget)) continue;
                ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
                actualArguments.add(potentialTarget);
                actualArguments.addAll(arguments);
                previewResult.putAll(this.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
                this.generationHasOccurred = true;
            }
        }
        if (!this.generationHasOccurred && AcceleoPreferences.isDebugMessagesEnabled()) {
            AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoService.NoGenerationHasOccurred"), false);
        }
        this.generationHasOccurred = false;
        return previewResult;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, List<? extends Object> arguments, File generationRoot, boolean blockTraceability, Monitor monitor) {
        this.deactivateTraceability = blockTraceability;
        return this.doGenerate(module, templateName, model, arguments, generationRoot, monitor);
    }

    public Map<String, String> doGenerate(Template template, EObject model, File generationRoot, Monitor monitor) {
        if (template == null || model == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        if (template.getParameter().size() != 1) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.VoidArguments"));
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        if (argumentType.isInstance((Object)model)) {
            arguments.add(model);
            previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
            this.generationHasOccurred = true;
        }
        TreeIterator targetElements = model.eAllContents();
        while (targetElements.hasNext()) {
            EObject potentialTarget = (EObject)targetElements.next();
            if (!argumentType.isInstance((Object)potentialTarget)) continue;
            arguments.clear();
            arguments.add(potentialTarget);
            previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
            this.generationHasOccurred = true;
        }
        this.clearCaches();
        return previewResult;
    }

    public Map<String, String> doGenerateTemplate(Module module, String templateName, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Template> templates = this.findTemplates(module, templateName, arguments);
        for (Template template : templates) {
            result.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
        }
        return result;
    }

    public Map<String, String> doGenerateTemplate(Template template, List<? extends Object> arguments, File generationRoot, boolean blockTraceability, Monitor monitor) {
        this.deactivateTraceability = blockTraceability;
        return this.doGenerateTemplate(template, arguments, generationRoot, monitor);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> doGenerateTemplate(Template template, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        for (IAcceleoTextGenerationListener listener : AcceleoService.STATIC_LISTENERS) {
            this.generationEngine.addListener(listener);
        }
        descriptorsUsed = new ArrayList<AcceleoListenerDescriptor>();
        descriptors = AcceleoTraceabilityRegistryListenerUils.getListenerDescriptors();
        for (AcceleoListenerDescriptor acceleoListenerDescriptor : descriptors) {
            if (acceleoListenerDescriptor.getNature() == null) {
                descriptorsUsed.add(acceleoListenerDescriptor);
                continue;
            }
            if (!EMFPlugin.IS_ECLIPSE_RUNNING || generationRoot == null) continue;
            location = new Path(generationRoot.getAbsolutePath());
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
            if (iFile == null) continue;
            project = iFile.getProject();
            try {
                if (project == null || !project.isAccessible() || !project.hasNature(acceleoListenerDescriptor.getNature())) continue;
                descriptorsUsed.add(acceleoListenerDescriptor);
            }
            catch (CoreException e) {
                AcceleoEnginePlugin.log((Exception)e, false);
            }
        }
        forceTraceability = false;
        if (!this.deactivateTraceability) {
            for (AcceleoListenerDescriptor acceleoListenerDescriptor : descriptorsUsed) {
                listener = acceleoListenerDescriptor.getTraceabilityListener();
                if (listener instanceof AbstractAcceleoTextGenerationListener) {
                    textGenerationListener = (AbstractAcceleoTextGenerationListener)listener;
                    textGenerationListener.setGenerationID(this.generationID);
                }
                if (AcceleoPreferences.isTraceabilityEnabled() || !acceleoListenerDescriptor.isForceTraceability()) continue;
                AcceleoPreferences.switchTraceability((boolean)true);
                forceTraceability = true;
            }
            if (forceTraceability) {
                this.createEngine();
                for (IAcceleoTextGenerationListener listener : this.addedListeners) {
                    this.generationEngine.addListener(listener);
                }
                for (Map<String, String> properties : this.addedProperties) {
                    this.generationEngine.addProperties(properties);
                }
                for (String propertiesFiles : this.addedPropertiesfiles) {
                    this.generationEngine.addProperties(propertiesFiles);
                }
            }
        }
        var9_11 = descriptorsUsed.iterator();
        while (var9_11.hasNext()) {
            acceleoListenerDescriptor = (AcceleoListenerDescriptor)var9_11.next();
            this.generationEngine.addListener(acceleoListenerDescriptor.getTraceabilityListener());
        }
        try {
            var9_11 = this.generationEngine.evaluate(template, arguments, generationRoot, this.strategy, monitor);
            return var9_11;
        }
        finally {
            ** for (listener : AcceleoService.STATIC_LISTENERS)
        }
lbl-1000:
        // 1 sources

        {
            this.generationEngine.removeListener(listener);
            continue;
        }
lbl58:
        // 2 sources

        for (AcceleoListenerDescriptor acceleoListenerDescriptor : descriptorsUsed) {
            this.generationEngine.removeListener(acceleoListenerDescriptor.getTraceabilityListener());
        }
        if (forceTraceability == false) return var9_11;
        AcceleoPreferences.switchTraceability((boolean)false);
        return var9_11;
    }

    public void clearCaches() {
        this.addedListeners.clear();
        this.addedProperties.clear();
        this.addedPropertiesfiles.clear();
    }

    public void removeListener(IAcceleoTextGenerationListener listener) {
        this.generationEngine.removeListener(listener);
    }

    private void createEngine() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.generationEngine = new DefaultEngineSelector().selectEngine(AcceleoEngineRegistry.getRegisteredCreators());
        }
        if (this.generationEngine == null) {
            this.generationEngine = new AcceleoEngine();
        }
    }

    private List<Template> findTemplates(Module module, String templateName, int argumentCount) {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != argumentCount) continue;
            templates.add(template);
        }
        if (templates.isEmpty()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_TEMPLATE, templateName, module.getName()));
        }
        return templates;
    }

    private List<Template> findTemplates(Module module, String templateName, List<? extends Object> arguments) {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != arguments.size()) continue;
            boolean parameterMatch = true;
            int i = 0;
            while (i < template.getParameter().size()) {
                if (!((EClassifier)((Variable)template.getParameter().get(i)).getType()).isInstance(arguments.get(i))) {
                    parameterMatch = false;
                }
                ++i;
            }
            if (!parameterMatch) continue;
            templates.add(template);
        }
        if (templates.isEmpty()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_TEMPLATE, templateName, module.getName()));
        }
        return templates;
    }

    public void setGenerationID(String generationID) {
        this.generationID = generationID;
    }
}

