/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.IAcceleoParserProblemsConstants;
import org.eclipse.acceleo.internal.parser.ast.CST2ASTConverter;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.MacroInvocation;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.TemplateExpression;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.FileBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TraceBlock;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VoidType;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.StringLiteralExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CST2ASTConverterWithResolver
extends CST2ASTConverter {
    protected static final String DEPRECATED_QUERY_MESSAGE = "CST2ASTConverterWithResolver.DeprecatedQuery";
    protected static final String DEPRECATED_TEMPLATE_MESSAGE = "CST2ASTConverterWithResolver.DeprecatedTemplate";
    protected static final String DEPRECATED_MODULE_MESSAGE = "CST2ASTConverterWithResolver.DeprecatedModule";
    protected static final String DEPRECATED_MACRO_MESSAGE = "CST2ASTConverterWithResolver.DeprecatedMacro";
    private static final String UNAVAILABLE_CLAUSE_KEY = "CST2ASTConverterWithResolver.UnavailableClause";
    private static final String POSSIBLE_INCOMPATIBLE_TYPE = "CST2ASTConverterWithResolver.PossibleIncompatible";
    private int resolveBeginPosition = -1;
    private int resolveEndPosition = -1;

    public void resolveAST(org.eclipse.acceleo.parser.cst.Module rootCST) {
        this.resolveAST(rootCST, -1, -1);
    }

    public synchronized void resolveAST(org.eclipse.acceleo.parser.cst.Module rootCST, int beginPosition, int endPosition) {
        if (rootCST != null) {
            this.resolveBeginPosition = beginPosition;
            this.resolveEndPosition = endPosition;
            this.transformStepResolve(rootCST);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void transformStepResolve(org.eclipse.acceleo.parser.cst.Module iModule) {
        oModule = this.factory.getOrCreateModule(iModule);
        if (iModule != null && oModule != null && this.factory.getOCL() != null) {
            iInputIt = iModule.getInput().iterator();
            iInputList = new ArrayList<org.eclipse.acceleo.parser.cst.TypedModel>();
            while (iInputIt.hasNext()) {
                iNext = (org.eclipse.acceleo.parser.cst.TypedModel)iInputIt.next();
                this.transformStepResolveAddEPackage(iNext);
                found = false;
                for (org.eclipse.acceleo.parser.cst.TypedModel typedModel : iInputList) {
                    found = typedModel.getTakesTypesFrom().equals(iNext.getTakesTypesFrom());
                }
                if (found) {
                    this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ModuleAlreadyUsesMetaModels"), iNext.getStartPosition(), iNext.getEndPosition());
                }
                iInputList.add(iNext);
            }
            try {
                for (ModuleImportsValue ioNext : iModule.getImports()) {
                    oImportedModule = this.getModule(oModule.eResource(), ioNext.getName());
                    if (oImportedModule == null) {
                        this.logProblem(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.MissingModule", new Object[]{ioNext.getName()}), ioNext.getStartPosition(), ioNext.getEndPosition());
                        continue;
                    }
                    oModule.getImports().add((Object)oImportedModule);
                    this.checkModuleImports(oModule, ioNext.getStartPosition(), ioNext.getEndPosition());
                }
                for (ModuleExtendsValue ioNext : iModule.getExtends()) {
                    oExtendedModule = this.getModule(oModule.eResource(), ioNext.getName());
                    if (oExtendedModule == null) {
                        this.logProblem(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.MissingModule", new Object[]{ioNext.getName()}), ioNext.getStartPosition(), ioNext.getEndPosition());
                        continue;
                    }
                    oModule.getExtends().add((Object)oExtendedModule);
                    this.checkModuleExtends(oModule, ioNext.getStartPosition(), ioNext.getEndPosition());
                }
                this.factory.getOCL().addRecursivelyBehavioralFeaturesToScope(oModule);
                try {
                    this.transformStepResolveOwnedModuleElement(iModule);
                }
                catch (Throwable var7_11) {
                    this.factory.getOCL().removeRecursivelyBehavioralFeaturesToScope(oModule);
                    throw var7_11;
                }
                this.factory.getOCL().removeRecursivelyBehavioralFeaturesToScope(oModule);
            }
            finally {
                ** for (iNext : iModule.getInput())
            }
lbl-1000:
            // 1 sources

            {
                this.transformStepResolveRemoveEPackage(iNext);
                continue;
            }
        }
lbl49:
        // 3 sources

    }

    private void checkModuleImports(Module oModule, int startPosition, int endPosition) {
        EList imports = oModule.getImports();
        for (Module oImportedModule : imports) {
            if (oImportedModule.isDeprecated()) {
                this.logWarning(AcceleoParserMessages.getString(DEPRECATED_MODULE_MESSAGE, oImportedModule.getName()), startPosition, endPosition);
            }
            if (!this.isRecursiveImports(oModule, oImportedModule)) continue;
            this.logProblem(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.RecursiveModuleImports", oModule.getName(), oImportedModule.getName()), startPosition, endPosition);
        }
    }

    private void checkModuleExtends(Module oModule, int startPosition, int endPosition) {
        EList extendedModules = oModule.getExtends();
        for (Module oExtendedModule : extendedModules) {
            if (!this.isExtendsCompatible(oModule, oExtendedModule)) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ModuleExtendssIncompatibleModule", oExtendedModule.getName()), startPosition, endPosition);
            }
            if (this.isRecursiveExtends(oModule, oExtendedModule)) {
                this.logProblem(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.RecursiveModuleExtends", oModule.getName(), oExtendedModule.getName()), startPosition, endPosition);
            }
            if (!oExtendedModule.isDeprecated()) continue;
            this.logWarning(AcceleoParserMessages.getString(DEPRECATED_MODULE_MESSAGE, oExtendedModule.getName()), startPosition, endPosition);
        }
    }

    private boolean isExtendsCompatible(Module oModule, Module oExtendedModule) {
        EList extendInput = oExtendedModule.getInput();
        EList moduleInput = oModule.getInput();
        boolean hasCommonInput = false;
        for (TypedModel typedModel : moduleInput) {
            for (TypedModel extendTypedModel : extendInput) {
                EList takesTypesFrom = typedModel.getTakesTypesFrom();
                EList extendedTakesTypesFrom = extendTypedModel.getTakesTypesFrom();
                for (EPackage ePackage : takesTypesFrom) {
                    for (EPackage extendEPackage : extendedTakesTypesFrom) {
                        boolean bl = hasCommonInput = hasCommonInput || ePackage.getNsURI().equals(extendEPackage.getNsURI());
                    }
                }
            }
        }
        return hasCommonInput;
    }

    private boolean isRecursiveExtends(Module module, Module extendedModule) {
        boolean res = false;
        if (module != null && extendedModule != null) {
            if (module == extendedModule || EcoreUtil.getURI((EObject)module) != null && EcoreUtil.getURI((EObject)module).equals((Object)EcoreUtil.getURI((EObject)extendedModule))) {
                res = true;
            } else {
                for (Module extended : extendedModule.getExtends()) {
                    if (!this.isRecursiveExtends(module, extended)) continue;
                    res = true;
                    break;
                }
            }
        }
        return res;
    }

    private boolean isRecursiveImports(Module module, Module importedModule) {
        boolean res = false;
        if (module != null && importedModule != null) {
            if (module == importedModule || EcoreUtil.getURI((EObject)module) != null && EcoreUtil.getURI((EObject)module).equals((Object)EcoreUtil.getURI((EObject)importedModule))) {
                res = true;
            } else {
                for (Module imported : importedModule.getImports()) {
                    if (!this.isRecursiveImports(module, imported)) continue;
                    res = true;
                    break;
                }
            }
        }
        return res;
    }

    private Module getModule(Resource oResource, String fullModuleName) {
        if (oResource != null && fullModuleName != null) {
            for (Resource otherResource : oResource.getResourceSet().getResources()) {
                Module otherModule;
                if (otherResource.getContents().size() <= 0 || !(otherResource.getContents().get(0) instanceof Module) || !fullModuleName.equals((otherModule = (Module)otherResource.getContents().get(0)).getNsURI()) && !fullModuleName.equals(otherModule.getName())) continue;
                return otherModule;
            }
        }
        return null;
    }

    private Module getModule(EObject eObject) {
        EObject current = eObject;
        while (current != null) {
            if (current instanceof Module) {
                return (Module)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    private void transformStepResolveAddEPackage(org.eclipse.acceleo.parser.cst.TypedModel iTypedModel) {
        TypedModel oTypedModel = this.factory.getOrCreateTypedModel(iTypedModel);
        if (oTypedModel != null) {
            for (EPackage oNext : oTypedModel.getTakesTypesFrom()) {
                this.factory.getOCL().addMetamodel(oNext);
            }
        }
    }

    private void transformStepResolveRemoveEPackage(org.eclipse.acceleo.parser.cst.TypedModel iTypedModel) {
        TypedModel oTypedModel = this.factory.getOrCreateTypedModel(iTypedModel);
        if (oTypedModel != null) {
            for (EPackage oNext : oTypedModel.getTakesTypesFrom()) {
                this.factory.getOCL().removeMetamodel(oNext);
            }
        }
    }

    private void transformStepResolve(Template iTemplate) {
        org.eclipse.acceleo.model.mtl.Template oTemplate = this.factory.getOrCreateTemplate(iTemplate);
        if (iTemplate != null && oTemplate != null) {
            ArrayList<EClassifier> paramTypes = new ArrayList<EClassifier>();
            Iterator iParameterIt = iTemplate.getParameter().iterator();
            Variable oFirst = null;
            while (iParameterIt.hasNext()) {
                org.eclipse.acceleo.parser.cst.Variable iNext = (org.eclipse.acceleo.parser.cst.Variable)iParameterIt.next();
                if (iNext == null) continue;
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oFirst == null) {
                    oFirst = oNext;
                }
                this.transformStepResolveAddVariable(iNext);
                paramTypes.add((EClassifier)oNext.getType());
            }
            for (TemplateOverridesValue ioNext : iTemplate.getOverrides()) {
                List<org.eclipse.acceleo.model.mtl.Template> oOverrides = this.getExtendedTemplatesNamed(this.getModule((EObject)oTemplate), ioNext.getName(), paramTypes);
                if (oOverrides.size() == 0) {
                    this.logProblem(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.MissingTemplate", ioNext.getName()), ioNext.getStartPosition(), ioNext.getEndPosition());
                    continue;
                }
                for (org.eclipse.acceleo.model.mtl.Template template : oOverrides) {
                    if (!template.isDeprecated()) continue;
                    this.logWarning(AcceleoParserMessages.getString(DEPRECATED_TEMPLATE_MESSAGE, template.getName()), ioNext.getStartPosition(), ioNext.getEndPosition());
                    break;
                }
                for (org.eclipse.acceleo.model.mtl.Template template : oOverrides) {
                    if (template.eContainer() instanceof Module && oTemplate.eContainer() instanceof Module && EcoreUtil.getURI((EObject)template.eContainer()).equals((Object)EcoreUtil.getURI((EObject)oTemplate.eContainer()))) {
                        this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.OverrideTemplateInSameModule"), ioNext.getStartPosition(), ioNext.getEndPosition());
                        continue;
                    }
                    this.checkSameValueInOverrides(oTemplate, template, ioNext.getStartPosition(), ioNext.getEndPosition());
                    oTemplate.getOverrides().add((Object)template);
                }
            }
            if (oFirst != null && oFirst.getType() != null) {
                this.factory.getOCL().pushContext((EClassifier)oFirst.getType());
            }
            try {
                ModelExpression iGuard = iTemplate.getGuard();
                org.eclipse.ocl.ecore.OCLExpression oGuard = this.factory.getOrCreateOCLExpression(iGuard);
                if (oGuard != null) {
                    oTemplate.setGuard(oGuard);
                }
                this.transformStepResolve(iGuard);
                this.factory.getOCL().pushContext(this.getOCL().getStringType());
                try {
                    ModelExpression iPost = iTemplate.getPost();
                    org.eclipse.ocl.ecore.OCLExpression oPost = this.factory.getOrCreateOCLExpression(iPost);
                    if (oPost != null) {
                        oTemplate.setPost(oPost);
                    }
                    this.transformStepResolve(iPost);
                }
                finally {
                    this.factory.getOCL().popContext();
                }
                InitSection iInit = iTemplate.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iTemplate);
                this.transformStepResolveRemoveVariables(iInit);
                for (org.eclipse.acceleo.parser.cst.Variable iNext : iTemplate.getParameter()) {
                    this.transformStepResolveRemoveVariable(iNext);
                }
            }
            finally {
                if (oFirst != null && oFirst.getType() != null) {
                    this.factory.getOCL().popContext();
                }
            }
        }
    }

    private void checkSameValueInOverrides(org.eclipse.acceleo.model.mtl.Template oTemplate, org.eclipse.acceleo.model.mtl.Template template, int posBegin, int posEnd) {
        if (oTemplate.getOverrides() != null && oTemplate.getOverrides().contains((Object)template)) {
            this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.TemplateAlreadyOverride", template.getName()), posBegin, posEnd);
        }
    }

    private List<org.eclipse.acceleo.model.mtl.Template> getExtendedTemplatesNamed(Module oModule, String name, List<EClassifier> paramTypes) {
        ArrayList<org.eclipse.acceleo.model.mtl.Template> result = new ArrayList<org.eclipse.acceleo.model.mtl.Template>();
        if (oModule != null) {
            ArrayList<Module> allExtends = new ArrayList<Module>();
            this.computeAllExtends(allExtends, oModule);
            for (Module oOtherModule : allExtends) {
                result.addAll(this.getProtectedTemplatesNamed(oOtherModule, name, paramTypes));
            }
        }
        return result;
    }

    private List<org.eclipse.acceleo.model.mtl.Template> getProtectedTemplatesNamed(Module oModule, String name, List<EClassifier> paramTypes) {
        ArrayList<org.eclipse.acceleo.model.mtl.Template> result = new ArrayList<org.eclipse.acceleo.model.mtl.Template>();
        TreeIterator itObjects = oModule.eAllContents();
        while (itObjects.hasNext()) {
            org.eclipse.acceleo.model.mtl.Template otherTemplate;
            EObject eObject = (EObject)itObjects.next();
            if (!(eObject instanceof org.eclipse.acceleo.model.mtl.Template) || !this.checksName(name, (otherTemplate = (org.eclipse.acceleo.model.mtl.Template)eObject).getName(), oModule.getNsURI()) || paramTypes.size() != otherTemplate.getParameter().size() || otherTemplate.getVisibility().getValue() < 1) continue;
            boolean parameterMatches = true;
            Iterator<EClassifier> itTypes = paramTypes.iterator();
            Iterator itParameters = otherTemplate.getParameter().iterator();
            while (parameterMatches && itParameters.hasNext()) {
                EClassifier eParameterType = (EClassifier)((Variable)itParameters.next()).getType();
                EClassifier type = itTypes.next();
                if (eParameterType instanceof EClass && type instanceof EClass) {
                    parameterMatches = eParameterType == type || this.isSubTypeOf((EClass)eParameterType, (EClass)type);
                    continue;
                }
                boolean bl = parameterMatches = eParameterType == type || eParameterType != null && eParameterType.equals(type);
            }
            if (!parameterMatches) continue;
            result.add(otherTemplate);
        }
        return result;
    }

    private boolean checksName(String name, String otherTemplateName, String moduleNameSpace) {
        boolean result = name.equals(otherTemplateName);
        if (!result && moduleNameSpace != null && moduleNameSpace.contains("::")) {
            String otherTemplateQualifiedName = String.valueOf(moduleNameSpace) + "::" + otherTemplateName;
            result = name.equals(otherTemplateQualifiedName);
        }
        return result;
    }

    private void computeAllExtends(List<Module> allExtends, Module oModule) {
        ArrayList<Module> toBrowse = new ArrayList<Module>();
        for (Module oOtherModule : oModule.getExtends()) {
            if (allExtends.contains(oOtherModule)) continue;
            allExtends.add(oOtherModule);
            toBrowse.add(oOtherModule);
        }
        for (Module oOtherModule : toBrowse) {
            this.computeAllExtends(allExtends, oOtherModule);
        }
    }

    private void transformStepResolveAddVariable(org.eclipse.acceleo.parser.cst.Variable iVariable) {
        Variable oVariable = this.factory.getOrCreateVariable(iVariable);
        if (iVariable != null && oVariable != null) {
            ModelExpression iInitExpression = iVariable.getInitExpression();
            org.eclipse.ocl.ecore.OCLExpression oInitExpression = this.factory.getOrCreateOCLExpression(iInitExpression);
            if (oInitExpression != null) {
                oVariable.setInitExpression((OCLExpression)oInitExpression);
            }
            this.transformStepResolve(iInitExpression);
            this.factory.getOCL().addVariableToScope(oVariable);
            if (oVariable.getType() == null || oVariable.getType() == this.factory.getOCL().getInvalidType()) {
                EClassifier eClassifier = this.factory.getOCL().lookupClassifier(iVariable.getType());
                if (eClassifier != null) {
                    oVariable.setType((Object)eClassifier);
                } else {
                    this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TYPE_NOT_VALID) + iVariable.getType(), iVariable.getStartPosition(), iVariable.getEndPosition());
                }
            }
        }
    }

    private void transformStepResolveRemoveVariable(org.eclipse.acceleo.parser.cst.Variable iVariable) {
        Variable oVariable = this.factory.getOrCreateVariable(iVariable);
        if (iVariable != null && oVariable != null) {
            this.factory.getOCL().removeVariableFromScope(oVariable);
        }
    }

    private synchronized void transformStepResolve(ModelExpression iModelExpression) {
        if (!this.isValidRegion(iModelExpression)) {
            return;
        }
        org.eclipse.ocl.ecore.OCLExpression oOCLExpression = this.factory.getOrCreateOCLExpression(iModelExpression);
        if (iModelExpression != null && oOCLExpression != null) {
            MacroInvocation macroInvocation;
            ModelExpression iAfter;
            ModelExpression iEach;
            ModelExpression iBefore;
            TemplateExpression oTemplateExpression;
            if (oOCLExpression.eContainer() == null && (oTemplateExpression = this.factory.getTemporaryTemplateExpression(iModelExpression)) != null) {
                EcoreUtil.replace((EObject)oTemplateExpression, (EObject)oOCLExpression);
            }
            if (oOCLExpression instanceof OperationCallExp && ((OperationCallExp)oOCLExpression).getOperationCode() == 60) {
                OperationCallExp oOperationCallExp = (OperationCallExp)oOCLExpression;
                EList argument = oOperationCallExp.getArgument();
                OCLExpression source = oOperationCallExp.getSource();
                boolean sourceIsCollection = false;
                boolean argumentIsCollection = false;
                if (argument.size() > 0) {
                    OCLExpression expression = (OCLExpression)argument.get(0);
                    sourceIsCollection = CollectionType.class.isInstance(source.getType());
                    argumentIsCollection = CollectionType.class.isInstance(expression.getType());
                }
                if (sourceIsCollection && !argumentIsCollection || argumentIsCollection && !sourceIsCollection) {
                    this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.IncompatibleComparison", ((EClassifier)source.getType()).getName(), ((EClassifier)((OCLExpression)argument.get(0)).getType()).getName()), oOCLExpression.getStartPosition(), oOCLExpression.getEndPosition());
                }
            }
            if (oOCLExpression instanceof OperationCallExp && ((OperationCallExp)oOCLExpression).getReferredOperation() != null && "invoke".equals(((EOperation)((OperationCallExp)oOCLExpression).getReferredOperation()).getName())) {
                OperationCallExp operationCallExp = (OperationCallExp)oOCLExpression;
                EList arguments = operationCallExp.getArgument();
                if (arguments.size() > 0 && arguments.get(0) instanceof StringLiteralExp) {
                    StringLiteralExp stringLiteralExp = (StringLiteralExp)arguments.get(0);
                    String stringSymbol = stringLiteralExp.getStringSymbol();
                    this.logInfo("AcceleoParserInfo.SERVICE_INVOCATION" + stringSymbol, stringLiteralExp.getStartPosition(), stringLiteralExp.getEndPosition());
                }
                this.detectServiceInQueryReturningString(operationCallExp);
                this.detectServiceInTemplate(operationCallExp);
            }
            if (oOCLExpression instanceof TemplateInvocation) {
                TemplateInvocation oTemplateInvocation = (TemplateInvocation)oOCLExpression;
                this.transformStepResolveSuperTemplateInvocation(iModelExpression, oTemplateInvocation);
            }
            if ((iBefore = iModelExpression.getBefore()) != null) {
                if (oOCLExpression instanceof TemplateInvocation) {
                    org.eclipse.ocl.ecore.OCLExpression oBefore = this.factory.getOrCreateOCLExpression(iBefore);
                    ((TemplateInvocation)oOCLExpression).setBefore(oBefore);
                    this.transformStepResolve(iBefore);
                } else {
                    this.logProblem(AcceleoParserMessages.getString(UNAVAILABLE_CLAUSE_KEY, "before"), iBefore.getStartPosition(), iBefore.getEndPosition());
                }
            }
            if ((iEach = iModelExpression.getEach()) != null) {
                if (oOCLExpression instanceof TemplateInvocation) {
                    org.eclipse.ocl.ecore.OCLExpression oEach = this.factory.getOrCreateOCLExpression(iEach);
                    ((TemplateInvocation)oOCLExpression).setEach(oEach);
                    this.transformStepResolve(iEach);
                } else {
                    this.logProblem(AcceleoParserMessages.getString(UNAVAILABLE_CLAUSE_KEY, "separator"), iEach.getStartPosition(), iEach.getEndPosition());
                }
            }
            if ((iAfter = iModelExpression.getAfter()) != null) {
                if (oOCLExpression instanceof TemplateInvocation) {
                    org.eclipse.ocl.ecore.OCLExpression oAfter = this.factory.getOrCreateOCLExpression(iAfter);
                    ((TemplateInvocation)oOCLExpression).setAfter(oAfter);
                    this.transformStepResolve(iAfter);
                } else {
                    this.logProblem(AcceleoParserMessages.getString(UNAVAILABLE_CLAUSE_KEY, "after"), iAfter.getStartPosition(), iAfter.getEndPosition());
                }
            }
            if (oOCLExpression instanceof TemplateInvocation) {
                TemplateInvocation templateInvocation = (TemplateInvocation)oOCLExpression;
                if (templateInvocation.getDefinition() != null && templateInvocation.getDefinition().isDeprecated()) {
                    this.logWarning(AcceleoParserMessages.getString(DEPRECATED_TEMPLATE_MESSAGE, templateInvocation.getDefinition().getName()), templateInvocation.getStartPosition(), templateInvocation.getEndPosition());
                }
            } else if (oOCLExpression instanceof QueryInvocation) {
                QueryInvocation queryInvocation = (QueryInvocation)oOCLExpression;
                if (queryInvocation.getDefinition() != null && queryInvocation.getDefinition().isDeprecated()) {
                    this.logWarning(AcceleoParserMessages.getString(DEPRECATED_QUERY_MESSAGE, queryInvocation.getDefinition().getName()), queryInvocation.getStartPosition(), queryInvocation.getEndPosition());
                }
            } else if (oOCLExpression instanceof MacroInvocation && (macroInvocation = (MacroInvocation)oOCLExpression).getDefinition() != null && macroInvocation.getDefinition().isDeprecated()) {
                this.logWarning(AcceleoParserMessages.getString(DEPRECATED_MACRO_MESSAGE, macroInvocation.getDefinition().getName()), macroInvocation.getStartPosition(), macroInvocation.getEndPosition());
            }
        }
    }

    private void detectServiceInQueryReturningString(OperationCallExp operationCallExp) {
        if (operationCallExp.eContainer() instanceof Query && ((Query)operationCallExp.eContainer()).getParameter().size() > 0) {
            Query query = (Query)operationCallExp.eContainer();
            Variable variable = (Variable)query.getParameter().get(0);
            if (query.getType() != null && variable.getType() != null && String.class.equals((Object)query.getType().getInstanceClass()) && String.class.equals((Object)((EClassifier)variable.getType()).getInstanceClass())) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ServiceInQueryReturningAString"), query.getStartPosition(), query.getEndPosition());
            }
        }
    }

    private void detectServiceInTemplate(OperationCallExp operationCallExp) {
        EObject container = operationCallExp.eContainer();
        while (!(container instanceof ModuleElement)) {
            if (container.eContainer() == null) continue;
            container = container.eContainer();
        }
        if (container instanceof org.eclipse.acceleo.model.mtl.Template) {
            this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ServiceInTemplate"), operationCallExp.getStartPosition(), operationCallExp.getEndPosition());
        }
    }

    private void transformStepResolveSuperTemplateInvocation(ModelExpression iModelExpression, TemplateInvocation oTemplateInvocation) {
        if (oTemplateInvocation.isSuper() && oTemplateInvocation.getDefinition() == null) {
            org.eclipse.acceleo.model.mtl.Template oTemplate = this.getTemplate((EObject)oTemplateInvocation);
            if (oTemplate != null && oTemplate.getOverrides().size() == 0) {
                this.logProblem(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.InvalidClause", "super", "overrides"), iModelExpression.getStartPosition(), iModelExpression.getEndPosition());
            } else {
                oTemplateInvocation.setDefinition(oTemplate);
            }
        }
    }

    private org.eclipse.acceleo.model.mtl.Template getTemplate(EObject eObject) {
        EObject current = eObject;
        while (current != null) {
            if (current instanceof org.eclipse.acceleo.model.mtl.Template) {
                return (org.eclipse.acceleo.model.mtl.Template)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    private void transformStepResolve(TextExpression iTextExpression) {
    }

    private void transformStepResolve(Block iBlock) {
        org.eclipse.acceleo.model.mtl.Block oBlock = this.factory.getOrCreateBlock(iBlock);
        if (iBlock != null && oBlock != null) {
            InitSection iInit = iBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iBlock);
            this.transformStepResolveRemoveVariables(iInit);
        }
    }

    private void transformStepResolveAddVariables(InitSection iInitSection) {
        org.eclipse.acceleo.model.mtl.InitSection oInitSection = this.factory.getOrCreateInitSection(iInitSection);
        if (iInitSection != null && oInitSection != null) {
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iInitSection.getVariable()) {
                this.transformStepResolveAddVariable(iNext);
            }
        }
    }

    private void transformStepResolveRemoveVariables(InitSection iInitSection) {
        org.eclipse.acceleo.model.mtl.InitSection oInitSection = this.factory.getOrCreateInitSection(iInitSection);
        if (iInitSection != null && oInitSection != null) {
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iInitSection.getVariable()) {
                this.transformStepResolveRemoveVariable(iNext);
            }
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.ProtectedAreaBlock iProtectedAreaBlock) {
        ProtectedAreaBlock oProtectedAreaBlock = this.factory.getOrCreateProtectedAreaBlock(iProtectedAreaBlock);
        if (iProtectedAreaBlock != null && oProtectedAreaBlock != null) {
            String body;
            if (iProtectedAreaBlock.getMarker() != null && iProtectedAreaBlock.getMarker().getBody() != null && ("".equals(body = iProtectedAreaBlock.getMarker().getBody()) || "''".equals(body))) {
                this.logProblem(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ProtectedAreaMissingIdentifier"), iProtectedAreaBlock.getMarker().getStartPosition(), iProtectedAreaBlock.getMarker().getEndPosition());
            }
            this.checkNameConflict(iProtectedAreaBlock);
            ModelExpression iMarker = iProtectedAreaBlock.getMarker();
            org.eclipse.ocl.ecore.OCLExpression oMarker = this.factory.getOrCreateOCLExpression(iMarker);
            if (oMarker != null) {
                oProtectedAreaBlock.setMarker(oMarker);
            }
            this.transformStepResolve(iMarker);
            InitSection iInit = iProtectedAreaBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iProtectedAreaBlock);
            this.transformStepResolveRemoveVariables(iInit);
            if (oProtectedAreaBlock.getBody() != null && oProtectedAreaBlock.getBody().size() > 0) {
                int initEndPosition = ((org.eclipse.ocl.ecore.OCLExpression)oProtectedAreaBlock.getBody().get(0)).getStartPosition();
                if (this.astProvider instanceof AcceleoSourceBuffer) {
                    AcceleoSourceBuffer buffer = (AcceleoSourceBuffer)this.astProvider;
                    this.parseWhitespaceAfterProtectedArea(buffer, initEndPosition, "\n");
                    this.parseWhitespaceAfterProtectedArea(buffer, initEndPosition, "\r\n");
                    this.parseWhitespaceAfterProtectedArea(buffer, initEndPosition, "\r");
                }
            }
        }
    }

    private void parseWhitespaceAfterProtectedArea(AcceleoSourceBuffer buffer, int startPosition, String delimiter) {
        int startNonWhiteSpace = -1;
        int endNonWhiteSpace = -1;
        StringBuffer strBuffer = buffer.getBuffer();
        int indexOfLineDelimiter = strBuffer.indexOf(delimiter, startPosition);
        if (indexOfLineDelimiter != strBuffer.length()) {
            char charAt;
            int i = startPosition;
            while (i < indexOfLineDelimiter) {
                charAt = strBuffer.charAt(i);
                if (!Character.isWhitespace(charAt)) {
                    startNonWhiteSpace = i;
                    break;
                }
                ++i;
            }
            if (startNonWhiteSpace != -1) {
                i = startNonWhiteSpace;
                while (i < indexOfLineDelimiter) {
                    charAt = strBuffer.charAt(i);
                    if (Character.isWhitespace(charAt)) {
                        endNonWhiteSpace = i;
                        break;
                    }
                    ++i;
                }
            }
            if (startNonWhiteSpace != -1 && endNonWhiteSpace == -1) {
                endNonWhiteSpace = indexOfLineDelimiter;
            }
            if (startNonWhiteSpace != -1 && endNonWhiteSpace != -1) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.TextAfterProtectedAreaMarker"), startNonWhiteSpace, endNonWhiteSpace);
            }
        }
    }

    private void checkNameConflict(org.eclipse.acceleo.parser.cst.ProtectedAreaBlock iProtectedArea) {
        if (iProtectedArea.getMarker() == null) {
            return;
        }
        String protectedAreaName = iProtectedArea.getMarker().getBody();
        EObject scopeContainer = this.getScopeContainer(iProtectedArea);
        ArrayList<org.eclipse.acceleo.parser.cst.ProtectedAreaBlock> protectedAreas = new ArrayList<org.eclipse.acceleo.parser.cst.ProtectedAreaBlock>();
        TreeIterator children = scopeContainer.eAllContents();
        while (children.hasNext()) {
            org.eclipse.acceleo.parser.cst.ProtectedAreaBlock protectedAreaBlock;
            EObject child = (EObject)children.next();
            if (!(child instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) || !this.getScopeContainer(protectedAreaBlock = (org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)child).equals(scopeContainer)) continue;
            protectedAreas.add(protectedAreaBlock);
        }
        ArrayList<org.eclipse.acceleo.parser.cst.ProtectedAreaBlock> conflictList = new ArrayList<org.eclipse.acceleo.parser.cst.ProtectedAreaBlock>();
        for (org.eclipse.acceleo.parser.cst.ProtectedAreaBlock protectedAreaBlock : protectedAreas) {
            if (protectedAreaBlock.equals(iProtectedArea) || protectedAreaBlock.getMarker() == null || !protectedAreaBlock.getMarker().getBody().equals(protectedAreaName)) continue;
            conflictList.add(protectedAreaBlock);
        }
        if (!conflictList.isEmpty()) {
            for (org.eclipse.acceleo.parser.cst.ProtectedAreaBlock protectedAreaBlock : conflictList) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ProtectedAreaConflict"), protectedAreaBlock.getMarker().getStartPosition(), protectedAreaBlock.getMarker().getEndPosition());
            }
        }
    }

    private EObject getScopeContainer(org.eclipse.acceleo.parser.cst.ProtectedAreaBlock iProtectedArea) {
        EObject container = iProtectedArea.eContainer();
        while (container != null && !(container instanceof Template) && !(container instanceof FileBlock)) {
            container = container.eContainer();
        }
        return container;
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.ForBlock iForBlock) {
        ForBlock oForBlock = this.factory.getOrCreateForBlock(iForBlock);
        if (iForBlock != null && oForBlock != null) {
            ModelExpression iIterSet = iForBlock.getIterSet();
            org.eclipse.ocl.ecore.OCLExpression oIterSet = this.factory.getOrCreateOCLExpression(iIterSet);
            if (oIterSet != null) {
                oForBlock.setIterSet(oIterSet);
            }
            this.transformStepResolve(iIterSet);
            ModelExpression iBefore = iForBlock.getBefore();
            org.eclipse.ocl.ecore.OCLExpression oBefore = this.factory.getOrCreateOCLExpression(iBefore);
            if (oBefore != null) {
                oForBlock.setBefore(oBefore);
            }
            this.transformStepResolve(iBefore);
            ModelExpression iEach = iForBlock.getEach();
            org.eclipse.ocl.ecore.OCLExpression oEach = this.factory.getOrCreateOCLExpression(iEach);
            if (oEach != null) {
                oForBlock.setEach(oEach);
            }
            this.transformStepResolve(iEach);
            ModelExpression iAfter = iForBlock.getAfter();
            org.eclipse.ocl.ecore.OCLExpression oAfter = this.factory.getOrCreateOCLExpression(iAfter);
            if (oAfter != null) {
                oForBlock.setAfter(oAfter);
            }
            this.transformStepResolve(iAfter);
            org.eclipse.acceleo.parser.cst.Variable iLoopVariable = iForBlock.getLoopVariable();
            Variable oLoopVariable = iLoopVariable != null ? this.factory.getOrCreateVariable(iLoopVariable) : null;
            EClassifier context = null;
            if (iLoopVariable != null && oLoopVariable != null) {
                this.transformStepResolveAddVariable(iLoopVariable);
                context = (EClassifier)oLoopVariable.getType();
            } else if (oIterSet != null && (context = oIterSet.getEType()) instanceof CollectionType) {
                context = (EClassifier)((CollectionType)context).getElementType();
            }
            if (context != null) {
                this.factory.getOCL().pushContext(context);
            }
            Variable iterationCount = null;
            if (oLoopVariable == null || !"i".equals(oLoopVariable.getName())) {
                iterationCount = EcoreFactory.eINSTANCE.createVariable();
                iterationCount.setName("i");
                iterationCount.setType((Object)this.factory.getOCL().getIntegerType());
                this.factory.getOCL().addVariableToScope(iterationCount);
            }
            try {
                ModelExpression iGuard = iForBlock.getGuard();
                org.eclipse.ocl.ecore.OCLExpression oGuard = this.factory.getOrCreateOCLExpression(iGuard);
                if (oGuard != null) {
                    oForBlock.setGuard(oGuard);
                }
                this.transformStepResolve(iGuard);
                InitSection iInit = iForBlock.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iForBlock);
                this.transformStepResolveRemoveVariables(iInit);
                if (oLoopVariable != null && oLoopVariable.getType() != null && oIterSet != null && oIterSet.getType() != null && !this.compatibleVariableTypeFor(oLoopVariable, oIterSet)) {
                    this.logWarning(AcceleoParserMessages.getString(POSSIBLE_INCOMPATIBLE_TYPE, ((EClassifier)oLoopVariable.getType()).getName(), ((EClassifier)oIterSet.getType()).getName()), oLoopVariable.getStartPosition(), oIterSet.getEndPosition());
                }
            }
            finally {
                if (iLoopVariable != null && oLoopVariable != null) {
                    this.transformStepResolveRemoveVariable(iLoopVariable);
                }
                if (context != null) {
                    this.factory.getOCL().popContext();
                }
                if (iterationCount != null) {
                    this.factory.getOCL().removeVariableFromScope(iterationCount);
                }
            }
        }
    }

    private boolean compatibleVariableTypeFor(Variable oForVariable, org.eclipse.ocl.ecore.OCLExpression oIterSet) {
        boolean invalidInitType;
        boolean result = false;
        EClassifier initType = (EClassifier)oIterSet.getType();
        EClassifier variableType = (EClassifier)oForVariable.getType();
        if (initType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)initType;
            initType = (EClassifier)collectionType.getElementType();
        }
        boolean bl = invalidInitType = initType == null || initType.eIsProxy();
        if (oForVariable.eIsProxy() || oIterSet.eIsProxy() || invalidInitType || variableType.eIsProxy()) {
            return true;
        }
        if (initType != null && initType.getInstanceClass() != null && variableType.getInstanceClass() != null) {
            result = variableType.getInstanceClass().isAssignableFrom(initType.getInstanceClass());
        } else if (variableType instanceof AnyType) {
            result = true;
        } else if (initType instanceof VoidType) {
            result = true;
        }
        if (!result) {
            result = EcoreUtil.equals((EObject)variableType, (EObject)initType);
        }
        if (!result && variableType instanceof EClass && initType instanceof EClass) {
            result = ((EClass)variableType).isSuperTypeOf((EClass)initType);
        }
        return result;
    }

    private void transformStepResolve(IfBlock iIfBlock) {
        org.eclipse.acceleo.model.mtl.IfBlock oIfBlock = this.factory.getOrCreateIfBlock(iIfBlock);
        if (iIfBlock != null && oIfBlock != null) {
            ModelExpression iIfExpr = iIfBlock.getIfExpr();
            org.eclipse.ocl.ecore.OCLExpression oIfExpr = this.factory.getOrCreateOCLExpression(iIfExpr);
            if (oIfExpr != null) {
                oIfBlock.setIfExpr(oIfExpr);
                if (oIfExpr.getType() != null && oIfExpr.getType() != this.getOCL().getOCLEnvironment().getOCLStandardLibrary().getBoolean()) {
                    this.logProblem(AcceleoParserMessages.getString("IAcceleoParserProblemsConstants.InvalidExprType", ((EClassifier)oIfExpr.getType()).getName()), oIfExpr.getStartPosition(), oIfExpr.getEndPosition());
                }
            }
            this.transformStepResolve(iIfExpr);
            InitSection iInit = iIfBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iIfBlock);
            this.transformStepResolveRemoveVariables(iInit);
            for (IfBlock iNext : iIfBlock.getElseIf()) {
                this.transformStepResolve(iNext);
            }
            Block iElse = iIfBlock.getElse();
            if (iElse instanceof Template) {
                this.transformStepResolve((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                this.transformStepResolve((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                this.transformStepResolve((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                this.transformStepResolve((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                this.transformStepResolve(iElse);
            }
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.LetBlock iLetBlock) {
        LetBlock oLetBlock = this.factory.getOrCreateLetBlock(iLetBlock);
        if (iLetBlock != null && oLetBlock != null) {
            Block iElse;
            org.eclipse.acceleo.parser.cst.Variable iLetVariable = iLetBlock.getLetVariable();
            Variable oLetVariable = iLetVariable != null ? this.factory.getOrCreateVariable(iLetVariable) : null;
            OCLExpression saveInitExpression = null;
            if (iLetVariable != null && oLetVariable != null) {
                this.transformStepResolveAddVariable(iLetVariable);
                saveInitExpression = oLetVariable.getInitExpression();
                if (saveInitExpression != null) {
                    oLetVariable.setInitExpression(null);
                }
            }
            try {
                InitSection iInit = iLetBlock.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iLetBlock);
                this.transformStepResolveRemoveVariables(iInit);
            }
            catch (Throwable throwable) {
                if (iLetVariable != null && oLetVariable != null) {
                    this.transformStepResolveRemoveVariable(iLetVariable);
                    if (saveInitExpression != null) {
                        oLetVariable.setInitExpression(saveInitExpression);
                    }
                    if (oLetVariable.getType() != null && oLetVariable.getInitExpression() != null && oLetVariable.getInitExpression().getType() != null && !this.compatibleVariableTypeLet(oLetVariable)) {
                        this.logWarning(AcceleoParserMessages.getString(POSSIBLE_INCOMPATIBLE_TYPE, ((EClassifier)oLetVariable.getType()).getName(), ((EClassifier)oLetVariable.getInitExpression().getType()).getName()), oLetVariable.getStartPosition(), oLetVariable.getInitExpression().getEndPosition());
                    }
                }
                throw throwable;
            }
            if (iLetVariable != null && oLetVariable != null) {
                this.transformStepResolveRemoveVariable(iLetVariable);
                if (saveInitExpression != null) {
                    oLetVariable.setInitExpression(saveInitExpression);
                }
                if (oLetVariable.getType() != null && oLetVariable.getInitExpression() != null && oLetVariable.getInitExpression().getType() != null && !this.compatibleVariableTypeLet(oLetVariable)) {
                    this.logWarning(AcceleoParserMessages.getString(POSSIBLE_INCOMPATIBLE_TYPE, ((EClassifier)oLetVariable.getType()).getName(), ((EClassifier)oLetVariable.getInitExpression().getType()).getName()), oLetVariable.getStartPosition(), oLetVariable.getInitExpression().getEndPosition());
                }
            }
            if ((iElse = iLetBlock.getElse()) instanceof Template) {
                this.transformStepResolve((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                this.transformStepResolve((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                this.transformStepResolve((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                this.transformStepResolve((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                this.transformStepResolve(iElse);
            }
            for (org.eclipse.acceleo.parser.cst.LetBlock iNext : iLetBlock.getElseLet()) {
                this.transformStepResolve(iNext);
            }
        }
    }

    private boolean compatibleVariableTypeLet(Variable oLetVariable) {
        boolean invalidInitType;
        boolean result = false;
        EClassifier initType = (EClassifier)oLetVariable.getInitExpression().getType();
        EClassifier variableType = (EClassifier)oLetVariable.getType();
        EClassifier oclAny = (EClassifier)this.getOCL().getOCLEnvironment().getOCLStandardLibrary().getOclAny();
        EClassifier oclVoid = (EClassifier)this.getOCL().getOCLEnvironment().getOCLStandardLibrary().getOclVoid();
        boolean bl = invalidInitType = initType == null || initType.eIsProxy();
        if (oLetVariable.eIsProxy() || invalidInitType || variableType.eIsProxy()) {
            return true;
        }
        if (initType != null && initType.getInstanceClass() != null && variableType.getInstanceClass() != null) {
            result = initType.getInstanceClass().isAssignableFrom(variableType.getInstanceClass());
        } else if (variableType == oclAny) {
            result = true;
        } else if (initType == oclVoid) {
            result = true;
        }
        if (!result) {
            result = EcoreUtil.equals((EObject)variableType, (EObject)initType);
        }
        if (!result && variableType instanceof EClass && initType instanceof EClass) {
            result = ((EClass)variableType).isSuperTypeOf((EClass)initType);
        }
        return result;
    }

    private void transformStepResolve(FileBlock iFileBlock) {
        org.eclipse.acceleo.model.mtl.FileBlock oFileBlock = this.factory.getOrCreateFileBlock(iFileBlock);
        if (iFileBlock != null && oFileBlock != null) {
            ModelExpression iFileUrl = iFileBlock.getFileUrl();
            org.eclipse.ocl.ecore.OCLExpression oFileUrl = this.factory.getOrCreateOCLExpression(iFileUrl);
            if (oFileUrl != null) {
                oFileBlock.setFileUrl(oFileUrl);
                if (oFileUrl.getEType() != null && !oFileUrl.getEType().equals(this.getOCL().getStringType())) {
                    this.logProblem(AcceleoParserMessages.getString("IAcceleoParserProblemsConstants.InvalidUrlType", oFileUrl.getEType().getName()), oFileUrl.getStartPosition(), oFileUrl.getEndPosition());
                }
            }
            this.transformStepResolve(iFileUrl);
            ModelExpression iFileCharset = iFileBlock.getCharset();
            org.eclipse.ocl.ecore.OCLExpression oFileCharset = this.factory.getOrCreateOCLExpression(iFileCharset);
            if (oFileCharset != null) {
                oFileBlock.setCharset(oFileCharset);
            }
            this.transformStepResolve(iFileCharset);
            InitSection iInit = iFileBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iFileBlock);
            this.transformStepResolveRemoveVariables(iInit);
        }
    }

    private void transformStepResolve(TraceBlock iTraceBlock) {
        org.eclipse.acceleo.model.mtl.TraceBlock oTraceBlock = this.factory.getOrCreateTraceBlock(iTraceBlock);
        if (iTraceBlock != null && oTraceBlock != null) {
            ModelExpression iModelElement = iTraceBlock.getModelElement();
            org.eclipse.ocl.ecore.OCLExpression oModelElement = this.factory.getOrCreateOCLExpression(iModelElement);
            if (oModelElement != null) {
                oTraceBlock.setModelElement(oModelElement);
            }
            this.transformStepResolve(iModelElement);
            InitSection iInit = iTraceBlock.getInit();
            this.transformStepResolveAddVariables(iInit);
            this.transformStepResolveBody(iTraceBlock);
            this.transformStepResolveRemoveVariables(iInit);
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.Macro iMacro) {
        Macro oMacro = this.factory.getOrCreateMacro(iMacro);
        if (iMacro != null && oMacro != null) {
            Iterator iParameterIt = iMacro.getParameter().iterator();
            Variable oFirst = null;
            while (iParameterIt.hasNext()) {
                org.eclipse.acceleo.parser.cst.Variable iNext = (org.eclipse.acceleo.parser.cst.Variable)iParameterIt.next();
                if (oFirst == null && iNext != null) {
                    oFirst = this.factory.getOrCreateVariable(iNext);
                }
                this.transformStepResolveAddVariable(iNext);
            }
            if (oFirst != null && oFirst.getType() != null) {
                this.factory.getOCL().pushContext((EClassifier)oFirst.getType());
            }
            try {
                InitSection iInit = iMacro.getInit();
                this.transformStepResolveAddVariables(iInit);
                this.transformStepResolveBody(iMacro);
                for (org.eclipse.acceleo.parser.cst.Variable iNext : iMacro.getParameter()) {
                    this.transformStepResolveRemoveVariable(iNext);
                }
                this.transformStepResolveRemoveVariables(iInit);
            }
            finally {
                if (oFirst != null && oFirst.getType() != null) {
                    this.factory.getOCL().popContext();
                }
            }
            if (oMacro.getType() == null || oMacro.getType() == this.factory.getOCL().getInvalidType()) {
                EClassifier eClassifier = this.factory.getOCL().lookupClassifier(iMacro.getType());
                if (eClassifier != null) {
                    oMacro.setType(eClassifier);
                } else {
                    this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TYPE_NOT_VALID) + iMacro.getType(), iMacro.getStartPosition(), iMacro.getEndPosition());
                }
            }
        }
    }

    private void transformStepResolve(org.eclipse.acceleo.parser.cst.Query iQuery) {
        Query oQuery = this.factory.getOrCreateQuery(iQuery);
        if (iQuery != null && oQuery != null) {
            Iterator iParameterIt = iQuery.getParameter().iterator();
            Variable oFirst = null;
            while (iParameterIt.hasNext()) {
                org.eclipse.acceleo.parser.cst.Variable iNext = (org.eclipse.acceleo.parser.cst.Variable)iParameterIt.next();
                if (oFirst == null && iNext != null) {
                    oFirst = this.factory.getOrCreateVariable(iNext);
                }
                this.transformStepResolveAddVariable(iNext);
            }
            if (oFirst != null && oFirst.getType() != null) {
                this.factory.getOCL().pushContext((EClassifier)oFirst.getType());
            }
            try {
                ModelExpression iExpression = iQuery.getExpression();
                org.eclipse.ocl.ecore.OCLExpression oExpression = this.factory.getOrCreateOCLExpression(iExpression);
                if (oExpression != null) {
                    oQuery.setExpression(oExpression);
                }
                this.transformStepResolve(iExpression);
                for (org.eclipse.acceleo.parser.cst.Variable iNext : iQuery.getParameter()) {
                    this.transformStepResolveRemoveVariable(iNext);
                }
                org.eclipse.ocl.ecore.OCLExpression oOCLExpression = oQuery.getExpression();
                if (oOCLExpression instanceof OperationCallExp && ((OperationCallExp)oOCLExpression).getReferredOperation() != null && "invoke".equals(((EOperation)((OperationCallExp)oOCLExpression).getReferredOperation()).getName())) {
                    this.detectServiceInQueryReturningString((OperationCallExp)oOCLExpression);
                }
            }
            finally {
                if (oFirst != null && oFirst.getType() != null) {
                    this.factory.getOCL().popContext();
                }
            }
            if (oQuery.getType() == null || oQuery.getType() == this.factory.getOCL().getInvalidType()) {
                EClassifier eClassifier = this.factory.getOCL().lookupClassifier(iQuery.getType());
                if (eClassifier != null) {
                    oQuery.setType(eClassifier);
                } else {
                    this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TYPE_NOT_VALID) + iQuery.getType(), iQuery.getStartPosition(), iQuery.getEndPosition());
                }
            }
            if (oQuery.getType() != null && oQuery.getExpression() != null && oQuery.getExpression().getType() != null) {
                EClassifier queryType = oQuery.getType();
                EClassifier expressionType = (EClassifier)oQuery.getExpression().getType();
                if (queryType.getInstanceClass() != null && expressionType.getInstanceClass() != null && !queryType.getInstanceClass().isAssignableFrom(expressionType.getInstanceClass())) {
                    this.logWarning(AcceleoParserMessages.getString(POSSIBLE_INCOMPATIBLE_TYPE, queryType.getName(), expressionType.getName()), oQuery.getStartPosition(), oQuery.getEndPosition());
                }
            }
        }
    }

    private void transformStepResolveOwnedModuleElement(org.eclipse.acceleo.parser.cst.Module iModule) {
        if (!this.isCanceled) {
            for (org.eclipse.acceleo.parser.cst.ModuleElement iNext : iModule.getOwnedModuleElement()) {
                if (!this.isValidRegion(iNext)) continue;
                if (iNext instanceof Template) {
                    this.transformStepResolve((Template)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    continue;
                }
                if (!(iNext instanceof org.eclipse.acceleo.parser.cst.Query)) continue;
                this.transformStepResolve((org.eclipse.acceleo.parser.cst.Query)iNext);
            }
        }
    }

    private void transformStepResolveBody(Block iBlock) {
        if (!this.isCanceled) {
            for (org.eclipse.acceleo.parser.cst.TemplateExpression iNext : iBlock.getBody()) {
                if (!this.isValidRegion(iNext)) continue;
                if (iNext instanceof Template) {
                    this.transformStepResolve((Template)iNext);
                    continue;
                }
                if (iNext instanceof ModelExpression) {
                    this.transformStepResolve((ModelExpression)iNext);
                    continue;
                }
                if (iNext instanceof TextExpression) {
                    this.transformStepResolve((TextExpression)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.ForBlock)iNext);
                    continue;
                }
                if (iNext instanceof IfBlock) {
                    this.transformStepResolve((IfBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.LetBlock)iNext);
                    continue;
                }
                if (iNext instanceof FileBlock) {
                    this.transformStepResolve((FileBlock)iNext);
                    continue;
                }
                if (iNext instanceof TraceBlock) {
                    this.transformStepResolve((TraceBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    this.transformStepResolve((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    continue;
                }
                if (iNext instanceof Block) {
                    this.transformStepResolve((Block)iNext);
                    continue;
                }
                if (iNext instanceof Comment) continue;
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID) + ' ' + iNext.getClass().getName(), iNext.getStartPosition(), iNext.getEndPosition());
            }
        }
    }

    private boolean isValidRegion(CSTNode iNext) {
        if (iNext != null) {
            return !(this.resolveBeginPosition != -1 && this.resolveBeginPosition < iNext.getStartPosition() || this.resolveEndPosition != -1 && this.resolveEndPosition > iNext.getEndPosition());
        }
        return false;
    }

    private boolean isSubTypeOf(EClass superType, EClass eClass) {
        for (EClass candidate : eClass.getEAllSuperTypes()) {
            if (candidate != superType) continue;
            return true;
        }
        return false;
    }
}

