/*******************************************************************************
 * Copyright (c) 2008, 2011 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import org.eclipse.acceleo.common.IAcceleoConstants;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.swt.SWT;

/**
 * A scanner for detecting 'documentation' sequences.
 * 
 * @author <a href="mailto:stephane.begaudeau@obeo.fr">Stephane Begaudeau</a>
 */
public class AcceleoDocumentationScanner extends AbstractAcceleoScanner {
	/**
	 * Instantiates our scanner given the preference lookup order.
	 * 
	 * @param lookupOrder
	 *            Order in which to look preferences up.
	 */
	public AcceleoDocumentationScanner(IEclipsePreferences[] lookupOrder) {
		super(lookupOrder);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner#createRules()
	 */
	@Override
	protected void createRules() {
		// indices declaration, viva checkstyle
		final int seven = 7;
		final int eight = 8;
		final int nine = 9;

		IRule[] rules = new IRule[nine];
		rules[0] = new KeywordRule(IAcceleoConstants.TAG_AUTHOR, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[1] = new KeywordRule(IAcceleoConstants.TAG_DEPRECATED, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[2] = new KeywordRule(IAcceleoConstants.TAG_INHERITDOC, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[3] = new KeywordRule(IAcceleoConstants.TAG_PARAM, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[4] = new KeywordRule(IAcceleoConstants.TAG_SINCE, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[5] = new KeywordRule(IAcceleoConstants.TAG_VERSION, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[6] = new KeywordRule(IAcceleoConstants.TAG_FIXME, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[seven] = new KeywordRule(IAcceleoConstants.TAG_TODO, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		rules[eight] = new KeywordRule(IAcceleoConstants.TAG_MAIN, true, false, createToken(
				AcceleoColor.COMMENT, null, SWT.BOLD));
		setRules(rules);
		setDefaultReturnToken(createToken(AcceleoColor.COMMENT));
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.acceleo.ide.ui.editors.template.scanner.AbstractAcceleoScanner#getConfiguredContentType()
	 */
	@Override
	public String getConfiguredContentType() {
		return AcceleoPartitionScanner.ACCELEO_DOCUMENTATION;
	}
}
