/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.resource.AcceleoResourceSetImpl;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParserInfos;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoParserWarnings;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoParser {
    private final Map<File, AcceleoParserProblems> problems = new HashMap<File, AcceleoParserProblems>();
    private final Map<File, AcceleoParserWarnings> warnings = new HashMap<File, AcceleoParserWarnings>();
    private final Map<File, AcceleoParserInfos> infos = new HashMap<File, AcceleoParserInfos>();
    private boolean asBinaryResource;

    public AcceleoParser() {
    }

    public AcceleoParser(boolean asBinaryResource) {
        this.asBinaryResource = asBinaryResource;
    }

    public void parse(List<File> inputFiles, List<URI> outputURIs, List<URI> dependenciesURIs) {
        ArrayList<AcceleoFile> acceleoFiles = new ArrayList<AcceleoFile>();
        for (File inputFile : inputFiles) {
            acceleoFiles.add(new AcceleoFile(inputFile, AcceleoFile.simpleModuleName(inputFile)));
        }
        this.parse(acceleoFiles, outputURIs, dependenciesURIs, (Monitor)new BasicMonitor());
    }

    public void parse(List<AcceleoFile> acceleoFiles, List<URI> outputURIs, List<URI> dependenciesURIs, Monitor monitor) {
        this.parse(acceleoFiles, outputURIs, dependenciesURIs, null, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public void parse(List<AcceleoFile> acceleoFiles, List<URI> outputURIs, List<URI> dependenciesURIs, Map<URI, URI> mapURIs, Monitor monitor) {
        monitor.beginTask(AcceleoParserMessages.getString("AcceleoParser.ParseFiles", new Object[]{acceleoFiles.size()}), acceleoFiles.size() * 3);
        oResourceSet = new AcceleoResourceSetImpl();
        oResourceSet.setPackageRegistry((EPackage.Registry)AcceleoPackageRegistry.INSTANCE);
        newResources = new ArrayList<Resource>();
        sources = new ArrayList<AcceleoSourceBuffer>();
        itOutputURIs = outputURIs.iterator();
        allImportedFiles = new CompactHashSet();
        itAcceleoFiles = acceleoFiles.iterator();
        while (!monitor.isCanceled() && itAcceleoFiles.hasNext() && itOutputURIs.hasNext()) {
            acceleoFile = itAcceleoFiles.next();
            monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.ParseFileCST", new Object[]{acceleoFile.getMtlFile().getName()}));
            oURI = itOutputURIs.next();
            source = new AcceleoSourceBuffer(acceleoFile);
            sources.add(source);
            oResource = this.createResource(oURI, (ResourceSet)oResourceSet);
            newResources.add(oResource);
            source.createCST();
            for (ModuleImportsValue importValue : source.getCST().getImports()) {
                importedFileName = importValue.getName();
                if (importedFileName == null) continue;
                lastSegment = importedFileName.lastIndexOf("::");
                if (lastSegment > -1) {
                    importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
                }
                allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
            }
            for (ModuleExtendsValue extendValue : source.getCST().getExtends()) {
                importedFileName = extendValue.getName();
                if (importedFileName == null) continue;
                lastSegment = importedFileName.lastIndexOf("::");
                if (lastSegment > -1) {
                    importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
                }
                allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
            }
            source.createAST(oResource);
            monitor.worked(1);
        }
        itDependenciesURIs = dependenciesURIs.iterator();
        block5: while (!monitor.isCanceled() && itDependenciesURIs.hasNext()) {
            oURI = itDependenciesURIs.next();
            if (outputURIs.contains(oURI) || !allImportedFiles.contains(oURI.lastSegment())) continue;
            try {
                ModelUtils.load((URI)oURI, (ResourceSet)oResourceSet);
                continue;
            }
            catch (IOException e) {
                iterator = sources.iterator();
                ** while (iterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                ((AcceleoSourceBuffer)iterator.next()).logProblem(AcceleoParserMessages.getString("AcceleoParser.Error.InvalidAST", new Object[]{oURI.lastSegment()}), 0, -1);
                continue;
lbl54:
                // 1 sources

            }
        }
        this.resolveAST((ResourceSet)oResourceSet, mapURIs, sources, monitor);
    }

    private void resolveAST(ResourceSet oResourceSet, Map<URI, URI> mapURIs, List<AcceleoSourceBuffer> sources, Monitor monitor) {
        Object source;
        Iterator<AcceleoSourceBuffer> itSources = sources.iterator();
        while (!monitor.isCanceled() && itSources.hasNext()) {
            source = itSources.next();
            if (((AcceleoSourceBuffer)source).getFile() != null) {
                monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.ParseFileAST", ((AcceleoSourceBuffer)source).getFile().getName()));
            }
            ((AcceleoSourceBuffer)source).resolveAST();
            ((AcceleoSourceBuffer)source).resolveASTDocumentation();
            monitor.worked(1);
        }
        if (mapURIs != null) {
            for (Resource resource : oResourceSet.getResources()) {
                URI reusableURI;
                URI resourceURI = resource.getURI();
                if (resourceURI == null || (reusableURI = mapURIs.get(resourceURI)) == null) continue;
                resource.setURI(reusableURI);
            }
        }
        itSources = sources.iterator();
        while (!monitor.isCanceled() && itSources.hasNext()) {
            Module eModule;
            source = itSources.next();
            if (((AcceleoSourceBuffer)source).getFile() != null) {
                monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.SaveAST", ((AcceleoSourceBuffer)source).getFile().getName()));
            }
            if ((eModule = ((AcceleoSourceBuffer)source).getAST()) != null) {
                Resource newResource = eModule.eResource();
                HashMap<String, String> options = new HashMap<String, String>();
                if (!this.asBinaryResource) {
                    String encoding = ((AcceleoSourceBuffer)source).getEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    options.put("ENCODING", encoding);
                }
                try {
                    newResource.save(options);
                }
                catch (IOException e) {
                    ((AcceleoSourceBuffer)source).logProblem(AcceleoParserMessages.getString("AcceleoParser.Error.FileSaving", newResource.getURI().lastSegment(), e.getMessage()), 0, -1);
                }
            } else {
                ((AcceleoSourceBuffer)source).logProblem(AcceleoParserMessages.getString("AcceleoParser.Error.InvalidAST", ((AcceleoSourceBuffer)source).getFile().getName()), 0, -1);
            }
            monitor.worked(1);
        }
        this.manageParsingResult(sources);
        Iterator resources = oResourceSet.getResources().iterator();
        while (resources.hasNext()) {
            ((Resource)resources.next()).unload();
        }
    }

    private Resource createResource(URI oURI, ResourceSet oResourceSet) {
        if (this.asBinaryResource) {
            return ModelUtils.createBinaryResource((URI)oURI, (ResourceSet)oResourceSet);
        }
        return ModelUtils.createResource((URI)oURI, (ResourceSet)oResourceSet);
    }

    private void manageParsingResult(List<AcceleoSourceBuffer> sources) {
        for (AcceleoSourceBuffer source : sources) {
            this.problems.put(source.getFile(), source.getProblems());
        }
        for (AcceleoSourceBuffer source : sources) {
            this.warnings.put(source.getFile(), source.getWarnings());
        }
        for (AcceleoSourceBuffer source : sources) {
            this.infos.put(source.getFile(), source.getInfos());
        }
    }

    public void parse(AcceleoSourceBuffer source, Resource resource, List<URI> dependenciesURIs) {
        int lastSegment;
        String importedFileName;
        ArrayList<URI> resourceSetURIs = new ArrayList<URI>();
        if (resource.getResourceSet() != null) {
            for (Resource otherResource : resource.getResourceSet().getResources()) {
                resourceSetURIs.add(otherResource.getURI());
            }
        }
        source.createCST();
        CompactHashSet allImportedFiles = new CompactHashSet();
        for (ModuleImportsValue importValue : source.getCST().getImports()) {
            importedFileName = importValue.getName();
            if (importedFileName == null) continue;
            lastSegment = importedFileName.lastIndexOf("::");
            if (lastSegment > -1) {
                importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
            }
            allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
        }
        for (ModuleExtendsValue extendValue : source.getCST().getExtends()) {
            importedFileName = extendValue.getName();
            if (importedFileName == null) continue;
            lastSegment = importedFileName.lastIndexOf("::");
            if (lastSegment > -1) {
                importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
            }
            allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
        }
        source.createAST(resource);
        if (resource.getResourceSet() != null) {
            for (URI oURI : dependenciesURIs) {
                if (resourceSetURIs.contains(oURI) || !allImportedFiles.contains(oURI.lastSegment())) continue;
                try {
                    ModelUtils.load((URI)oURI, (ResourceSet)resource.getResourceSet());
                }
                catch (IOException e) {
                    source.logProblem(AcceleoParserMessages.getString("AcceleoParser.Error.InvalidAST", oURI.lastSegment()), 0, -1);
                }
            }
        }
        source.resolveAST();
        source.resolveASTDocumentation();
        if (source.getFile() != null) {
            this.problems.put(source.getFile(), source.getProblems());
            this.warnings.put(source.getFile(), source.getWarnings());
            this.infos.put(source.getFile(), source.getInfos());
        }
    }

    public AcceleoParserProblems getProblems(File file) {
        return this.problems.get(file);
    }

    public AcceleoParserProblems getProblems(AcceleoFile acceleoFile) {
        return this.problems.get(acceleoFile.getMtlFile());
    }

    public AcceleoParserWarnings getWarnings(File file) {
        return this.warnings.get(file);
    }

    public AcceleoParserWarnings getWarnings(AcceleoFile acceleoFile) {
        if (this.warnings != null && acceleoFile != null) {
            return this.warnings.get(acceleoFile.getMtlFile());
        }
        return null;
    }

    public AcceleoParserInfos getInfos(File file) {
        if (this.infos != null) {
            return this.infos.get(file);
        }
        return null;
    }

    public AcceleoParserInfos getInfos(AcceleoFile acceleoFile) {
        if (this.infos != null && acceleoFile != null) {
            return this.infos.get(acceleoFile.getMtlFile());
        }
        return null;
    }
}

