/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoUIResourceSet;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class ReferencesSearchQuery
implements ISearchQuery {
    private ReferencesSearchResult searchResult;
    private EObject declaration;
    private AcceleoEditor editor;
    private boolean searchOutsideOfCurrentFile;
    private boolean showInEditor;

    public ReferencesSearchQuery(AcceleoEditor editor, EObject declaration) {
        this.declaration = declaration;
        this.editor = editor;
        this.searchResult = new ReferencesSearchResult(this);
        this.searchOutsideOfCurrentFile = true;
        this.showInEditor = false;
    }

    public ReferencesSearchQuery(AcceleoEditor editor, EObject declaration, boolean searchOutsideCurrentFile) {
        this.declaration = declaration;
        this.editor = editor;
        this.searchResult = new ReferencesSearchResult(this);
        this.searchOutsideOfCurrentFile = searchOutsideCurrentFile;
        this.showInEditor = false;
    }

    public ReferencesSearchQuery(AcceleoEditor editor, EObject declaration, boolean searchOutsideCurrentFile, boolean showResultInEditor) {
        this.declaration = declaration;
        this.editor = editor;
        this.searchResult = new ReferencesSearchResult(this);
        this.searchOutsideOfCurrentFile = searchOutsideCurrentFile;
        this.showInEditor = showResultInEditor;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoReferencesSearch.Query.Label");
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (this.declaration != null) {
            this.findReferencesForFile(monitor);
        }
        return Status.OK_STATUS;
    }

    private void findReferencesForFile(IProgressMonitor monitor) {
        ArrayList<URI> allURIs = new ArrayList<URI>();
        IProject project = null;
        if (this.editor.getContent().getFile() != null && this.editor.getFile() != null) {
            AcceleoProject acceleoProject = new AcceleoProject(this.editor.getContent().getFile().getProject());
            IPath outputFilePath = acceleoProject.getOutputFilePath(this.editor.getContent().getFile());
            if (outputFilePath == null) {
                return;
            }
            String path = outputFilePath.toString();
            URI newResourceURI = URI.createPlatformResourceURI((String)path, (boolean)false);
            allURIs.add(newResourceURI);
            if (this.searchOutsideOfCurrentFile) {
                project = this.editor.getFile().getProject();
                for (URI uri : new AcceleoProject(project).getOutputFiles()) {
                    if (allURIs.contains(uri)) continue;
                    allURIs.add(uri);
                }
            }
        }
        if (this.searchOutsideOfCurrentFile) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    if (!monitor.isCanceled() && projects[i] != project && projects[i].isAccessible() && projects[i].hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                        AcceleoProject acceleoProject = new AcceleoProject(projects[i]);
                        for (URI uri : acceleoProject.getOutputFiles()) {
                            if (allURIs.contains(uri)) continue;
                            allURIs.add(uri);
                        }
                    }
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
                ++i;
            }
        }
        EObject eObject = null;
        for (URI uri : allURIs) {
            try {
                if (monitor.isCanceled() || !this.resourceAtURIExist(uri)) continue;
                eObject = AcceleoUIResourceSet.getResource(uri);
            }
            catch (IOException iOException) {
            }
            catch (WrappedException wrappedException) {
                // empty catch block
            }
        }
        if (!monitor.isCanceled() && eObject != null) {
            EcoreUtil.resolveAll((Resource)eObject.eResource());
            if (eObject instanceof Module) {
                this.scanModuleForDeclaration((Module)eObject);
            }
        }
    }

    private boolean resourceAtURIExist(URI uri) {
        boolean result = true;
        try {
            result = AcceleoWorkspaceUtil.getWorkspaceFile((String)uri.toString()).exists();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void scanModuleForDeclaration(Module module) {
        IFile mtlFile;
        IFile emtlFile;
        IPath mtlPath;
        Path emtlPath = new Path(module.eResource().getURI().toPlatformString(true));
        if (emtlPath.segmentCount() > 1 && ResourcesPlugin.getWorkspace().getRoot().exists((IPath)emtlPath) && (mtlPath = new AcceleoProject((emtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)emtlPath)).getProject()).getInputFilePath((IPath)emtlPath)) != null && (mtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(mtlPath)).exists()) {
            StringBuffer acceleoText = FileContent.getFileContent((File)mtlFile.getLocation().toFile());
            this.scanModuleForDeclaration(mtlFile, acceleoText, module);
        }
    }

    private void scanModuleForDeclaration(IFile mtlFile, StringBuffer acceleoText, Module module) {
        this.addASTNode(mtlFile, acceleoText, (EObject)module);
        TreeIterator it = module.eAllContents();
        while (it.hasNext()) {
            this.addASTNode(mtlFile, acceleoText, (EObject)it.next());
        }
    }

    private void addASTNode(IFile mtlFile, StringBuffer acceleoText, EObject astNode) {
        boolean isRef;
        if (astNode instanceof IteratorExp && ((IteratorExp)astNode).getBody().getStartPosition() == -1 && ((IteratorExp)astNode).getBody().getEndPosition() == -1) {
            ((IteratorExp)astNode).getBody().setStartPosition(((IteratorExp)astNode).getStartPosition());
            ((IteratorExp)astNode).getBody().setEndPosition(((IteratorExp)astNode).getEndPosition());
        }
        if (!(isRef = this.isMatching(astNode, this.declaration))) {
            for (EObject eObj : astNode.eCrossReferences()) {
                if (!this.isMatching(eObj, this.declaration)) continue;
                isRef = true;
                break;
            }
        }
        if (isRef) {
            String message;
            IRegion region = this.createRegion(astNode);
            if (region.getOffset() + region.getLength() <= acceleoText.length()) {
                message = acceleoText.substring(region.getOffset(), region.getOffset() + region.getLength());
                if (message.startsWith("[") && message.indexOf("]") > -1) {
                    message = message.substring(0, message.indexOf("]") + 1);
                }
            } else {
                message = "";
            }
            this.searchResult.addMatch(new Match((Object)new ReferenceEntry(mtlFile, astNode, this.editor, message), region.getOffset(), region.getLength()));
            if (this.showInEditor) {
                try {
                    IMarker marker = mtlFile.createMarker("org.eclipse.search.searchmarker");
                    marker.setAttribute("charStart", region.getOffset());
                    marker.setAttribute("charEnd", region.getOffset() + region.getLength());
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
            }
        }
    }

    private boolean isMatching(EObject o1, EObject o2) {
        boolean result = false;
        if (o1.eClass().getName().equals(o2.eClass().getName())) {
            if (o1 instanceof Template && o2 instanceof Template) {
                Template t1 = (Template)o1;
                Template t2 = (Template)o2;
                result = this.isMatchingTemplate(t1, t2);
            } else if (o1 instanceof Query && o2 instanceof Query) {
                Query q1 = (Query)o1;
                Query q2 = (Query)o2;
                result = this.isMatchingQuery(q1, q2);
            } else if (o1 instanceof ModuleElement && o2 instanceof ModuleElement && ((ModuleElement)o1).getName() != null) {
                result = ((ModuleElement)o1).getName().equals(((ModuleElement)o2).getName());
            } else if (o1 instanceof Variable && o2 instanceof Variable) {
                Variable v1 = (Variable)o1;
                Variable v2 = (Variable)o2;
                result = this.isMatchingVariable(v1, v2);
            } else {
                Module m1 = null;
                Module m2 = null;
                boolean validSearchInFile = o1 instanceof ASTNode && o2 instanceof ASTNode && !this.searchOutsideOfCurrentFile;
                EObject parent1 = o1.eContainer();
                EObject parent2 = o2.eContainer();
                while (parent1 != null) {
                    if (parent1 instanceof Module) {
                        m1 = (Module)parent1;
                    }
                    parent1 = parent1.eContainer();
                }
                while (parent2 != null) {
                    if (parent2 instanceof Module) {
                        m2 = (Module)parent2;
                    }
                    parent2 = parent2.eContainer();
                }
                if (m1 != null && m2 != null && m1.getName().equals(m2.getName()) && validSearchInFile) {
                    ASTNode astNode1 = (ASTNode)o1;
                    ASTNode astNode2 = (ASTNode)o2;
                    result = astNode1.getStartPosition() == astNode2.getStartPosition() && astNode1.getEndPosition() == astNode2.getEndPosition();
                } else {
                    result = EcoreUtil.equals((EObject)o1, (EObject)o2);
                }
            }
        } else if (o1 instanceof VariableExp && o2 instanceof Variable) {
            VariableExp vx = (VariableExp)o1;
            org.eclipse.ocl.expressions.Variable referredVariable = vx.getReferredVariable();
            if (referredVariable instanceof Variable) {
                Variable vTemp = (Variable)referredVariable;
                Variable v2 = (Variable)o2;
                result = this.isMatchingVariable(vTemp, v2);
            }
        } else if (o1 instanceof Variable && o2 instanceof VariableExp) {
            VariableExp vx = (VariableExp)o2;
            org.eclipse.ocl.expressions.Variable referredVariable = vx.getReferredVariable();
            if (referredVariable instanceof Variable) {
                Variable vTemp = (Variable)referredVariable;
                Variable v1 = (Variable)o1;
                result = this.isMatchingVariable(v1, vTemp);
            }
        } else {
            result = EcoreUtil.equals((EObject)o1, (EObject)o2);
        }
        return result;
    }

    private boolean isMatchingVariable(Variable v1, Variable v2) {
        boolean result = false;
        if (v1.getName() != null) {
            result = v1.getName().equals(v2.getName());
        }
        if (result) {
            ModuleElement container1 = this.getContainingModuleElement(v1);
            ModuleElement container2 = this.getContainingModuleElement(v2);
            if (container1 != null && container2 != null) {
                result = result && container1.getStartPosition() == container2.getStartPosition() && container1.getEndPosition() == container2.getEndPosition();
            }
        }
        return result;
    }

    private ModuleElement getContainingModuleElement(Variable v) {
        ModuleElement moduleElement = null;
        EObject eContainer = v.eContainer();
        while (!(eContainer instanceof ModuleElement)) {
            if (eContainer == null) break;
            eContainer = eContainer.eContainer();
        }
        if (eContainer instanceof ModuleElement) {
            moduleElement = (ModuleElement)eContainer;
        }
        return moduleElement;
    }

    private boolean isMatchingTemplate(Template template1, Template template2) {
        boolean result = false;
        if (template1.getName() != null) {
            result = template1.getName().equals(template2.getName());
        }
        EList t1Parameters = template1.getParameter();
        EList t2Parameters = template2.getParameter();
        if (t1Parameters.size() == t2Parameters.size()) {
            int i = 0;
            while (i < t1Parameters.size()) {
                Variable var1 = (Variable)t1Parameters.get(i);
                Variable var2 = (Variable)t2Parameters.get(i);
                if (var1.getName() != null && var2.getName() != null && !var1.getName().equals(var2.getName())) {
                    result = false;
                    break;
                }
                if (var1.getType() != null && var2.getType() != null && ((EClassifier)var1.getType()).getName() != null && !((EClassifier)var1.getType()).getName().equals(((EClassifier)var2.getType()).getName())) {
                    result = false;
                    break;
                }
                ++i;
            }
            URI uri1 = EcoreUtil.getURI((EObject)template1);
            URI uri2 = EcoreUtil.getURI((EObject)template2);
            if (result && uri1 != null && uri2 != null) {
                result = uri1.equals((Object)uri2);
                result = result && template1.getStartPosition() == template2.getStartPosition() && template1.getEndPosition() == template2.getEndPosition();
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean isMatchingQuery(Query query1, Query query2) {
        boolean result = false;
        if (query1.getName() != null) {
            result = query1.getName().equals(query2.getName());
        }
        EList q1Parameters = query1.getParameter();
        EList q2Parameters = query2.getParameter();
        if (q1Parameters.size() == q2Parameters.size()) {
            int i = 0;
            while (i < q1Parameters.size()) {
                Variable var1 = (Variable)q1Parameters.get(i);
                Variable var2 = (Variable)q2Parameters.get(i);
                if (var1.getName() != null && var2.getName() != null && !var1.getName().equals(var2.getName())) {
                    result = false;
                    break;
                }
                if (var1.getType() != null && var2.getType() != null && ((EClassifier)var1.getType()).getName() != null && !((EClassifier)var1.getType()).getName().equals(((EClassifier)var2.getType()).getName())) {
                    result = false;
                    break;
                }
                ++i;
            }
            URI uri1 = EcoreUtil.getURI((EObject)query1);
            URI uri2 = EcoreUtil.getURI((EObject)query2);
            if (result && uri1 != null && uri2 != null) {
                result = uri1.equals((Object)uri2);
                result = result && query1.getStartPosition() == query2.getStartPosition() && query1.getEndPosition() == query2.getEndPosition();
            }
        } else {
            result = false;
        }
        return result;
    }

    private IRegion createRegion(EObject astNode) {
        int e;
        int b;
        Region result = null;
        if (astNode instanceof ASTNode && (b = ((ASTNode)astNode).getStartPosition()) > -1 && (e = ((ASTNode)astNode).getEndPosition()) >= b) {
            result = new Region(b, e - b);
        }
        if (result != null) {
            return result;
        }
        return new Region(0, 0);
    }

    public EObject getDeclaration() {
        return this.declaration;
    }
}

