/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoPom;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoPomDependency;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoOperation;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class CreatePomCommandHandler
extends AbstractHandler {
    private boolean enabled;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EvaluationContext context;
        Object defaultVariable;
        Object applicationContext = event.getApplicationContext();
        if (applicationContext instanceof EvaluationContext && (defaultVariable = (context = (EvaluationContext)applicationContext).getDefaultVariable()) instanceof List) {
            List variables = (List)defaultVariable;
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (Object object : variables) {
                if (object instanceof IProject) {
                    IProject project = (IProject)object;
                    projects.add(project);
                    continue;
                }
                if (object instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)object;
                    projects.add(javaProject.getProject());
                    continue;
                }
                if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
            }
            for (IProject iProject : projects) {
                try {
                    if (!iProject.isAccessible() || !iProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) continue;
                    this.generatePom(iProject);
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
        return applicationContext;
    }

    private void generatePom(IProject project) {
        org.eclipse.acceleo.ide.ui.resources.AcceleoProject acceleoProject = new org.eclipse.acceleo.ide.ui.resources.AcceleoProject(project);
        AcceleoPom acceleoPom = AcceleowizardmodelFactory.eINSTANCE.createAcceleoPom();
        acceleoPom.setArtifactId(project.getName());
        EList<AcceleoPomDependency> pomDependencies = acceleoPom.getDependencies();
        IPath eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path eclipseHome = new Path(Platform.getInstallLocation().getURL().getPath());
        IPath eclipsePathRelativeToFile = CreateRunnableAcceleoOperation.computeEclipsePath();
        for (IPath iPath : acceleoProject.getResolvedClasspath()) {
            String classpathEntry = null;
            if (eclipseWorkspace.isPrefixOf(iPath)) {
                classpathEntry = iPath.toString().substring(eclipseWorkspace.toString().length());
            } else if (eclipseHome.isPrefixOf(iPath)) {
                classpathEntry = iPath.toString().substring(eclipseHome.toString().length());
            }
            if (classpathEntry == null) continue;
            AcceleoPomDependency acceleoPomDependency = AcceleowizardmodelFactory.eINSTANCE.createAcceleoPomDependency();
            String artifactId = classpathEntry;
            if (artifactId.contains("_")) {
                artifactId = artifactId.substring(0, artifactId.indexOf(95));
            }
            if (artifactId.startsWith("plugins/")) {
                artifactId = artifactId.substring("plugins/".length());
            }
            acceleoPomDependency.setArtifactId(artifactId);
            acceleoPomDependency.setGroupId("eclipse");
            String version = classpathEntry;
            if (version.contains("_") && version.indexOf(95) <= version.length()) {
                version = version.substring(version.indexOf(95) + 1);
            }
            if (version.endsWith(".jar")) {
                version = version.substring(0, version.length() - ".jar".length());
            }
            acceleoPomDependency.setVersion(version);
            acceleoPomDependency.setSystemPath("${basedir}/" + org.eclipse.acceleo.ide.ui.resources.AcceleoProject.makeRelativeTo(eclipsePathRelativeToFile, project.getLocation()).toString() + '/' + classpathEntry);
            pomDependencies.add((Object)acceleoPomDependency);
        }
        if (project.getParent() != null) {
            String parentName = project.getParent().getName();
            if (project.getParent() instanceof IWorkspaceRoot) {
                IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)project.getParent();
                parentName = workspaceRoot.getLocation().lastSegment();
            }
            AcceleoUIGenerator.getDefault().generatePomChild(acceleoPom, (IContainer)project, parentName);
            AcceleoUIGenerator.getDefault().generatePom(acceleoPom, project.getParent(), parentName);
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IFolder sourceFolder = project.getFolder("src-acceleo-build");
            sourceFolder.create(false, true, null);
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
            javaProject.setRawClasspath(newEntries, null);
            StringTokenizer tokenizer = new StringTokenizer(project.getName(), ".");
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken();
                if ((sourceFolder = sourceFolder.getFolder(nextToken)).exists()) continue;
                sourceFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            AcceleoProject acceleoModelProject = AcceleowizardmodelFactory.eINSTANCE.createAcceleoProject();
            acceleoModelProject.setName(project.getName());
            AcceleoUIGenerator.getDefault().generateAcceleoCompiler(acceleoModelProject, (IContainer)sourceFolder);
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    public void setEnabled(Object evaluationContext) {
        EvaluationContext context;
        Object defaultVariable;
        if (evaluationContext instanceof EvaluationContext && (defaultVariable = (context = (EvaluationContext)evaluationContext).getDefaultVariable()) instanceof List && ((List)defaultVariable).size() > 0) {
            List variables = (List)defaultVariable;
            for (Object object : variables) {
                try {
                    IProject project;
                    if (object instanceof IProject) {
                        project = (IProject)object;
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                        continue;
                    }
                    if (object instanceof IJavaProject) {
                        project = ((IJavaProject)object).getProject();
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    project = (IProject)Platform.getAdapterManager().getAdapter(object, IProject.class);
                    this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

