/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.hover;

import java.io.IOException;
import java.io.StringReader;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.hover.AcceleoDocPartitionScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.hover.HTML2TextReader;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.AcceleoUIDocumentationUtils;
import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class AcceleoDocViewer
extends SourceViewer {
    private Object input;
    private IDocument document;

    public AcceleoDocViewer(Composite parent, int styles) {
        super(parent, null, styles);
        this.setEditable(false);
        Color background = parent.getDisplay().getSystemColor(29);
        Color foreground = parent.getDisplay().getSystemColor(28);
        this.getTextWidget().setBackground(background);
        this.getTextWidget().setForeground(foreground);
    }

    public void setInput(Object editorInput) {
        this.input = editorInput;
        this.createDocumentFromInput();
    }

    public boolean inputIsDocumentation() {
        return this.input instanceof Documentation;
    }

    private void createDocumentFromInput() {
        String text = null;
        if (this.input instanceof Documentation) {
            text = AcceleoUIDocumentationUtils.getTextFrom((Documentation)this.input);
        } else if (this.input instanceof EOperation) {
            text = AcceleoUIDocumentationUtils.getTextFrom((EOperation)this.input);
        } else if (this.input instanceof EObject) {
            text = AcceleoUIDocumentationUtils.getSignatureFrom((EObject)this.input);
        } else if (this.input instanceof String) {
            text = (String)this.input;
        }
        TextPresentation textPresentation = new TextPresentation();
        HTML2TextReader reader = new HTML2TextReader(new StringReader(text), textPresentation);
        try {
            text = reader.getString();
        }
        catch (IOException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            text = "";
        }
        this.document = new Document(text);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new AcceleoDocPartitionScanner(), AcceleoDocPartitionScanner.TYPES);
        partitioner.connect(this.document);
        this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.setDocument(this.document);
        TextPresentation.applyTextPresentation((TextPresentation)textPresentation, (StyledText)this.getTextWidget());
    }

    public boolean hasContent() {
        if (this.document != null) {
            return this.document.get().length() > 0;
        }
        return false;
    }

    public String getText() {
        if (this.document != null) {
            return this.document.get();
        }
        return null;
    }

    public Documentation getDocumentation() {
        if (this.inputIsDocumentation()) {
            return (Documentation)this.input;
        }
        return null;
    }
}

