/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedVariable;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameVariableDescriptor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.AcceleoUIDocumentationUtils;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.acceleo.model.mtl.DocumentedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoRenameVariableRefactoring
extends Refactoring {
    private static final String VARIABLE = "variable";
    private static final String NEWNAME = "newName";
    protected String fNewVariableName;
    protected AcceleoPositionedVariable fVariable;
    private Map<IFile, TextFileChange> fChanges;
    private final String title = AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.RenameVariableTitle");
    private String fileName;

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CheckingPreconditions"), 1);
            if (this.fVariable == null) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.NoVariableSpecified")));
            }
            this.fChanges = new LinkedHashMap<IFile, TextFileChange>();
            this.putChangesOfTheCurrentFile();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void putChangesOfTheCurrentFile() {
        DocumentedElement documentedElement;
        Documentation documentation;
        TextFileChange tfc = null;
        MultiTextEdit edit = null;
        IFile file = null;
        for (Match match : this.fVariable.getVariableMatches()) {
            ReferenceEntry entry = (ReferenceEntry)match.getElement();
            if (!entry.getTemplateFile().getName().equals(this.fileName)) continue;
            file = entry.getTemplateFile();
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange(this.title, file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.indexOf(this.fVariable.getVariableName());
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fVariable.getVariableName().length(), this.fNewVariableName));
            this.fChanges.put(file, tfc);
        }
        if (this.fVariable.getVariable().eContainer() != null && this.fVariable.getVariable().eContainer() instanceof DocumentedElement && (documentation = AcceleoUIDocumentationUtils.getDocumentationFromFile(documentedElement = (DocumentedElement)this.fVariable.getVariable().eContainer())) != null && documentation.getBody().getValue().indexOf("@param " + this.fVariable.getVariableName()) != -1 && edit != null && file != null) {
            StringBuffer content = FileContent.getFileContent((File)file.getLocation().toFile());
            int index = content.indexOf("@param " + this.fVariable.getVariableName(), documentation.getBody().getStartPosition());
            int length = ("@param " + this.fVariable.getVariableName()).length();
            edit.addChild((TextEdit)new ReplaceEdit(index, length, "@param " + this.fNewVariableName));
            this.fChanges.put(file, tfc);
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            CompositeChange change;
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CreatingChanges"), 1);
            Collection<TextFileChange> changes = this.fChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String project = AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.RefactoringProjectName");
                    String description = String.valueOf(AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.RenamingVariable")) + " " + AcceleoRenameVariableRefactoring.this.fVariable.getVariableName();
                    String comment = AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.RenamingVariableWithNewName", AcceleoRenameVariableRefactoring.this.fVariable.getVariableName(), AcceleoRenameVariableRefactoring.this.fNewVariableName);
                    arguments.put(AcceleoRenameVariableRefactoring.VARIABLE, AcceleoRenameVariableRefactoring.this.fVariable.getVariableName());
                    arguments.put(AcceleoRenameVariableRefactoring.NEWNAME, AcceleoRenameVariableRefactoring.this.fNewVariableName);
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)new AcceleoRenameVariableDescriptor(project, description, comment, arguments));
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getName() {
        return this.title;
    }

    public void setVariable(AcceleoPositionedVariable currentVariable) {
        this.fVariable = currentVariable;
    }

    public AcceleoPositionedVariable getVariable() {
        return this.fVariable;
    }

    public RefactoringStatus setNewVariableName(String text) {
        this.fNewVariableName = text;
        RefactoringStatus status = this.checkVariableName(this.fNewVariableName);
        status.merge(this.checkOverLoading());
        return status;
    }

    private RefactoringStatus checkOverLoading() {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    private RefactoringStatus checkVariableName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.InvalidVariableName")));
            }
            ++i;
        }
        return status;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(VARIABLE);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewVariableName(value);
        }
        return status;
    }
}

