/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core;

import java.util.List;
import org.eclipse.acceleo.compatibility.model.mt.core.CoreFactory;
import org.eclipse.acceleo.compatibility.model.mt.core.Script;
import org.eclipse.acceleo.compatibility.model.mt.core.ScriptDescriptor;
import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core.ScriptDescriptorParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.StatementParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptParser {
    private ScriptParser() {
    }

    public static void parseScripts(int offset, String buffer, Template template, List<TemplateSyntaxException> problems) {
        ScriptDescriptor descriptor = null;
        Region end = new Region(0, 0);
        while (end.e() > -1 && end.e() < buffer.length()) {
            Region begin = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getScriptBegin(), new Region(end.e(), buffer.length()), null, TemplateConstants.getDefault().getInhibsScriptContent());
            if (begin.b() > -1) {
                try {
                    ScriptParser.newScript(offset, buffer, new Region(end.e(), begin.b()), template, descriptor);
                }
                catch (TemplateSyntaxException e) {
                    problems.add(e);
                }
                descriptor = null;
                end = TextSearch.blockIndexEndIn(buffer, TemplateConstants.getDefault().getScriptBegin(), TemplateConstants.getDefault().getScriptEnd(), new Region(begin.b(), buffer.length()), false, TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsScriptDecla());
                if (end.e() == -1) {
                    problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingScriptEndTag"), template, begin.b()));
                    continue;
                }
                try {
                    descriptor = ScriptDescriptorParser.createScriptDescriptor(offset, buffer, new Region(begin.e(), end.b()), template);
                }
                catch (TemplateSyntaxException e) {
                    problems.add(e);
                    descriptor = null;
                }
                continue;
            }
            try {
                ScriptParser.newScript(offset, buffer, new Region(end.e(), buffer.length()), template, descriptor);
            }
            catch (TemplateSyntaxException e) {
                problems.add(e);
            }
            end = new Region(buffer.length(), buffer.length());
        }
    }

    private static void newScript(int offset, String buffer, Region range, Template template, ScriptDescriptor descriptor) throws TemplateSyntaxException {
        if (descriptor != null && range.b() > 0) {
            Region limitsTextTemplate = StatementParser.formatTemplate(buffer, range, 2);
            Script script = CoreFactory.eINSTANCE.createScript();
            template.getScripts().add((Object)script);
            script.setDescriptor(descriptor);
            script.getStatements().addAll(StatementParser.createStatement(offset, buffer, limitsTextTemplate, template));
            script.setBegin(limitsTextTemplate.b());
            script.setEnd(limitsTextTemplate.e());
        }
    }
}

