/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.internal.evaluation.JMergeUtil;
import org.eclipse.emf.common.EMFPlugin;

public final class AcceleoFileWriter
extends AbstractAcceleoWriter {
    private String selectedCharset;
    private boolean shouldMerge;
    private final String targetPath;

    public AcceleoFileWriter(File target, boolean appendMode) throws IOException {
        this.delegate = new BufferedWriter(new FileWriter(target, appendMode));
        if (appendMode) {
            ((BufferedWriter)this.delegate).newLine();
        }
        this.targetPath = target.getAbsolutePath();
        this.shouldMerge = false;
    }

    public AcceleoFileWriter(File target, boolean appendMode, String charset) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(target, appendMode);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);
        this.delegate = new BufferedWriter(fileWriter);
        if (appendMode) {
            ((BufferedWriter)this.delegate).newLine();
        }
        this.targetPath = target.getAbsolutePath();
        this.shouldMerge = false;
    }

    public AcceleoFileWriter(String filePath) {
        this.delegate = new StringWriter(1024);
        this.targetPath = filePath;
        this.shouldMerge = true;
    }

    public AcceleoFileWriter(String filePath, String charset) {
        this(filePath);
        this.selectedCharset = charset;
    }

    public void close() throws IOException {
        if (!this.shouldMerge || !EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.delegate.close();
        } else {
            this.flush();
            try {
                Class.forName("org.eclipse.emf.codegen.merge.java.JMerger");
                String mergedContent = JMergeUtil.mergeFileContent(new File(this.targetPath), this.toString(), this.selectedCharset);
                Writer writer = null;
                try {
                    if (this.selectedCharset == null) {
                        writer = new BufferedWriter(new FileWriter(new File(this.targetPath)));
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.targetPath));
                        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.selectedCharset);
                        writer = new BufferedWriter(fileWriter);
                    }
                    writer.append(mergedContent);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public String getTargetPath() {
        return this.targetPath;
    }
}

