/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicTemplatesEclipseUtil;
import org.eclipse.emf.common.EMFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoDynamicTemplatesRegistry {
    public static final AcceleoDynamicTemplatesRegistry INSTANCE = new AcceleoDynamicTemplatesRegistry();
    private final Set<File> registeredModules = new LinkedHashSet<File>();

    private AcceleoDynamicTemplatesRegistry() {
    }

    public boolean addModule(File module) {
        return this.registeredModules.add(module);
    }

    public boolean addModules(Collection<File> modules) {
        return this.registeredModules.addAll(modules);
    }

    public void addModulesFrom(File file) {
        if (file.exists() && file.canRead()) {
            if (file.isDirectory()) {
                File[] children;
                File[] fileArray = children = file.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return !pathname.getAbsolutePath().matches("^.*(CVS|\\\\.svn)$");
                    }
                });
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.addModulesFrom(child);
                    ++n2;
                }
            } else if ("emtl".equals(file.getPath().substring(file.getPath().lastIndexOf(46) + 1))) {
                this.addModule(file);
            }
        }
    }

    public void clearRegistryResourceSet() {
        this.registeredModules.clear();
    }

    public Set<File> getRegisteredModules() {
        LinkedHashSet<File> compound = new LinkedHashSet<File>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            compound.addAll(AcceleoDynamicTemplatesEclipseUtil.getRegisteredModules());
        }
        compound.addAll(this.registeredModules);
        return compound;
    }

    public boolean removeModule(File module) {
        return this.registeredModules.remove(module);
    }

    public boolean removeModules(Collection<File> modules) {
        return this.registeredModules.removeAll(modules);
    }
}

