/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.profiler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.profiler.LoopProfileEntry;
import org.eclipse.acceleo.profiler.ProfileEntry;
import org.eclipse.acceleo.profiler.ProfileResource;
import org.eclipse.acceleo.profiler.ProfilerFactory;
import org.eclipse.acceleo.profiler.ProfilerPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class Profiler {
    public static final EObject INTERNAL = ProfilerPackage.eINSTANCE.getEClassifier("Internal");
    private Context currentContext;
    private ProfileResource resource;
    private ProfileEntry currentLoopEntry;

    public void loop(EObject loopElement) {
        LoopProfileEntry entry = this.currentContext.getcurrentEntry();
        this.stopCurrentLoopEntry();
        this.startCurrentLoopEntry(loopElement);
        entry.getLoopElements().add((Object)this.currentLoopEntry);
    }

    private void stopCurrentLoopEntry() {
        if (this.currentLoopEntry != null) {
            this.currentLoopEntry.stop();
            this.currentLoopEntry = null;
        }
    }

    private void startCurrentLoopEntry(EObject loopElement) {
        this.currentLoopEntry = ProfilerFactory.eINSTANCE.createProfileEntry();
        this.currentLoopEntry.setCreateTime(System.currentTimeMillis());
        this.currentLoopEntry.setMonitored(loopElement);
        this.currentLoopEntry.start();
    }

    public void start(EObject monitored) {
        Context nextContext;
        if (this.currentContext != null) {
            nextContext = this.currentContext.getChildContext(monitored);
            nextContext.getcurrentEntry().start();
            this.currentContext.getcurrentEntry().getCallees().add((Object)nextContext.getcurrentEntry());
        } else {
            LoopProfileEntry entry = ProfilerFactory.eINSTANCE.createLoopProfileEntry();
            entry.setCreateTime(System.currentTimeMillis());
            entry.setMonitored(monitored);
            if (this.resource == null) {
                this.resource = ProfilerFactory.eINSTANCE.createProfileResource();
            }
            this.resource.getEntries().add((Object)entry);
            entry.start();
            nextContext = new Context(null, entry);
        }
        this.currentContext = nextContext;
    }

    public void reset() {
        this.currentContext = null;
        this.resource = null;
    }

    public void stop() {
        this.currentContext.getcurrentEntry().stop();
        this.stopCurrentLoopEntry();
        this.currentContext = this.currentContext.getParent();
    }

    public void save(String modelURI) throws IOException {
        this.addDefaultNodes();
        this.computePercentage();
        this.save(this.resource, modelURI);
    }

    private void computePercentage() {
        for (ProfileEntry root : this.resource.getEntries()) {
            long baseTime = root.getDuration();
            root.setPercentage(100.0);
            TreeIterator itContent = root.eAllContents();
            while (itContent.hasNext()) {
                ProfileEntry node = (ProfileEntry)itContent.next();
                node.setPercentage((double)node.getDuration() * 100.0 / (double)baseTime);
            }
        }
    }

    protected void addDefaultNodes() {
        for (ProfileEntry root : this.resource.getEntries()) {
            this.addDefaultNodes(root);
        }
    }

    private void addDefaultNodes(ProfileEntry entry) {
        long childrenDuration = 0L;
        for (ProfileEntry child : entry.getCallees()) {
            childrenDuration += child.getDuration();
            this.addDefaultNodes(child);
        }
        if (entry.getCallees().size() > 0 && entry.getDuration() - childrenDuration > 0L) {
            ProfileEntry def = ProfilerFactory.eINSTANCE.createProfileEntry();
            def.setCreateTime(System.currentTimeMillis());
            def.setDuration(entry.getDuration() - childrenDuration);
            def.setMonitored(INTERNAL);
            entry.getCallees().add((Object)def);
        }
    }

    private void save(EObject result, String modelURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource newModelResource = resourceSet.createResource(URI.createFileURI((String)URI.decode((String)modelURI)));
        newModelResource.getContents().add((Object)result);
        HashMap options = new HashMap();
        newModelResource.save(options);
        newModelResource.unload();
    }

    private final class Context {
        private final Map<EObject, Context> childrenCache = new HashMap<EObject, Context>();
        private final Context parent;
        private final LoopProfileEntry currentEntry;

        public Context(Context parent, LoopProfileEntry entry) {
            this.parent = parent;
            this.currentEntry = entry;
        }

        public Context getChildContext(EObject monitored) {
            Context childContext = this.childrenCache.get(monitored);
            if (childContext == null) {
                LoopProfileEntry entry = ProfilerFactory.eINSTANCE.createLoopProfileEntry();
                entry.setCreateTime(System.currentTimeMillis());
                entry.setMonitored(monitored);
                childContext = new Context(this, entry);
                this.childrenCache.put(monitored, childContext);
            }
            return childContext;
        }

        public LoopProfileEntry getcurrentEntry() {
            return this.currentEntry;
        }

        public Context getParent() {
            return this.parent;
        }
    }
}

