/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import java.io.CharArrayReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jet.core.parser.IJETParser;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.RecursiveIncludeException;
import org.eclipse.jet.core.parser.TemplateInputException;
import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.Comment;
import org.eclipse.jet.core.parser.ast.IncludedContent;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JETDirective;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.internal.core.parser.IJETParser2;
import org.eclipse.jet.internal.core.parser.IncludeAlternativesTracker;
import org.eclipse.jet.internal.core.parser.TextTrimmingVisitor;
import org.eclipse.jet.internal.core.parser.jasper.CommentElementDelegate;
import org.eclipse.jet.internal.core.parser.jasper.DeclarationElementDelegate;
import org.eclipse.jet.internal.core.parser.jasper.ErrorRedirectingCoreElementDelegate;
import org.eclipse.jet.internal.core.parser.jasper.JETCoreElement;
import org.eclipse.jet.internal.core.parser.jasper.JETException;
import org.eclipse.jet.internal.core.parser.jasper.JETMark;
import org.eclipse.jet.internal.core.parser.jasper.JETParseEventListener2;
import org.eclipse.jet.internal.core.parser.jasper.JETParser;
import org.eclipse.jet.internal.core.parser.jasper.JETReader;
import org.eclipse.jet.internal.l10n.JET2Messages;

public class InternalJET1Parser
implements JETParseEventListener2,
IJETParser,
IJETParser2 {
    private static final String JET__DIRECTIVE = "jet";
    private static final String INCLUDE__DIRECTIVE = "include";
    private static final String FILE__ATTR = "file";
    private static final String FAIL__ATTR = "fail";
    private static final String START__DIRECTIVE = "start";
    private static final String END__DIRECTIVE = "end";
    private final IncludeAlternativesTracker includeAlternativesTracker = new IncludeAlternativesTracker();
    private final Stack includedContentStack = new Stack();
    private final Stack templateInputs = new Stack();
    private JETCompilationUnit compilationUnit;
    private JETAST ast;
    private JETReader reader;
    private final ITemplateResolver templateResolver;
    private static Set knownIncludeAttributes = new LinkedHashSet<String>(Arrays.asList("file", "fail"));
    private static Set knownJETAttributes = new LinkedHashSet<String>(Arrays.asList("skeleton", "package", "imports", "class", "nlString", "startTag", "endTag", "version", "extends"));
    private static Set deprecatedJETAttributes = new LinkedHashSet<String>(Arrays.asList("skeleton", "nlString"));
    private JETParser parser;

    public InternalJET1Parser(ITemplateResolver templateResolver) {
        this.templateResolver = templateResolver;
    }

    public void beginPageProcessing() {
    }

    public void handleDirective(String directive, JETMark start, JETMark stop, Map attributes) {
        JETDirective directiveElement = this.ast.newJETDirective(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor() + 1, directive, attributes);
        boolean compileEnabled = this.includeAlternativesTracker.isCompileEnabled();
        if (JET__DIRECTIVE.equalsIgnoreCase(directive)) {
            if (compileEnabled) {
                this.addBodyElement(directiveElement);
                this.handleJetDirective(start, stop, attributes);
            }
        } else if (INCLUDE__DIRECTIVE.equalsIgnoreCase(directive)) {
            if (compileEnabled) {
                this.addBodyElement(directiveElement);
            }
            this.handleIncludeDirective(directiveElement, start, stop, attributes);
        } else if (START__DIRECTIVE.equalsIgnoreCase(directive)) {
            try {
                this.includeAlternativesTracker.startAlternative(directiveElement);
                if (this.includeAlternativesTracker.isCompileEnabled()) {
                    this.addBodyElement(directiveElement);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.recordProblem(ProblemSeverity.ERROR, 19, JET2Messages.JET2Compiler_StartDirectiveOutOfContext, new Object[]{directive}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            }
        } else if (END__DIRECTIVE.equalsIgnoreCase(directive)) {
            try {
                if (compileEnabled) {
                    this.addBodyElement(directiveElement);
                }
                this.includeAlternativesTracker.endAlternative(directiveElement);
            }
            catch (IllegalStateException illegalStateException) {
                this.recordProblem(ProblemSeverity.ERROR, 20, JET2Messages.JET2Compiler_EndDirectiveOutOfContext, new Object[]{directive}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            }
        } else if (compileEnabled) {
            this.recordProblem(ProblemSeverity.WARNING, 15, JET2Messages.ASTCompilerParseListener_UnsupportedDirective, new Object[]{directive}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
    }

    private void handleIncludeDirective(JETDirective directive, JETMark start, JETMark stop, Map attributes) {
        boolean includePushed;
        this.validateAttributes(start, stop, attributes, knownIncludeAttributes, Collections.EMPTY_SET);
        String file = (String)attributes.get(FILE__ATTR);
        if (file == null) {
            this.missingRequiredAttribute(start, stop, INCLUDE__DIRECTIVE, FILE__ATTR);
            return;
        }
        IncludeFailAction failAction = IncludeFailAction.getAction((String)attributes.get(FAIL__ATTR));
        boolean bl = includePushed = this.includeAlternativesTracker.isCompileEnabled() && this.doPushInclude(file);
        if (includePushed) {
            ITemplateInput templateInput = (ITemplateInput)this.templateInputs.peek();
            IncludedContent includedContent = this.ast.newIncludedContent(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), templateInput.getBaseLocation(), templateInput.getTemplatePath());
            this.addBodyElement(includedContent);
            this.includedContentStack.push(includedContent);
        } else if (this.includeAlternativesTracker.isCompileEnabled() && failAction == IncludeFailAction.ERROR) {
            this.recordProblem(ProblemSeverity.ERROR, 18, JET2Messages.JET2Compiler_MissingFile, new Object[]{file}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
        if (failAction == IncludeFailAction.ALTERNATIVE) {
            boolean processAlternative = this.includeAlternativesTracker.isCompileEnabled() && !includePushed;
            this.includeAlternativesTracker.addIncludeWithAlternative(directive, processAlternative);
        }
    }

    private boolean doPushInclude(String relativePath) {
        ITemplateInput[] activeInputs = this.templateInputs.toArray(new ITemplateInput[this.templateInputs.size()]);
        if (activeInputs.length > 0) {
            try {
                ITemplateInput includedInput = this.templateResolver.getIncludedInput(relativePath, activeInputs);
                if (includedInput != null) {
                    this.reader.stackStream(includedInput.getBaseLocation().toString(), includedInput.getTemplatePath(), includedInput.getReader());
                    this.templateInputs.push(includedInput);
                    return true;
                }
            }
            catch (JETException jETException) {
            }
            catch (TemplateInputException templateInputException) {
            }
            catch (RecursiveIncludeException recursiveIncludeException) {}
        }
        return false;
    }

    private void validateAttributes(JETMark start, JETMark stop, Map attributes, Set knownAttributes, Set deprecatedAttributes) {
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (!knownAttributes.contains(attrName)) {
                this.recordProblem(ProblemSeverity.ERROR, 6, JET2Messages.JET2Compiler_UnknownAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            }
            if (!deprecatedAttributes.contains(attrName)) continue;
            this.recordProblem(ProblemSeverity.WARNING, 11, JET2Messages.JET2Compiler_DeprecatedAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
    }

    private void missingRequiredAttribute(JETMark start, JETMark stop, String directive, String attribute) {
        this.compilationUnit.createProblem(ProblemSeverity.ERROR, 3, JET2Messages.JET2Compiler_MissingDirectiveAttribute, new Object[]{directive, attribute}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
    }

    private void handleJetDirective(JETMark start, JETMark stop, Map attributes) {
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (!knownJETAttributes.contains(attrName)) {
                this.recordProblem(ProblemSeverity.ERROR, 6, JET2Messages.JET2Compiler_UnknownAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            }
            if (!deprecatedJETAttributes.contains(attrName)) continue;
            this.recordProblem(ProblemSeverity.WARNING, 11, JET2Messages.JET2Compiler_DeprecatedAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
        String pkg = (String)attributes.get("package");
        String cls = (String)attributes.get("class");
        String importStr = (String)attributes.get("imports");
        String startTag = (String)attributes.get("startTag");
        String endTag = (String)attributes.get("endTag");
        String extend = (String)attributes.get("extends");
        if (pkg != null) {
            this.compilationUnit.setOutputJavaPackage(pkg);
        }
        if (cls != null) {
            this.compilationUnit.setOutputJavaClassName(cls);
        }
        if (importStr != null) {
            String[] imports = importStr.split("\\s+");
            this.compilationUnit.addImports(Arrays.asList(imports));
        }
        if (extend != null) {
            this.compilationUnit.setExtend(extend);
        }
        if (startTag != null) {
            this.parser.setStartTag(startTag);
        }
        if (endTag != null) {
            this.parser.setEndTag(endTag);
        }
    }

    public void handleExpression(JETMark start, JETMark stop, Map attributes) {
        if (!this.includeAlternativesTracker.isCompileEnabled()) {
            return;
        }
        JavaExpression expression = this.ast.newJavaExpression(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        this.addBodyElement(expression);
    }

    public void handleCharData(char[] chars) {
        if (!this.includeAlternativesTracker.isCompileEnabled()) {
            return;
        }
        TextElement text = this.ast.newTextElement(chars);
        this.addBodyElement(text);
    }

    public void endPageProcessing() {
        if (this.templateInputs.size() > 0) {
            this.templateInputs.pop();
        }
        if (this.includedContentStack.size() > 0) {
            this.includedContentStack.pop();
        }
    }

    public void handleScriptlet(JETMark start, JETMark stop, Map attributes) {
        if (!this.includeAlternativesTracker.isCompileEnabled()) {
            return;
        }
        JavaScriptlet scriplet = this.ast.newJavaScriptlet(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        this.addBodyElement(scriplet);
    }

    public void handleComment(JETMark start, JETMark stop) {
        if (!this.includeAlternativesTracker.isCompileEnabled()) {
            return;
        }
        Comment comment = this.ast.newComment(start.getLine(), start.getCol(), start.getCursor() - 4, stop.getCursor() + 4, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        this.addBodyElement(comment);
    }

    private void addBodyElement(BodyElement bodyElement) {
        if (this.includedContentStack.isEmpty()) {
            this.compilationUnit.addBodyElement(bodyElement);
        } else {
            IncludedContent topElement = (IncludedContent)this.includedContentStack.peek();
            topElement.addBodyElement(bodyElement);
        }
    }

    public void handleDeclaration(JETMark start, JETMark stop) {
        if (!this.includeAlternativesTracker.isCompileEnabled()) {
            return;
        }
        JavaDeclaration decl = this.ast.newJavaDeclaration(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        this.addBodyElement(decl);
    }

    public void handleXMLEndTag(String tagName, JETMark start, JETMark stop) {
        throw new IllegalStateException();
    }

    public void handleXMLEmptyTag(String tagName, JETMark start, JETMark stop, Map attributeMap) {
        throw new IllegalStateException();
    }

    public void handleXMLStartTag(String tagName, JETMark start, JETMark stop, Map attributeMap) {
        throw new IllegalStateException();
    }

    public boolean isKnownTag(String tagName) {
        return false;
    }

    public JETCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void recordProblem(ProblemSeverity severity, int problemId, String message, Object[] msgArgs, int start, int end, int line, int colOffset) {
        this.compilationUnit.createProblem(severity, problemId, message, msgArgs, start, end, line, colOffset);
    }

    private JETParser configureParser(JETReader reader) {
        JETParser.Directive directive = new JETParser.Directive();
        directive.getDirectives().add(JET__DIRECTIVE);
        directive.getDirectives().add(INCLUDE__DIRECTIVE);
        directive.getDirectives().add(START__DIRECTIVE);
        directive.getDirectives().add(END__DIRECTIVE);
        JETCoreElement[] coreElements = new JETCoreElement[]{new ErrorRedirectingCoreElementDelegate(directive), new ErrorRedirectingCoreElementDelegate(new JETParser.Expression()), new ErrorRedirectingCoreElementDelegate(new CommentElementDelegate()), new ErrorRedirectingCoreElementDelegate(new DeclarationElementDelegate()), new ErrorRedirectingCoreElementDelegate(new JETParser.Scriptlet())};
        return new JETParser(reader, this, coreElements);
    }

    public boolean isKnownInvalidTagName(String tagName) {
        return false;
    }

    public Object parse(String templatePath) {
        ITemplateInput templateInput = this.templateResolver.getInput(templatePath);
        this.templateInputs.push(templateInput);
        URI baseLocation = templateInput.getBaseLocation();
        try {
            if (this.compilationUnit == null) {
                this.compilationUnit = new JETAST().newJETCompilationUnit(baseLocation, templatePath, templateInput.getEncoding());
                this.ast = this.compilationUnit.getAst();
            }
            this.reader = new JETReader(baseLocation == null ? null : baseLocation.toString(), templatePath, templateInput.getReader());
            this.intermalParse();
        }
        catch (JETException e) {
            this.recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        catch (TemplateInputException e) {
            this.recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        return this.compilationUnit;
    }

    public Object parse(char[] template) {
        return this.parse(template, "");
    }

    public Object parse(char[] template, String templatePath) {
        URI baseLocation;
        if (templatePath == null) {
            templatePath = "";
        }
        if (templatePath.length() > 0) {
            ITemplateInput templateInput = this.templateResolver.getInput(templatePath);
            this.templateInputs.push(templateInput);
            baseLocation = templateInput.getBaseLocation();
        } else {
            Object templateInput = null;
            baseLocation = null;
        }
        if (this.compilationUnit == null) {
            this.compilationUnit = new JETAST().newJETCompilationUnit(baseLocation, templatePath, null);
            this.ast = this.compilationUnit.getAst();
        }
        try {
            this.reader = new JETReader(baseLocation == null ? null : baseLocation.toString(), templatePath, new CharArrayReader(template));
            this.intermalParse();
        }
        catch (JETException e) {
            this.recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        return this.compilationUnit;
    }

    private void intermalParse() throws JETException {
        this.parser = this.configureParser(this.reader);
        this.beginPageProcessing();
        this.parser.parse();
        this.endPageProcessing();
        this.compilationUnit.accept(new TextTrimmingVisitor());
    }

    public void handleEmbeddedExpression(String language, JETMark start, JETMark stop) throws JETException {
        throw new IllegalStateException();
    }

    public static final class IncludeFailAction {
        public static final IncludeFailAction ERROR = new IncludeFailAction("error");
        public static final IncludeFailAction SILENT = new IncludeFailAction("silent");
        public static final IncludeFailAction ALTERNATIVE = new IncludeFailAction("alternative");
        private final String displayValue;

        private IncludeFailAction(String displayValue) {
            this.displayValue = displayValue;
        }

        public String toString() {
            return this.displayValue;
        }

        public static IncludeFailAction getAction(String action) {
            if ("alternative".equalsIgnoreCase(action)) {
                return ALTERNATIVE;
            }
            if ("silent".equalsIgnoreCase(action)) {
                return SILENT;
            }
            return ERROR;
        }
    }
}

