/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.core.expressions.IEmbeddedExpression;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;

public abstract class AbstractCustomTag
implements CustomTag {
    private CustomTag parent;
    private JET2Context context = null;
    private TagInfo td = null;
    private JET2Writer out = null;

    public final CustomTag getParent() {
        return this.parent;
    }

    public final void setParent(CustomTag parent) {
        this.parent = parent;
    }

    public final void setContext(JET2Context context) {
        if (this.context != null) {
            throw new IllegalStateException("Context already set.");
        }
        this.context = context;
    }

    public final void setTagInfo(TagInfo td) {
        if (this.td != null) {
            throw new IllegalStateException("TagInfo already set.");
        }
        this.td = td;
    }

    public final String getRawAttribute(String name) {
        if (this.td == null) {
            throw new IllegalStateException("TagInfo not set.");
        }
        return this.td.getAttribute(name);
    }

    public final String getAttribute(String name) throws JET2TagException {
        String raw = this.getRawAttribute(name);
        if (raw != null) {
            IEmbeddedExpression expr = this.context.getExpressionFactory().createExpression(raw);
            return expr.isText() ? XPathContextExtender.resolveDynamic(raw, this.context) : expr.evalAsString(this.context);
        }
        return null;
    }

    public final void setOut(JET2Writer out) {
        if (this.out != null) {
            throw new IllegalStateException("out already set.");
        }
        this.out = out;
    }

    public final JET2Writer getOut() {
        return this.out;
    }
}

