/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.parser.resources;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.TemplateInputException;

public class ResourceTemplateInput
implements ITemplateInput {
    private final IFile file;

    public ResourceTemplateInput(IFile file) {
        this.file = file;
    }

    public URI getBaseLocation() {
        try {
            return new URI("platform", "/resource/" + this.file.getProject().getName() + "/", null);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException wrapper = new IllegalArgumentException();
            wrapper.initCause(e);
            throw wrapper;
        }
    }

    public Reader getReader() throws TemplateInputException {
        try {
            return new BufferedReader(new InputStreamReader(this.file.getContents(), this.file.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateInputException((Throwable)e);
        }
        catch (CoreException e) {
            throw new TemplateInputException((Throwable)e);
        }
    }

    public String getTemplatePath() {
        return this.file.getProjectRelativePath().toString();
    }

    public String getEncoding() throws TemplateInputException {
        try {
            return this.file.getCharset();
        }
        catch (CoreException e) {
            throw new TemplateInputException((Throwable)e);
        }
    }
}

