/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.text.MessageFormat;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.internal.runtime.SafeCustomRuntimeTag;
import org.eclipse.jet.taglib.ContainerTag;

public class SafeContainerRuntimeTag
extends SafeCustomRuntimeTag {
    protected boolean bodyProcessed = false;
    protected boolean okToProcessBodyCalled = false;

    public SafeContainerRuntimeTag(ContainerTag tag) {
        super(tag);
    }

    public void doStart(JET2Context startContext, JET2Writer startOut) {
        super.doStart(startContext, startOut);
        this.bodyProcessed = false;
    }

    public void doEnd() {
        if (!this.okToProcessBodyCalled) {
            Platform.run((ISafeRunnable)new SafeCustomRuntimeTag.TagSafeRunnable(this){

                public void doRun() throws Exception {
                    ContainerTag untrustedTag = (ContainerTag)SafeContainerRuntimeTag.this.getUntrustedTag();
                    untrustedTag.doAction(SafeContainerRuntimeTag.this.getTagInfo(), SafeContainerRuntimeTag.this.getContext(), SafeContainerRuntimeTag.this.getWriter());
                }
            });
            RuntimeLoggerContextExtender.log(this.getContext(), JET2Messages.TraceRuntimeTags_ActionCompleted, this.getTagInfo(), 2);
        }
    }

    public boolean okToProcessBody() {
        this.okToProcessBodyCalled = true;
        if (!this.bodyProcessed) {
            Platform.run((ISafeRunnable)new SafeCustomRuntimeTag.TagSafeRunnable(this){

                public void doRun() throws Exception {
                    ContainerTag untrustedTag = (ContainerTag)SafeContainerRuntimeTag.this.getUntrustedTag();
                    untrustedTag.doBeforeBody(SafeContainerRuntimeTag.this.getTagInfo(), SafeContainerRuntimeTag.this.getContext(), SafeContainerRuntimeTag.this.getWriter());
                }
            });
            RuntimeLoggerContextExtender.log(this.getContext(), JET2Messages.TraceRuntimeTags_BeforeBodyCompleted, this.getTagInfo(), 2);
        }
        return !this.bodyProcessed;
    }

    public void handleBodyContent(final JET2Writer bodyContent) {
        this.bodyProcessed = true;
        Platform.run((ISafeRunnable)new SafeCustomRuntimeTag.TagSafeRunnable(this){

            public void doRun() throws Exception {
                ContainerTag untrustedTag = (ContainerTag)SafeContainerRuntimeTag.this.getUntrustedTag();
                if (bodyContent != SafeContainerRuntimeTag.this.getWriter()) {
                    RuntimeLoggerContextExtender.log(SafeContainerRuntimeTag.this.getContext(), MessageFormat.format(JET2Messages.TraceRuntimeTags_SetBodyContents, ((BufferedJET2Writer)bodyContent).getContent()), SafeContainerRuntimeTag.this.getTagInfo(), 2);
                    untrustedTag.setBodyContent(bodyContent);
                }
                untrustedTag.doAfterBody(SafeContainerRuntimeTag.this.getTagInfo(), SafeContainerRuntimeTag.this.getContext(), SafeContainerRuntimeTag.this.getWriter());
            }
        });
    }
}

