/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.extensionpoints.TransformData;
import org.eclipse.jet.internal.taglib.TagLibraryReferenceImpl;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPath;
import org.eclipse.jet.xpath.XPathException;
import org.eclipse.jet.xpath.XPathExpression;
import org.eclipse.jet.xpath.XPathFactory;

public class TransformDataFactory {
    public static final String E_TRANSFORM = "transform";
    public static final String A_TRANSFORM_STARTTEMPLATE = "startTemplate";
    public static final String A_TRANSFORM_TEMPLATELOADERCLASS = "templateLoaderClass";
    public static final String A_TRANSFORM_MODELLOADER = "modelLoader";
    public static final String A_TRANSFORM_MODELEXTENSION = "modelExtension";
    public static final String A_TRANSFORM_OVERRIDES = "overrides";
    public static final String E_TAGLIBRARIES = "tagLibraries";
    public static final String E_IMPORTLIBRARY = "importLibrary";
    public static final String A_IMPORTLIBRARY_ID = "id";
    public static final String A_IMPORTLIBRARY_USEPREFIX = "usePrefix";
    public static final String A_IMPORTLIBRARY_AUTOIMPORT = "autoImport";
    public static final String E_DESCRIPTION = "description";
    public static final TransformDataFactory INSTANCE = new TransformDataFactory();
    private static final String A_TRANSFORM_PRIVATE = "private";
    private static final String A_TRANSFORM_MODELSCHEMA = "modelSchema";
    private static final String A_EMBEDDED_EXPRESSIONS = "enableEmbeddedExpressions";
    private boolean expresionsInitialized = false;
    private XPathExpression xTransform;
    private XPathExpression xTransformModelLoader;
    private XPathExpression xTransformModelExtension;
    private XPathExpression xTransformOverrides;
    private XPathExpression xTransformStartTemplate;
    private XPathExpression xTransformTemplateLoaderClass;
    private XPathExpression xTransformPrivate;
    private XPathExpression xTransformModelSchema;
    private XPathExpression xDescription;
    private XPathExpression xTagLibrariesImportLibrary;
    private XPathExpression xImportLibraryId;
    private XPathExpression xImportLibraryUsePrefix;
    private XPathExpression xImportLibraryAutoImport;
    private XPathExpression xEmbeddedExpressions;

    private TransformDataFactory() {
    }

    private void initXPathExpressions() throws XPathException {
        if (!this.expresionsInitialized) {
            XPath xpath = XPathFactory.newInstance().newXPath(null);
            this.xTransform = xpath.compile("/plugin/extension[@point = 'org.eclipse.jet.transform']/transform");
            this.xTransformModelLoader = xpath.compile("@modelLoader");
            this.xTransformModelExtension = xpath.compile("@modelExtension");
            this.xTransformOverrides = xpath.compile("@overrides");
            this.xTransformStartTemplate = xpath.compile("@startTemplate");
            this.xTransformTemplateLoaderClass = xpath.compile("@templateLoaderClass");
            this.xTransformPrivate = xpath.compile("@private");
            this.xTransformModelSchema = xpath.compile("@modelSchema");
            this.xDescription = xpath.compile(E_DESCRIPTION);
            this.xTagLibrariesImportLibrary = xpath.compile("tagLibraries/importLibrary");
            this.xImportLibraryId = xpath.compile("@id");
            this.xImportLibraryUsePrefix = xpath.compile("@usePrefix");
            this.xImportLibraryAutoImport = xpath.compile("@autoImport");
            this.xEmbeddedExpressions = xpath.compile("@enableEmbeddedExpressions");
            this.expresionsInitialized = true;
        }
    }

    public TransformData createTransformData(String transformId, URL pluginURL) {
        TransformData transformData = null;
        try {
            URL extensionsURL = new URL(pluginURL, "plugin.xml");
            Object resource = JETActivatorWrapper.INSTANCE.getLoaderManager().getLoader(extensionsURL.toExternalForm(), "org.eclipse.jet.xml", null).load(extensionsURL);
            this.initXPathExpressions();
            NodeSet transformSet = this.xTransform.evaluateAsNodeSet(resource);
            if (transformSet.size() > 0) {
                transformData = this.createTransformData(transformId, transformSet.iterator().next());
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreJETException e) {
            InternalJET2Platform.logError("", e);
        }
        catch (XPathException e) {
            InternalJET2Platform.logError("", e);
        }
        return transformData;
    }

    public TransformData createTransformData(String transformId, Object transform) {
        String modelLoaderId = this.xTransformModelLoader.evaluateAsString(transform);
        String modelExtension = this.xTransformModelExtension.evaluateAsString(transform);
        String overridesId = this.xTransformOverrides.evaluateAsString(transform);
        String mainTemplate = this.xTransformStartTemplate.evaluateAsString(transform);
        String templateLoaderClassName = this.xTransformTemplateLoaderClass.evaluateAsString(transform);
        String description = this.xDescription.evaluateAsString(transform);
        String privateTransform = this.xTransformPrivate.evaluateAsString(transform);
        String modelSchema = this.xTransformModelSchema.evaluateAsString(transform);
        String strEmbeddedExpressions = this.xEmbeddedExpressions.evaluateAsString(transform);
        NodeSet importNodes = this.xTagLibrariesImportLibrary.evaluateAsNodeSet(transform);
        ArrayList<TagLibraryReferenceImpl> tlRefs = new ArrayList<TagLibraryReferenceImpl>();
        Iterator i = importNodes.iterator();
        while (i.hasNext()) {
            Object importCtx = i.next();
            String tlId = this.xImportLibraryId.evaluateAsString(importCtx);
            String tlPrefix = this.xImportLibraryUsePrefix.evaluateAsString(importCtx);
            boolean autoImport = Boolean.valueOf(this.xImportLibraryAutoImport.evaluateAsString(importCtx));
            TagLibraryReferenceImpl tlRef = new TagLibraryReferenceImpl(tlPrefix, tlId, autoImport);
            tlRefs.add(tlRef);
        }
        TransformData transformData = new TransformData(transformId, overridesId, modelLoaderId, modelExtension, templateLoaderClassName, mainTemplate, tlRefs.toArray(new TagLibraryReference[tlRefs.size()]), description, Boolean.valueOf(privateTransform), modelSchema, strEmbeddedExpressions != null ? Boolean.valueOf(strEmbeddedExpressions) : false);
        return transformData;
    }

    public TransformData createTransformData(IConfigurationElement element) throws InvalidRegistryObjectException {
        TransformData transformData = null;
        if (element != null && E_TRANSFORM.equals(element.getName())) {
            String transformId = element.getDeclaringExtension().getNamespace();
            String modelLoaderId = element.getAttribute(A_TRANSFORM_MODELLOADER);
            String modelExtension = element.getAttribute(A_TRANSFORM_MODELEXTENSION);
            String overridesId = element.getAttribute(A_TRANSFORM_OVERRIDES);
            String mainTemplate = element.getAttribute(A_TRANSFORM_STARTTEMPLATE);
            String templateLoaderClassName = element.getAttribute(A_TRANSFORM_TEMPLATELOADERCLASS);
            String privateTransform = element.getAttribute(A_TRANSFORM_PRIVATE);
            String modelSchema = element.getAttribute(A_TRANSFORM_MODELSCHEMA);
            String strEnableEmbeddedExpressions = element.getAttribute(A_EMBEDDED_EXPRESSIONS);
            TagLibraryReference[] tlRefs = this.getTagLibraryReferences(element);
            String description = this.getDescription(element);
            transformData = new TransformData(transformId, overridesId, modelLoaderId, modelExtension, templateLoaderClassName, mainTemplate, tlRefs, description, privateTransform == null ? false : Boolean.valueOf(privateTransform), modelSchema, strEnableEmbeddedExpressions != null ? Boolean.valueOf(strEnableEmbeddedExpressions) : false);
        }
        return transformData;
    }

    private String getDescription(IConfigurationElement element) {
        String description = "";
        IConfigurationElement[] descElements = element.getChildren(E_DESCRIPTION);
        if (descElements.length > 0) {
            description = descElements[0].getValue();
        }
        return description;
    }

    private TagLibraryReference[] getTagLibraryReferences(IConfigurationElement element) throws InvalidRegistryObjectException {
        ArrayList<TagLibraryReferenceImpl> tlRefs = new ArrayList<TagLibraryReferenceImpl>();
        IConfigurationElement[] tlElements = element.getChildren(E_TAGLIBRARIES);
        int j = 0;
        while (j < tlElements.length) {
            IConfigurationElement tlElement = tlElements[j];
            IConfigurationElement[] tlImports = tlElement.getChildren(E_IMPORTLIBRARY);
            int k = 0;
            while (k < tlImports.length) {
                String tlId = tlImports[k].getAttribute(A_IMPORTLIBRARY_ID);
                String tlPrefix = tlImports[k].getAttribute(A_IMPORTLIBRARY_USEPREFIX);
                boolean autoImport = Boolean.valueOf(tlImports[k].getAttribute(A_IMPORTLIBRARY_AUTOIMPORT));
                TagLibraryReferenceImpl tlRef = new TagLibraryReferenceImpl(tlPrefix, tlId, autoImport);
                tlRefs.add(tlRef);
                ++k;
            }
            ++j;
        }
        return tlRefs.toArray(new TagLibraryReference[tlRefs.size()]);
    }
}

